/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    private float[] scale;
    private float[] offsets;
    private RenderingHints hints = null;

    public RescaleOp(float[] fArray, float[] fArray2, RenderingHints renderingHints) {
        int n = Math.min(fArray.length, fArray2.length);
        this.scale = new float[n];
        System.arraycopy(fArray, 0, this.scale, 0, n);
        this.offsets = new float[n];
        System.arraycopy(fArray2, 0, this.offsets, 0, n);
        this.hints = renderingHints;
    }

    public RescaleOp(float f, float f2, RenderingHints renderingHints) {
        this.scale = new float[]{f};
        this.offsets = new float[]{f2};
        this.hints = renderingHints;
    }

    public final float[] getScaleFactors(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.scale.length];
        }
        System.arraycopy(this.scale, 0, fArray, 0, Math.min(this.scale.length, fArray.length));
        return fArray;
    }

    public final float[] getOffsets(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.offsets.length];
        }
        System.arraycopy(this.offsets, 0, fArray, 0, Math.min(this.offsets.length, fArray.length));
        return fArray;
    }

    public final int getNumFactors() {
        return this.scale.length;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.scale.length != 1 && this.scale.length != bufferedImage.getColorModel().getNumComponents() && this.scale.length != bufferedImage.getColorModel().getNumColorComponents()) {
            throw new IllegalArgumentException("Source image has wrong number of bands for these scaling factors.");
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (bufferedImage.getHeight() != bufferedImage2.getHeight() || bufferedImage.getWidth() != bufferedImage2.getWidth()) {
            throw new IllegalArgumentException("Source and destination images are different sizes.");
        }
        BufferedImage bufferedImage3 = bufferedImage2;
        if (bufferedImage2.getColorModel().getColorSpace().getType() != bufferedImage.getColorModel().getColorSpace().getType()) {
            bufferedImage3 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        int n = this.scale.length;
        if (this.scale.length == 1) {
            n = bufferedImage.getColorModel().getNumColorComponents();
        }
        boolean[] blArray = new boolean[n];
        Arrays.fill(blArray, true);
        this.filter(bufferedImage.getRaster(), bufferedImage3.getRaster(), blArray);
        if (bufferedImage.getColorModel().hasAlpha() && n == bufferedImage.getColorModel().getNumColorComponents()) {
            bufferedImage3.getRaster().setSamples(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), n, bufferedImage.getRaster().getSamples(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), n, (int[])null));
        }
        if (bufferedImage2 != bufferedImage3) {
            new ColorConvertOp(this.hints).filter(bufferedImage3, bufferedImage2);
        }
        return bufferedImage2;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (this.scale.length != 1 && this.scale.length != raster.numBands) {
            throw new IllegalArgumentException("Number of rasters is incompatible with the number of scaling factors provided.");
        }
        if (writableRaster == null) {
            writableRaster = raster.createCompatibleWritableRaster();
        } else {
            if (raster.getHeight() != writableRaster.getHeight() || raster.getWidth() != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Source and destination rasters are different sizes.");
            }
            if (raster.numBands != writableRaster.numBands) {
                throw new IllegalArgumentException("Source and destination rasters are incompatible.");
            }
        }
        boolean[] blArray = new boolean[raster.getNumBands()];
        Arrays.fill(blArray, true);
        return this.filter(raster, writableRaster, blArray);
    }

    private WritableRaster filter(Raster raster, WritableRaster writableRaster, boolean[] blArray) {
        int n;
        int[] nArray = new int[raster.getHeight() * raster.getWidth()];
        int[] nArray2 = raster.getSampleModel().getSampleSize();
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = (int)Math.pow(2.0, nArray2[n]) - 1;
        }
        for (n = 0; n < blArray.length; ++n) {
            float f;
            float f2;
            if (!blArray[n]) continue;
            nArray = raster.getSamples(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), n, nArray);
            if (this.scale.length == 1) {
                f2 = this.scale[0];
                f = this.offsets[0];
            } else {
                f2 = this.scale[n];
                f = this.offsets[n];
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (int)((float)nArray[i] * f2 + f);
                if (nArray[i] < 0) {
                    nArray[i] = 0;
                }
                if (nArray[i] <= nArray2[n]) continue;
                nArray[i] = nArray2[n];
            }
            writableRaster.setSamples(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), n, nArray);
        }
        return writableRaster;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        }
        return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isAlphaPremultiplied(), null);
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = (Point2D)point2D.clone();
        } else {
            point2D2.setLocation(point2D);
        }
        return point2D2;
    }
}

