/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

public abstract class DataBuffer {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_USHORT = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DOUBLE = 5;
    public static final int TYPE_UNDEFINED = 32;
    protected int dataType;
    protected int banks = 1;
    protected int offset;
    protected int size;
    protected int[] offsets;

    protected DataBuffer(int n, int n2) {
        this(n, n2, 1);
    }

    protected DataBuffer(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    protected DataBuffer(int n, int n2, int n3, int n4) {
        this.banks = n3;
        this.dataType = n;
        this.size = n2;
        this.offset = n4;
        this.offsets = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.offsets[i] = n4;
        }
    }

    protected DataBuffer(int n, int n2, int n3, int[] nArray) {
        if (n3 != nArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.dataType = n;
        this.size = n2;
        this.banks = n3;
        this.offsets = nArray;
        this.offset = nArray[0];
    }

    public static int getDataTypeSize(int n) {
        switch (n) {
            case 0: {
                return 8;
            }
            case 1: 
            case 2: {
                return 16;
            }
            case 3: 
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getOffsets() {
        if (this.offsets == null) {
            this.offsets = new int[1];
            this.offsets[0] = this.offset;
        }
        return this.offsets;
    }

    public int getNumBanks() {
        return this.banks;
    }

    public int getElem(int n) {
        return this.getElem(0, n);
    }

    public abstract int getElem(int var1, int var2);

    public void setElem(int n, int n2) {
        this.setElem(0, n, n2);
    }

    public abstract void setElem(int var1, int var2, int var3);

    public float getElemFloat(int n) {
        return this.getElem(n);
    }

    public float getElemFloat(int n, int n2) {
        return this.getElem(n, n2);
    }

    public void setElemFloat(int n, float f) {
        this.setElem(n, (int)f);
    }

    public void setElemFloat(int n, int n2, float f) {
        this.setElem(n, n2, (int)f);
    }

    public double getElemDouble(int n) {
        return this.getElem(n);
    }

    public double getElemDouble(int n, int n2) {
        return this.getElem(n, n2);
    }

    public void setElemDouble(int n, double d) {
        this.setElem(n, (int)d);
    }

    public void setElemDouble(int n, int n2, double d) {
        this.setElem(n, n2, (int)d);
    }
}

