/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import gnu.java.awt.ClasspathGraphicsEnvironment;
import gnu.java.awt.ComponentDataBlitOp;
import gnu.java.lang.CPStringBuilder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImage
extends Image
implements WritableRenderedImage,
Transparency {
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    Vector<TileObserver> tileObservers;
    WritableRaster raster;
    ColorModel colorModel;
    Hashtable properties;
    boolean isPremultiplied;
    int type;
    private static final Point[] tileIndices = new Point[]{new Point()};

    public BufferedImage(int n, int n2, int n3) {
        Object object;
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        boolean bl = n3 == 3 || n3 == 7;
        switch (n3) {
            case 1: {
                sampleModel = new SinglePixelPackedSampleModel(3, n, n2, new int[]{0xFF0000, 65280, 255});
                colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                break;
            }
            case 5: {
                sampleModel = new PixelInterleavedSampleModel(0, n, n2, 3, n * 3, new int[]{2, 1, 0});
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                break;
            }
            case 2: 
            case 3: {
                sampleModel = new SinglePixelPackedSampleModel(3, n, n2, new int[]{0xFF0000, 65280, 255, -16777216});
                if (bl) {
                    colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, Buffers.smallestAppropriateTransferType(32));
                    break;
                }
                colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                break;
            }
            case 6: 
            case 7: {
                sampleModel = new PixelInterleavedSampleModel(0, n, n2, 4, 4 * n, new int[]{3, 2, 1, 0});
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, bl, 3, 0);
                break;
            }
            case 4: {
                sampleModel = new SinglePixelPackedSampleModel(3, n, n2, new int[]{255, 65280, 0xFF0000});
                colorModel = new DirectColorModel(24, 255, 65280, 0xFF0000);
                break;
            }
            case 8: {
                sampleModel = new SinglePixelPackedSampleModel(1, n, n2, new int[]{63488, 2016, 31});
                colorModel = new DirectColorModel(16, 63488, 2016, 31);
                break;
            }
            case 9: {
                sampleModel = new SinglePixelPackedSampleModel(1, n, n2, new int[]{31744, 992, 31});
                colorModel = new DirectColorModel(15, 31744, 992, 31);
                break;
            }
            case 13: {
                colorModel = this.createDefaultIndexedColorModel(false);
            }
            case 10: {
                sampleModel = new PixelInterleavedSampleModel(0, n, n2, 1, n, new int[]{0});
                break;
            }
            case 11: {
                sampleModel = new PixelInterleavedSampleModel(1, n, n2, 1, n, new int[]{0});
                break;
            }
            case 12: {
                colorModel = this.createDefaultIndexedColorModel(true);
                sampleModel = new MultiPixelPackedSampleModel(0, n, n2, 1);
                break;
            }
            default: {
                sampleModel = null;
            }
        }
        if (sampleModel == null) {
            throw new IllegalArgumentException("Unknown predefined image type.");
        }
        if (colorModel == null) {
            int n4;
            object = new int[1];
            if (n3 == 10) {
                n4 = 0;
                object[0] = 8;
            } else {
                n4 = 1;
                object[0] = 16;
            }
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            colorModel = new ComponentColorModel(colorSpace, (int[])object, false, false, 1, n4);
        }
        WritableRaster writableRaster = null;
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (object instanceof ClasspathGraphicsEnvironment) {
            writableRaster = ((ClasspathGraphicsEnvironment)object).createRaster(colorModel, sampleModel);
        }
        if (writableRaster == null) {
            writableRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        }
        this.init(colorModel, writableRaster, bl, null, n3);
    }

    public BufferedImage(int n, int n2, int n3, IndexColorModel indexColorModel) {
        if (n3 != 12 && n3 != 13) {
            throw new IllegalArgumentException("Type must be TYPE_BYTE_BINARY or TYPE_BYTE_INDEXED");
        }
        if (indexColorModel.getMapSize() > 16 && n3 == 12) {
            throw new IllegalArgumentException("Type TYPE_BYTE_BINARY cannot have a larger than 16-color palette.");
        }
        if (indexColorModel.getMapSize() > 256) {
            throw new IllegalArgumentException("Byte type cannot have a larger than 256-color palette.");
        }
        this.init(indexColorModel, indexColorModel.createCompatibleWritableRaster(n, n2), indexColorModel.isAlphaPremultiplied(), null, n3);
    }

    public BufferedImage(ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable<?, ?> hashtable) {
        this.init(colorModel, writableRaster, bl, hashtable, 0);
    }

    private void init(ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable hashtable, int n) {
        this.raster = writableRaster;
        this.colorModel = colorModel;
        this.properties = hashtable;
        this.isPremultiplied = bl;
        this.type = n;
    }

    private IndexColorModel createDefaultIndexedColorModel(boolean bl) {
        if (bl) {
            byte[] byArray = new byte[]{0, -1};
            return new IndexColorModel(1, 2, byArray, byArray, byArray);
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 6; ++k) {
                    byArray[n] = (byte)(i * 51);
                    byArray2[n] = (byte)(j * 51);
                    byArray3[n] = (byte)(k * 51);
                    ++n;
                }
            }
        }
        while (n < 256) {
            byArray2[n] = byArray3[n] = (byte)(18 + (n - 216) * 6);
            byArray[n] = byArray3[n];
            ++n;
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    public void coerceData(boolean bl) {
        this.colorModel = this.colorModel.coerceData(this.raster, bl);
        this.isPremultiplied = bl;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4;
        WritableRaster writableRaster2;
        if (writableRaster == null) {
            writableRaster = this.raster.createCompatibleWritableRaster(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        }
        if ((writableRaster2 = this.raster.createWritableChild(n4 = writableRaster.getMinX(), n3 = writableRaster.getMinY(), n2 = writableRaster.getWidth(), n = writableRaster.getHeight(), n4, n3, null)).getSampleModel() instanceof ComponentSampleModel && writableRaster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentDataBlitOp.INSTANCE.filter(writableRaster2, writableRaster);
        } else {
            int[] nArray = writableRaster2.getPixels(n4, n3, n2, n, (int[])null);
            writableRaster.setPixels(n4, n3, n2, n, nArray);
        }
        return writableRaster;
    }

    public Graphics2D createGraphics() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.createGraphics(this);
    }

    @Override
    public void flush() {
    }

    public WritableRaster getAlphaRaster() {
        return this.colorModel.getAlphaRaster(this.raster);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Raster getData() {
        return this.copyData(null);
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        WritableRaster writableRaster = this.raster.createCompatibleWritableRaster(rectangle);
        return this.copyData(writableRaster);
    }

    @Override
    public Graphics getGraphics() {
        return this.createGraphics();
    }

    @Override
    public int getHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.getHeight();
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getMinX() {
        return 0;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public Object getProperty(String string) {
        Object v;
        if (string == null) {
            throw new NullPointerException("The property name cannot be null.");
        }
        Object object = Image.UndefinedProperty;
        if (this.properties != null && (v = this.properties.get(string)) != null) {
            object = v;
        }
        return object;
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        return this.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return null;
    }

    public int getRGB(int n, int n2) {
        Object object = this.raster.getDataElements(n, n2, null);
        return this.colorModel.getRGB(object);
    }

    public int[] getRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7;
        if (nArray == null) {
            n7 = (n4 - 1) * n6 + n3;
            nArray = new int[n7];
        }
        n7 = n + n3;
        int n8 = n2 + n4;
        Object object = null;
        for (int i = n2; i < n8; ++i) {
            int n9 = n5;
            for (int j = n; j < n7; ++j) {
                object = this.raster.getDataElements(j, i, object);
                int n10 = this.colorModel.getRGB(object);
                nArray[n9++] = n10;
            }
            n5 += n6;
        }
        return nArray;
    }

    public WritableRaster getRaster() {
        return this.raster;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.raster.getSampleModel();
    }

    @Override
    public ImageProducer getSource() {
        return new ImageProducer(){
            Vector<ImageConsumer> consumers = new Vector();

            public void addConsumer(ImageConsumer imageConsumer) {
                if (!this.consumers.contains(imageConsumer)) {
                    this.consumers.add(imageConsumer);
                }
            }

            public boolean isConsumer(ImageConsumer imageConsumer) {
                return this.consumers.contains(imageConsumer);
            }

            public void removeConsumer(ImageConsumer imageConsumer) {
                this.consumers.remove(imageConsumer);
            }

            public void startProduction(ImageConsumer imageConsumer) {
                int n = 0;
                int n2 = 0;
                int n3 = BufferedImage.this.getWidth();
                int n4 = BufferedImage.this.getHeight();
                int n5 = n3;
                int n6 = 0;
                int[] nArray = BufferedImage.this.getRGB(n, n2, n3, n4, null, n6, n5);
                DirectColorModel directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                this.consumers.add(imageConsumer);
                for (int i = 0; i < this.consumers.size(); ++i) {
                    ImageConsumer imageConsumer2 = this.consumers.elementAt(i);
                    imageConsumer2.setHints(8);
                    imageConsumer2.setDimensions(BufferedImage.this.getWidth(), BufferedImage.this.getHeight());
                    imageConsumer2.setPixels(n, n2, n3, n4, (ColorModel)directColorModel, nArray, n6, n5);
                    imageConsumer2.imageComplete(3);
                }
            }

            public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
                this.startProduction(imageConsumer);
            }
        };
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    public BufferedImage getSubimage(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = this.getRaster().createWritableChild(n, n2, n3, n4, 0, 0, null);
        return new BufferedImage(this.getColorModel(), writableRaster, this.isPremultiplied, this.properties);
    }

    @Override
    public Raster getTile(int n, int n2) {
        return this.getWritableTile(n, n2);
    }

    @Override
    public int getTileGridXOffset() {
        return 0;
    }

    @Override
    public int getTileGridYOffset() {
        return 0;
    }

    @Override
    public int getTileHeight() {
        return this.getHeight();
    }

    @Override
    public int getTileWidth() {
        return this.getWidth();
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int getWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.getWidth();
    }

    @Override
    public WritableRaster getWritableTile(int n, int n2) {
        this.isTileWritable(n, n2);
        return this.raster;
    }

    @Override
    public Point[] getWritableTileIndices() {
        return tileIndices;
    }

    @Override
    public boolean hasTileWriters() {
        return true;
    }

    public boolean isAlphaPremultiplied() {
        return this.isPremultiplied;
    }

    @Override
    public boolean isTileWritable(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new ArrayIndexOutOfBoundsException("only tile is (0,0)");
        }
        return true;
    }

    @Override
    public void releaseWritableTile(int n, int n2) {
        this.isTileWritable(n, n2);
    }

    @Override
    public void setData(Raster raster) {
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        WritableRaster writableRaster = this.raster.createWritableChild(n, n2, n3, n4, n, n2, null);
        if (raster.getSampleModel() instanceof ComponentSampleModel && writableRaster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentDataBlitOp.INSTANCE.filter(raster, writableRaster);
        } else {
            int[] nArray = raster.getPixels(n, n2, n3, n4, (int[])null);
            writableRaster.setPixels(n, n2, n3, n4, nArray);
        }
    }

    public void setRGB(int n, int n2, int n3) {
        Object object = this.colorModel.getDataElements(n3, null);
        this.raster.setDataElements(n, n2, object);
    }

    public void setRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n + n3;
        int n8 = n2 + n4;
        Object object = null;
        for (int i = n2; i < n8; ++i) {
            int n9 = n5;
            for (int j = n; j < n7; ++j) {
                int n10 = nArray[n9++];
                object = this.colorModel.getDataElements(n10, object);
                this.raster.setDataElements(j, i, object);
            }
            n5 += n6;
        }
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(120);
        cPStringBuilder.append("BufferedImage@");
        cPStringBuilder.append(Integer.toHexString(this.hashCode()));
        cPStringBuilder.append(": type=");
        cPStringBuilder.append(this.type);
        cPStringBuilder.append(' ');
        cPStringBuilder.append(this.colorModel);
        cPStringBuilder.append(' ');
        cPStringBuilder.append(this.raster);
        return cPStringBuilder.toString();
    }

    @Override
    public void addTileObserver(TileObserver tileObserver) {
        if (this.tileObservers == null) {
            this.tileObservers = new Vector();
        }
        this.tileObservers.add(tileObserver);
    }

    @Override
    public void removeTileObserver(TileObserver tileObserver) {
        if (this.tileObservers == null) {
            return;
        }
        this.tileObservers.remove(tileObserver);
    }

    @Override
    public int getTransparency() {
        return this.colorModel.getTransparency();
    }
}

