/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    public static final int TYPE_BILINEAR = 2;
    public static final int TYPE_BICUBIC = 3;
    private AffineTransform transform;
    private RenderingHints hints;

    public AffineTransformOp(AffineTransform affineTransform, int n) {
        this.transform = affineTransform;
        if (affineTransform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
        switch (n) {
            case 2: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case 3: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                break;
            }
            default: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
        }
    }

    public AffineTransformOp(AffineTransform affineTransform, RenderingHints renderingHints) {
        this.transform = affineTransform;
        this.hints = renderingHints;
        if (affineTransform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel != null) {
            return new BufferedImage(colorModel, this.createCompatibleDestRaster(bufferedImage.getRaster()), bufferedImage.isAlphaPremultiplied(), null);
        }
        if (bufferedImage.getType() == 3 || bufferedImage.getType() == 6 || bufferedImage.getType() == 7) {
            return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        }
        return new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        Rectangle2D rectangle2D = this.getBounds2D(raster);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            throw new RasterFormatException("width or height is 0");
        }
        return raster.createCompatibleWritableRaster((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == bufferedImage) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHints(this.hints);
        graphics2D.drawImage(bufferedImage, this.transform, null);
        return bufferedImage2;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == raster) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        if (raster.getNumBands() != writableRaster.getNumBands()) {
            throw new IllegalArgumentException("src and dst must have same number of bands");
        }
        if (ColorModel.getRGBdefault().isCompatibleSampleModel(raster.getSampleModel()) && ColorModel.getRGBdefault().isCompatibleSampleModel(writableRaster.getSampleModel())) {
            WritableRaster writableRaster2 = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(raster.getMinX(), raster.getMinY()));
            BufferedImage bufferedImage = new BufferedImage(ColorModel.getRGBdefault(), writableRaster2, false, null);
            BufferedImage bufferedImage2 = new BufferedImage(ColorModel.getRGBdefault(), writableRaster, false, null);
            return this.filter(bufferedImage, bufferedImage2).getRaster();
        }
        double[] dArray = new double[writableRaster.getHeight() * writableRaster.getWidth() * 2];
        double[] dArray2 = new double[writableRaster.getHeight() * writableRaster.getWidth() * 2];
        int n = 0;
        for (int i = 0; i < writableRaster.getWidth(); ++i) {
            for (int j = 0; j < writableRaster.getHeight(); ++j) {
                dArray[n++] = i;
                dArray[n++] = j;
            }
        }
        Rectangle rectangle = raster.getBounds();
        try {
            AffineTransform affineTransform = this.transform.createInverse();
            affineTransform.transform(dArray, 0, dArray2, 0, dArray.length / 2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ImagingOpException(noninvertibleTransformException.getMessage());
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
            this.filterNearest(raster, writableRaster, dArray, dArray2);
        } else if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            this.filterBilinear(raster, writableRaster, dArray, dArray2);
        } else {
            this.filterBicubic(raster, writableRaster, dArray, dArray2);
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return this.transform.createTransformedShape(raster.getBounds()).getBounds2D();
    }

    public final int getInterpolationType() {
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            return 2;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
            return 3;
        }
        return 1;
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return this.transform.transform(point2D, point2D2);
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final AffineTransform getTransform() {
        return this.transform;
    }

    private void filterNearest(Raster raster, WritableRaster writableRaster, double[] dArray, double[] dArray2) {
        Rectangle rectangle = raster.getBounds();
        for (int i = 0; i < dArray.length; i += 2) {
            int n;
            int n2 = (int)Math.round(dArray2[i]) + raster.getMinX();
            if (!rectangle.contains(n2, n = (int)Math.round(dArray2[i + 1]) + raster.getMinY())) continue;
            writableRaster.setDataElements((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), raster.getDataElements(n2, n, null));
        }
    }

    private void filterBilinear(Raster raster, WritableRaster writableRaster, double[] dArray, double[] dArray2) {
        Rectangle rectangle = raster.getBounds();
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        Object[] objectArray4 = null;
        double[] dArray3 = new double[raster.getNumBands()];
        for (int i = 0; i < dArray.length; i += 2) {
            int n;
            int n2 = (int)Math.round(dArray2[i]) + raster.getMinX();
            if (!rectangle.contains(n2, n = (int)Math.round(dArray2[i + 1]) + raster.getMinY())) continue;
            if (dArray2[i] >= (double)(raster.getWidth() - 1) || dArray2[i + 1] >= (double)(raster.getHeight() - 1)) {
                writableRaster.setDataElements((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), raster.getDataElements(n2, n, null));
                continue;
            }
            int n3 = (int)Math.floor(dArray2[i] + (double)raster.getMinX());
            int n4 = (int)Math.floor(dArray2[i + 1] + (double)raster.getMinY());
            double d = dArray2[i] + (double)raster.getMinX() - (double)n3;
            double d2 = dArray2[i + 1] + (double)raster.getMinY() - (double)n4;
            if (raster.getTransferType() == 5 || raster.getTransferType() == 4) {
                objectArray = raster.getPixel(n3, n4, (double[])objectArray);
                objectArray2 = raster.getPixel(n3 + 1, n4, (double[])objectArray2);
                objectArray3 = raster.getPixel(n3, n4 + 1, (double[])objectArray3);
                objectArray4 = raster.getPixel(n3 + 1, n4 + 1, (double[])objectArray4);
            } else {
                objectArray = raster.getPixel(n3, n4, (int[])objectArray);
                objectArray2 = raster.getPixel(n3 + 1, n4, (int[])objectArray2);
                objectArray3 = raster.getPixel(n3, n4 + 1, (int[])objectArray3);
                objectArray4 = raster.getPixel(n3 + 1, n4 + 1, (int[])objectArray4);
            }
            for (int j = 0; j < raster.getNumBands(); ++j) {
                double d3;
                double d4;
                double d5;
                double d6;
                if (raster.getTransferType() == 5 || raster.getTransferType() == 4) {
                    d6 = objectArray[j];
                    d5 = objectArray2[j];
                    d4 = objectArray3[j];
                    d3 = objectArray4[j];
                } else {
                    d6 = ((int[])objectArray)[j];
                    d5 = ((int[])objectArray2)[j];
                    d4 = ((int[])objectArray3)[j];
                    d3 = ((int[])objectArray4)[j];
                }
                dArray3[j] = d6 == d5 && d6 == d4 && d6 == d3 ? d6 : (d6 * (1.0 - d) + d5 * d) * (1.0 - d2) + (d4 * (1.0 - d) + d3 * d) * d2;
            }
            writableRaster.setPixel((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), dArray3);
        }
    }

    private void filterBicubic(Raster raster, WritableRaster writableRaster, double[] dArray, double[] dArray2) {
        Rectangle rectangle = raster.getBounds();
        double[] dArray3 = new double[raster.getNumBands()];
        Object[] objectArray = null;
        for (int i = 0; i < dArray.length; i += 2) {
            if (!rectangle.contains((int)Math.round(dArray2[i]) + raster.getMinX(), (int)Math.round(dArray2[i + 1]) + raster.getMinY())) continue;
            int n = (int)Math.floor(dArray2[i] + (double)raster.getMinX());
            int n2 = (int)Math.floor(dArray2[i + 1] + (double)raster.getMinY());
            double d = dArray2[i] + (double)raster.getMinX() - (double)n;
            double d2 = dArray2[i + 1] + (double)raster.getMinY() - (double)n2;
            Arrays.fill(dArray3, 0.0);
            for (int j = -1; j < 3; ++j) {
                for (int k = -1; k < 3; ++k) {
                    int n3;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = (double)j - d + 2.0;
                    d3 += d5 * d5 * d5;
                    d5 = (double)j - d + 1.0;
                    if (d5 > 0.0) {
                        d3 -= 4.0 * d5 * d5 * d5;
                    }
                    if ((d5 = (double)j - d) > 0.0) {
                        d3 += 6.0 * d5 * d5 * d5;
                    }
                    if ((d5 = (double)j - d - 1.0) > 0.0) {
                        d3 -= 4.0 * d5 * d5 * d5;
                    }
                    d3 /= 6.0;
                    d5 = d2 - (double)k + 2.0;
                    if (d5 > 0.0) {
                        d4 += d5 * d5 * d5;
                    }
                    if ((d5 = d2 - (double)k + 1.0) > 0.0) {
                        d4 -= 4.0 * d5 * d5 * d5;
                    }
                    if ((d5 = d2 - (double)k) > 0.0) {
                        d4 += 6.0 * d5 * d5 * d5;
                    }
                    if ((d5 = d2 - (double)k - 1.0) > 0.0) {
                        d4 -= 4.0 * d5 * d5 * d5;
                    }
                    d4 /= 6.0;
                    int n4 = n + j;
                    if (n4 >= raster.getMinX() + raster.getWidth()) {
                        n4 = raster.getMinX() + raster.getWidth() - 1;
                    } else if (n4 < raster.getMinX()) {
                        n4 = raster.getMinX();
                    }
                    int n5 = n2 + k;
                    if (n5 >= raster.getMinY() + raster.getHeight()) {
                        n5 = raster.getMinY() + raster.getHeight() - 1;
                    } else if (n5 < raster.getMinY()) {
                        n5 = raster.getMinY();
                    }
                    if (raster.getTransferType() == 5 || raster.getTransferType() == 4) {
                        objectArray = raster.getPixel(n4, n5, (double[])objectArray);
                        for (n3 = 0; n3 < dArray3.length; ++n3) {
                            int n6 = n3;
                            dArray3[n6] = dArray3[n6] + objectArray[n3] * d3 * d4;
                        }
                        continue;
                    }
                    objectArray = raster.getPixel(n4, n5, (int[])objectArray);
                    for (n3 = 0; n3 < dArray3.length; ++n3) {
                        int n7 = n3;
                        dArray3[n7] = dArray3[n7] + (double)((int[])objectArray)[n3] * d3 * d4;
                    }
                }
            }
            writableRaster.setPixel((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), dArray3);
        }
    }
}

