/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    protected RoundRectangle2D() {
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getWidth();
        if (d < d3 || d >= d3 + d4) {
            return false;
        }
        double d5 = this.getY();
        double d6 = this.getHeight();
        if (d2 < d5 || d2 >= d5 + d6) {
            return false;
        }
        double d7 = Math.min(Math.abs(d5 - d2), Math.abs(d5 + d6 - d2));
        double d8 = Math.min(Math.abs(d3 - d), Math.abs(d3 + d4 - d));
        double d9 = this.getArcWidth() / 2.0;
        double d10 = this.getArcHeight() / 2.0;
        if (d8 > d9 || d7 > d10) {
            return true;
        }
        return (d8 = (d9 - d8) / d9) * d8 + (d7 = (d10 - d7) / d10) * d7 <= 1.0;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4) && this.contains(d + d3, d2);
    }

    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        double d = Math.min(this.getArcWidth(), this.getWidth());
        double d2 = Math.min(this.getArcHeight(), this.getHeight());
        if (d <= 0.0 || d2 <= 0.0) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            return double_.getPathIterator(affineTransform);
        }
        if (d >= this.getWidth() && d2 >= this.getHeight()) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            return double_.getPathIterator(affineTransform);
        }
        return new PathIterator(){
            double x;
            double y;
            double w;
            double h;
            double arcW;
            double arcH;
            Arc2D.Double arc;
            PathIterator corner;
            int step;
            {
                this.x = RoundRectangle2D.this.getX();
                this.y = RoundRectangle2D.this.getY();
                this.w = RoundRectangle2D.this.getWidth();
                this.h = RoundRectangle2D.this.getHeight();
                this.arcW = Math.min(RoundRectangle2D.this.getArcWidth(), this.w);
                this.arcH = Math.min(RoundRectangle2D.this.getArcHeight(), this.h);
                this.arc = new Arc2D.Double();
                this.step = -1;
            }

            public int currentSegment(double[] dArray) {
                if (this.corner != null) {
                    int n = this.corner.currentSegment(dArray);
                    if (n == 0) {
                        n = 1;
                    }
                    return n;
                }
                if (this.step == -1) {
                    dArray[0] = this.x + this.w - this.arcW / 2.0;
                    dArray[1] = this.y;
                } else if (this.step == 0) {
                    dArray[0] = this.x + this.arcW / 2.0;
                    dArray[1] = this.y;
                } else if (this.step == 2) {
                    dArray[0] = this.x;
                    dArray[1] = this.y + this.h - this.arcH / 2.0;
                } else if (this.step == 4) {
                    dArray[0] = this.x + this.w - this.arcW / 2.0;
                    dArray[1] = this.y + this.h;
                } else if (this.step == 6) {
                    dArray[0] = this.x + this.w;
                    dArray[1] = this.y + this.arcH / 2.0;
                }
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 1);
                }
                return this.step == -1 ? 0 : 1;
            }

            public int currentSegment(float[] fArray) {
                if (this.corner != null) {
                    int n = this.corner.currentSegment(fArray);
                    if (n == 0) {
                        n = 1;
                    }
                    return n;
                }
                if (this.step == -1) {
                    fArray[0] = (float)(this.x + this.w - this.arcW / 2.0);
                    fArray[1] = (float)this.y;
                } else if (this.step == 0) {
                    fArray[0] = (float)(this.x + this.arcW / 2.0);
                    fArray[1] = (float)this.y;
                } else if (this.step == 2) {
                    fArray[0] = (float)this.x;
                    fArray[1] = (float)(this.y + this.h - this.arcH / 2.0);
                } else if (this.step == 4) {
                    fArray[0] = (float)(this.x + this.w - this.arcW / 2.0);
                    fArray[1] = (float)(this.y + this.h);
                } else if (this.step == 6) {
                    fArray[0] = (float)(this.x + this.w);
                    fArray[1] = (float)(this.y + this.arcH / 2.0);
                }
                if (affineTransform != null) {
                    affineTransform.transform(fArray, 0, fArray, 0, 1);
                }
                return this.step == -1 ? 0 : 1;
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.step >= 8;
            }

            public void next() {
                if (this.corner != null) {
                    this.corner.next();
                    if (this.corner.isDone()) {
                        this.corner = null;
                        ++this.step;
                    }
                } else {
                    ++this.step;
                    if (this.step == 1) {
                        this.arc.setArc(this.x, this.y, this.arcW, this.arcH, 90.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(affineTransform);
                    } else if (this.step == 3) {
                        this.arc.setArc(this.x, this.y + this.h - this.arcH, this.arcW, this.arcH, 180.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(affineTransform);
                    } else if (this.step == 5) {
                        this.arc.setArc(this.x + this.w - this.arcW, this.y + this.h - this.arcH, this.arcW, this.arcH, 270.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(affineTransform);
                    } else if (this.step == 7) {
                        this.arc.setArc(this.x + this.w - this.arcW, this.y, this.arcW, this.arcH, 0.0, 90.0, 0);
                        this.corner = this.arc.getPathIterator(affineTransform);
                    }
                }
            }
        };
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2 + d4) || this.contains(d + d3, d2);
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRoundRect(d, d2, d3, d4, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(RoundRectangle2D roundRectangle2D) {
        this.setRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    public static class Float
    extends RoundRectangle2D {
        public float archeight;
        public float arcwidth;
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.arcwidth = (float)d5;
            this.archeight = (float)d6;
        }
    }

    public static class Double
    extends RoundRectangle2D {
        public double archeight;
        public double arcwidth;
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }
    }
}

