/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class Ellipse2D
extends RectangularShape {
    protected Ellipse2D() {
    }

    public boolean contains(double d, double d2) {
        double d3;
        double d4 = this.getWidth() / 2.0;
        double d5 = this.getHeight() / 2.0;
        double d6 = (d - (this.getX() + d4)) / d4;
        return d6 * d6 + (d3 = (d2 - (this.getY() + d5)) / d5) * d3 < 1.0;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = d + d3;
        double d6 = d2 + d4;
        return this.contains(d, d2) && this.contains(d, d6) && this.contains(d5, d2) && this.contains(d5, d6);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new Arc2D.ArcIterator(this, affineTransform);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        if (!double_.intersects(this.getX(), this.getY(), this.getWidth(), this.getHeight())) {
            return false;
        }
        if (this.contains(d, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2) || this.contains(d + d3, d2 + d4)) {
            return true;
        }
        Line2D.Double double_2 = new Line2D.Double(this.getX(), this.getY() + this.getHeight() / 2.0, this.getX() + this.getWidth(), this.getY() + this.getHeight() / 2.0);
        Line2D.Double double_3 = new Line2D.Double(this.getX() + this.getWidth() / 2.0, this.getY(), this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight());
        return double_2.intersects(double_) || double_3.intersects(double_);
    }

    public static class Float
    extends Ellipse2D {
        public float height;
        public float width;
        public float x;
        public float y;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.height = f4;
            this.width = f3;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean isEmpty() {
            return this.height <= 0.0f || this.width <= 0.0f;
        }

        public void setFrame(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.height = f4;
            this.width = f3;
        }

        public void setFrame(double d, double d2, double d3, double d4) {
            this.x = (float)d;
            this.y = (float)d2;
            this.height = (float)d4;
            this.width = (float)d3;
        }
    }

    public static class Double
    extends Ellipse2D {
        public double height;
        public double width;
        public double x;
        public double y;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.height = d4;
            this.width = d3;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public boolean isEmpty() {
            return this.height <= 0.0 || this.width <= 0.0;
        }

        public void setFrame(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.height = d4;
            this.width = d3;
        }
    }
}

