/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;

public final class TextMeasurer
implements Cloneable {
    private AttributedCharacterIterator text;
    private FontRenderContext frc;
    private TextLayout totalLayout;
    private int numChars;

    public TextMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this.text = attributedCharacterIterator;
        this.frc = fontRenderContext;
        this.totalLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
        this.numChars = this.totalLayout.getCharacterCount();
    }

    protected Object clone() {
        return new TextMeasurer(this.text, this.frc);
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.totalLayout = new TextLayout(attributedCharacterIterator, this.frc);
        if (n < 0 || n > this.totalLayout.getCharacterCount()) {
            throw new NullPointerException("Invalid deletePos:" + n);
        }
        this.numChars = this.totalLayout.getCharacterCount();
        this.text = attributedCharacterIterator;
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.totalLayout = new TextLayout(attributedCharacterIterator, this.frc);
        if (n < 0 || n > this.totalLayout.getCharacterCount()) {
            throw new NullPointerException("Invalid insertPos:" + n);
        }
        this.numChars = this.totalLayout.getCharacterCount();
        this.text = attributedCharacterIterator;
    }

    public float getAdvanceBetween(int n, int n2) {
        Shape shape = this.totalLayout.getLogicalHighlightShape(n, n2);
        return (float)shape.getBounds2D().getWidth();
    }

    public TextLayout getLayout(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("Start position must be < limit.");
        }
        return new TextLayout(this.totalLayout, n, n2);
    }

    public int getLineBreakIndex(int n, float f) {
        double d;
        if (n < 0) {
            throw new IllegalArgumentException("Start parameter must be > 0.");
        }
        double d2 = this.getAdvanceBetween(n, this.numChars);
        int n2 = (int)((double)f / d2 * ((double)this.numChars - (double)n));
        if ((n2 += n) > this.numChars) {
            n2 = this.numChars;
        }
        boolean bl = (d = (double)this.getAdvanceBetween(n, n2)) > (double)f;
        int n3 = bl ? -1 : 1;
        boolean bl2 = true;
        do {
            if ((n2 += n3) <= n || n2 > this.numChars) {
                bl2 = false;
                continue;
            }
            d = this.getAdvanceBetween(n, n2);
            if (bl && d <= (double)f) {
                bl2 = false;
            }
            if (bl || !(d >= (double)f)) continue;
            bl2 = false;
        } while (bl2);
        if (!bl) {
            --n2;
        }
        if (n2 > this.numChars) {
            return this.numChars;
        }
        return n2;
    }
}

