/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import gnu.java.lang.CPStringBuilder;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextLayout
implements Cloneable {
    private Run[] runs;
    private FontRenderContext frc;
    private char[] string;
    private int offset;
    private int length;
    private Rectangle2D boundsCache;
    private LineMetrics lm;
    private float totalAdvance = -1.0f;
    private Rectangle2D naturalBounds;
    private int[][] charIndices;
    private boolean leftToRight;
    private boolean hasWhitespace = false;
    private Bidi bidi;
    private int[] logicalToVisual;
    private int[] visualToLogical;
    private int hash;
    public static final CaretPolicy DEFAULT_CARET_POLICY = new CaretPolicy();

    public TextLayout(String string, Font font, FontRenderContext fontRenderContext) {
        this.frc = fontRenderContext;
        this.string = string.toCharArray();
        this.offset = 0;
        this.length = this.string.length;
        this.lm = font.getLineMetrics(this.string, this.offset, this.length, fontRenderContext);
        this.getStringProperties();
        if (Bidi.requiresBidi(this.string, this.offset, this.offset + this.length)) {
            int n;
            int n2;
            this.bidi = new Bidi(string, this.leftToRight ? 0 : 1);
            int n3 = this.bidi.getRunCount();
            byte[] byArray = new byte[n3];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray[n2] = (byte)this.bidi.getRunLevel(n2);
            }
            this.runs = new Run[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = this.bidi.getRunStart(n2);
                if (n == (n4 = this.bidi.getRunLimit(n2))) continue;
                GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, this.string, n, n4, (byArray[n2] & 1) == 0 ? 0 : 1);
                this.runs[n2] = new Run(glyphVector, font, n, n4);
            }
            Bidi.reorderVisually(byArray, 0, this.runs, 0, this.runs.length);
            ArrayList<Run> arrayList = new ArrayList<Run>(n3);
            for (n = 0; n < n3; ++n) {
                if (this.runs[n] == null) continue;
                arrayList.add(this.runs[n]);
            }
            this.runs = new Run[arrayList.size()];
            this.runs = arrayList.toArray(this.runs);
        } else {
            GlyphVector glyphVector = font.layoutGlyphVector(fontRenderContext, this.string, this.offset, this.length, this.leftToRight ? 0 : 1);
            Run run = new Run(glyphVector, font, 0, this.length);
            this.runs = new Run[]{run};
        }
        this.setCharIndices();
        this.setupMappings();
        this.layoutRuns();
    }

    public TextLayout(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> map, FontRenderContext fontRenderContext) {
        this(string, new Font(map), fontRenderContext);
    }

    public TextLayout(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this(TextLayout.getText(attributedCharacterIterator), TextLayout.getFont(attributedCharacterIterator), fontRenderContext);
    }

    TextLayout(TextLayout textLayout, int n, int n2) {
        this.frc = textLayout.frc;
        this.boundsCache = null;
        this.lm = textLayout.lm;
        this.leftToRight = textLayout.leftToRight;
        if (n2 > textLayout.getCharacterCount()) {
            n2 = textLayout.getCharacterCount();
        }
        this.string = textLayout.string;
        this.offset = n + this.offset;
        this.length = n2 - n;
        int n3 = textLayout.charIndices[n][0];
        int n4 = 1 + textLayout.charIndices[n2 - 1][0] - n3;
        this.runs = new Run[n4];
        for (int i = 0; i < n4; ++i) {
            Run run = textLayout.runs[i + n3];
            GlyphVector glyphVector = run.glyphVector;
            Font font = run.font;
            int n5 = i > 0 ? 0 : textLayout.charIndices[n][1];
            int n6 = i < n4 - 1 ? glyphVector.getNumGlyphs() : 1 + textLayout.charIndices[n2 - 1][1] - n5;
            int[] nArray = glyphVector.getGlyphCodes(n5, n6, null);
            glyphVector = font.createGlyphVector(this.frc, nArray);
            this.runs[i] = new Run(glyphVector, font, run.runStart - n, run.runEnd - n);
        }
        this.runs[n4 - 1].runEnd = n2 - 1;
        this.setCharIndices();
        this.setupMappings();
        this.determineWhiteSpace();
        this.layoutRuns();
    }

    private void setCharIndices() {
        this.charIndices = new int[this.getCharacterCount()][2];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.runs.length; ++i) {
            n2 = -1;
            Run run = this.runs[i];
            GlyphVector glyphVector = run.glyphVector;
            for (int j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                if (glyphVector.getGlyphCharIndex(j) == n2) continue;
                this.charIndices[n][0] = i;
                this.charIndices[n][1] = j;
                n2 = glyphVector.getGlyphCharIndex(j);
                ++n;
            }
        }
    }

    private void setupMappings() {
        int n = this.getCharacterCount();
        this.logicalToVisual = new int[n];
        this.visualToLogical = new int[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.runs.length; ++i) {
            Run run = this.runs[i];
            if (run.isLeftToRight()) {
                n2 = run.runStart;
                while (n2 < run.runEnd) {
                    this.logicalToVisual[n2] = n3;
                    this.visualToLogical[n3] = n2++;
                    ++n3;
                }
                continue;
            }
            n2 = run.runEnd - 1;
            while (n2 >= run.runStart) {
                this.logicalToVisual[n2] = n3;
                this.visualToLogical[n3] = n2--;
                ++n3;
            }
        }
    }

    private static String getText(AttributedCharacterIterator attributedCharacterIterator) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n = attributedCharacterIterator.getIndex();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            cPStringBuilder.append(c);
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.setIndex(n);
        return cPStringBuilder.toString();
    }

    private static Font getFont(AttributedCharacterIterator attributedCharacterIterator) {
        Font font = (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
        if (font == null) {
            Float f = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
            int n = f != null ? (int)f.floatValue() : 14;
            font = new Font("Dialog", 0, n);
        }
        return font;
    }

    private void getStringProperties() {
        boolean bl = false;
        int n = this.offset;
        int n2 = this.offset + this.length;
        this.leftToRight = true;
        while (n < n2 && !bl) {
            switch (Character.getDirectionality(this.string[n++])) {
                case 0: 
                case 14: 
                case 15: {
                    bl = true;
                    break;
                }
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    this.leftToRight = false;
                    bl = true;
                }
            }
        }
        this.determineWhiteSpace();
    }

    private void determineWhiteSpace() {
        int n;
        this.hasWhitespace = false;
        for (n = this.offset + this.length - 1; n >= this.offset && Character.isWhitespace(this.string[n]); --n) {
        }
        while (n >= this.offset) {
            if (!Character.isWhitespace(this.string[n--])) continue;
            this.hasWhitespace = true;
        }
    }

    protected Object clone() {
        return new TextLayout(this, 0, this.length);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        for (int i = 0; i < this.runs.length; ++i) {
            Run run = this.runs[i];
            GlyphVector glyphVector = run.glyphVector;
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            f = (float)((double)f + rectangle2D.getWidth());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextLayout)) {
            return false;
        }
        return this.equals((TextLayout)object);
    }

    public boolean equals(TextLayout textLayout) {
        if (this.runs.length != textLayout.runs.length) {
            return false;
        }
        for (int i = 0; i < this.runs.length; ++i) {
            if (this.runs[i].equals(textLayout.runs[i])) continue;
            return false;
        }
        return true;
    }

    public float getAdvance() {
        if (this.totalAdvance == -1.0f) {
            this.totalAdvance = 0.0f;
            for (int i = 0; i < this.runs.length; ++i) {
                Run run = this.runs[i];
                GlyphVector glyphVector = run.glyphVector;
                this.totalAdvance = (float)((double)this.totalAdvance + glyphVector.getLogicalBounds().getWidth());
            }
        }
        return this.totalAdvance;
    }

    public float getAscent() {
        return this.lm.getAscent();
    }

    public byte getBaseline() {
        return (byte)this.lm.getBaselineIndex();
    }

    public float[] getBaselineOffsets() {
        return this.lm.getBaselineOffsets();
    }

    public Shape getBlackBoxBounds(int n, int n2) {
        GlyphVector glyphVector;
        Run run;
        int n3;
        if (n2 - n <= 0) {
            return new Rectangle2D.Float();
        }
        if (n < 0 || n2 > this.getCharacterCount()) {
            return new Rectangle2D.Float();
        }
        GeneralPath generalPath = new GeneralPath();
        int n4 = this.charIndices[n][0];
        int n5 = this.charIndices[n][1];
        double d = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            run = this.runs[n3];
            glyphVector = run.glyphVector;
            d += glyphVector.getLogicalBounds().getWidth();
        }
        for (n3 = n4; n3 <= this.charIndices[n2 - 1][0]; ++n3) {
            run = this.runs[n3];
            glyphVector = run.glyphVector;
            int n6 = n3 == this.charIndices[n2 - 1][0] ? this.charIndices[n2 - 1][1] : glyphVector.getNumGlyphs() - 1;
            for (int i = 0; i <= n6; ++i) {
                Rectangle2D rectangle2D = glyphVector.getGlyphVisualBounds(i).getBounds2D();
                Point2D point2D = glyphVector.getGlyphPosition(i);
                rectangle2D.setRect(d + rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                generalPath.append(rectangle2D, false);
            }
            d += glyphVector.getLogicalBounds().getWidth();
        }
        return generalPath;
    }

    public Rectangle2D getBounds() {
        if (this.boundsCache == null) {
            this.boundsCache = this.getOutline(new AffineTransform()).getBounds();
        }
        return this.boundsCache;
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo) {
        return this.getCaretInfo(textHitInfo, this.getNaturalBounds());
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        float[] fArray = new float[2];
        int n = textHitInfo.getCharIndex();
        boolean bl = textHitInfo.isLeadingEdge();
        if (n >= this.length) {
            fArray[0] = this.getAdvance();
            fArray[1] = 0.0f;
        } else {
            Run run;
            if (n < 0) {
                run = this.runs[0];
                n = 0;
                bl = true;
            } else {
                run = this.findRunAtIndex(n);
            }
            int n2 = n - run.runStart;
            Shape shape = run.glyphVector.getGlyphLogicalBounds(n2);
            Rectangle2D rectangle2D2 = shape.getBounds2D();
            fArray[0] = this.isVertical() ? (bl ? (float)rectangle2D2.getMinY() : (float)rectangle2D2.getMaxY()) : (bl ? (float)rectangle2D2.getMinX() : (float)rectangle2D2.getMaxX());
            fArray[0] = fArray[0] + run.location;
            fArray[1] = run.font.getItalicAngle();
        }
        return fArray;
    }

    public Shape getCaretShape(TextHitInfo textHitInfo) {
        return this.getCaretShape(textHitInfo, this.getBounds());
    }

    public Shape getCaretShape(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        float[] fArray = this.getCaretInfo(textHitInfo);
        float f = fArray[0];
        float f2 = (float)rectangle2D.getMinY();
        float f3 = fArray[0];
        float f4 = (float)rectangle2D.getMaxY();
        if (fArray[1] != 0.0f) {
            f -= f2 * fArray[1];
            f3 -= f4 * fArray[1];
        }
        GeneralPath generalPath = new GeneralPath(0, 2);
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        return generalPath;
    }

    public Shape[] getCaretShapes(int n) {
        return this.getCaretShapes(n, this.getNaturalBounds());
    }

    public Shape[] getCaretShapes(int n, Rectangle2D rectangle2D) {
        return this.getCaretShapes(n, rectangle2D, DEFAULT_CARET_POLICY);
    }

    public Shape[] getCaretShapes(int n, Rectangle2D rectangle2D, CaretPolicy caretPolicy) {
        TextHitInfo textHitInfo;
        int n2;
        Shape[] shapeArray = new Shape[2];
        TextHitInfo textHitInfo2 = TextHitInfo.afterOffset(n);
        int n3 = this.hitToCaret(textHitInfo2);
        if (n3 == (n2 = this.hitToCaret(textHitInfo = textHitInfo2.getOtherHit()))) {
            shapeArray[0] = this.getCaretShape(textHitInfo2);
            shapeArray[1] = null;
        } else {
            Shape shape = this.getCaretShape(textHitInfo2);
            Shape shape2 = this.getCaretShape(textHitInfo);
            TextHitInfo textHitInfo3 = caretPolicy.getStrongCaret(textHitInfo2, textHitInfo, this);
            if (textHitInfo3 == textHitInfo2) {
                shapeArray[0] = shape;
                shapeArray[1] = shape2;
            } else {
                shapeArray[0] = shape2;
                shapeArray[1] = shape;
            }
        }
        return shapeArray;
    }

    public int getCharacterCount() {
        return this.length;
    }

    public byte getCharacterLevel(int n) {
        byte by = this.bidi == null ? (byte)0 : (byte)this.bidi.getLevelAt(n);
        return by;
    }

    public float getDescent() {
        return this.lm.getDescent();
    }

    public TextLayout getJustifiedLayout(float f) {
        TextLayout textLayout = (TextLayout)this.clone();
        if (this.hasWhitespace) {
            textLayout.handleJustify(f);
        }
        return textLayout;
    }

    public float getLeading() {
        return this.lm.getLeading();
    }

    public Shape getLogicalHighlightShape(int n, int n2) {
        return this.getLogicalHighlightShape(n, n2, this.getBounds());
    }

    public Shape getLogicalHighlightShape(int n, int n2, Rectangle2D rectangle2D) {
        int n3;
        if (n2 - n <= 0) {
            return new Rectangle2D.Float();
        }
        if (n < 0 || n2 > this.getCharacterCount()) {
            return new Rectangle2D.Float();
        }
        Rectangle2D rectangle2D2 = null;
        int n4 = this.charIndices[n][0];
        int n5 = this.charIndices[n][1];
        double d = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d += this.runs[n3].glyphVector.getLogicalBounds().getWidth();
        }
        for (n3 = n4; n3 <= this.charIndices[n2 - 1][0]; ++n3) {
            Run run = this.runs[n3];
            GlyphVector glyphVector = run.glyphVector;
            int n6 = n3 == this.charIndices[n2 - 1][0] ? this.charIndices[n2 - 1][1] : glyphVector.getNumGlyphs() - 1;
            while (n5 <= n6) {
                Rectangle2D rectangle2D3 = glyphVector.getGlyphLogicalBounds(n5).getBounds2D();
                rectangle2D2 = rectangle2D2 == null ? rectangle2D3 : rectangle2D2.createUnion(rectangle2D3);
                ++n5;
            }
            n5 = 0;
            d += glyphVector.getLogicalBounds().getWidth();
        }
        return rectangle2D2;
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        int n;
        this.checkHitInfo(textHitInfo);
        this.checkHitInfo(textHitInfo2);
        int n2 = this.hitToCaret(textHitInfo);
        int n3 = this.hitToCaret(textHitInfo2);
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        boolean[] blArray = new boolean[this.length];
        for (n = n2; n < n3; ++n) {
            blArray[this.visualToLogical[n]] = true;
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < this.length; ++i) {
            if (blArray[i] == bl) continue;
            boolean bl2 = bl = !bl;
            if (!bl) continue;
            ++n;
        }
        int[] nArray = new int[n * 2];
        int n5 = 0;
        bl = false;
        for (int i = 0; i < this.length; ++i) {
            if (blArray[i] == bl) continue;
            nArray[n5] = i;
            ++n5;
            bl = !bl;
        }
        if (bl) {
            nArray[n5] = this.length;
        }
        return nArray;
    }

    public TextHitInfo getNextLeftHit(int n) {
        return this.getNextLeftHit(n, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextLeftHit(int n, CaretPolicy caretPolicy) {
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null policy not allowed");
        }
        if (n < 0 || n > this.length) {
            throw new IllegalArgumentException("Offset out of bounds");
        }
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(n);
        TextHitInfo textHitInfo2 = textHitInfo.getOtherHit();
        TextHitInfo textHitInfo3 = caretPolicy.getStrongCaret(textHitInfo, textHitInfo2, this);
        TextHitInfo textHitInfo4 = this.getNextLeftHit(textHitInfo3);
        TextHitInfo textHitInfo5 = null;
        if (textHitInfo4 != null) {
            TextHitInfo textHitInfo6 = this.getVisualOtherHit(textHitInfo4);
            textHitInfo5 = caretPolicy.getStrongCaret(textHitInfo6, textHitInfo4, this);
        }
        return textHitInfo5;
    }

    public TextHitInfo getNextLeftHit(TextHitInfo textHitInfo) {
        this.checkHitInfo(textHitInfo);
        int n = this.hitToCaret(textHitInfo);
        TextHitInfo textHitInfo2 = null;
        if (n != 0) {
            textHitInfo2 = this.caretToHit(--n);
        }
        return textHitInfo2;
    }

    public TextHitInfo getNextRightHit(int n) {
        return this.getNextRightHit(n, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextRightHit(int n, CaretPolicy caretPolicy) {
        if (caretPolicy == null) {
            throw new IllegalArgumentException("Null policy not allowed");
        }
        if (n < 0 || n > this.length) {
            throw new IllegalArgumentException("Offset out of bounds");
        }
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(n);
        TextHitInfo textHitInfo2 = textHitInfo.getOtherHit();
        TextHitInfo textHitInfo3 = this.getNextRightHit(caretPolicy.getStrongCaret(textHitInfo, textHitInfo2, this));
        TextHitInfo textHitInfo4 = null;
        if (textHitInfo3 != null) {
            TextHitInfo textHitInfo5 = this.getVisualOtherHit(textHitInfo3);
            textHitInfo4 = caretPolicy.getStrongCaret(textHitInfo5, textHitInfo3, this);
        }
        return textHitInfo4;
    }

    public TextHitInfo getNextRightHit(TextHitInfo textHitInfo) {
        this.checkHitInfo(textHitInfo);
        int n = this.hitToCaret(textHitInfo);
        TextHitInfo textHitInfo2 = null;
        if (n < this.length) {
            textHitInfo2 = this.caretToHit(++n);
        }
        return textHitInfo2;
    }

    public Shape getOutline(AffineTransform affineTransform) {
        float f = 0.0f;
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.runs.length; ++i) {
            GlyphVector glyphVector = this.runs[i].glyphVector;
            generalPath.append(glyphVector.getOutline(f, 0.0f), false);
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            f = (float)((double)f + rectangle2D.getWidth());
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public float getVisibleAdvance() {
        int n;
        int n2;
        float f = 0.0f;
        if (this.runs.length <= 0) {
            return 0.0f;
        }
        if (!Character.isWhitespace(this.string[this.offset + this.length - 1])) {
            return this.getAdvance();
        }
        for (n2 = 0; n2 < this.runs.length - 1; ++n2) {
            f = (float)((double)f + this.runs[n2].glyphVector.getLogicalBounds().getWidth());
        }
        n2 = this.runs[this.runs.length - 1].runStart;
        for (n = this.length - 1; n >= n2 && Character.isWhitespace(this.string[n]); --n) {
        }
        if (n < n2) {
            return f;
        }
        int n3 = n - n2;
        n = 0;
        while (this.runs[this.runs.length - 1].glyphVector.getGlyphCharIndex(n) <= n3) {
            f = (float)((double)f + this.runs[this.runs.length - 1].glyphVector.getGlyphLogicalBounds(n).getBounds2D().getWidth());
            ++n;
        }
        return f;
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return this.getVisualHighlightShape(textHitInfo, textHitInfo2, this.getBounds());
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, Rectangle2D rectangle2D) {
        GeneralPath generalPath = new GeneralPath(0);
        Shape shape = this.getCaretShape(textHitInfo, rectangle2D);
        generalPath.append(shape, false);
        Shape shape2 = this.getCaretShape(textHitInfo2, rectangle2D);
        generalPath.append(shape2, false);
        int n = this.hitToCaret(textHitInfo);
        int n2 = this.hitToCaret(textHitInfo2);
        if (n == 0 || n2 == 0) {
            generalPath.append(this.left(rectangle2D), false);
        }
        if (n == this.length || n2 == this.length) {
            generalPath.append(this.right(rectangle2D), false);
        }
        return generalPath.getBounds2D();
    }

    private Shape left(Rectangle2D rectangle2D) {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.append(this.getCaretShape(TextHitInfo.beforeOffset(0)), false);
        if (this.isVertical()) {
            float f = (float)rectangle2D.getMinY();
            generalPath.append(new Line2D.Float((float)rectangle2D.getMinX(), f, (float)rectangle2D.getMaxX(), f), false);
        } else {
            float f = (float)rectangle2D.getMinX();
            generalPath.append(new Line2D.Float(f, (float)rectangle2D.getMinY(), f, (float)rectangle2D.getMaxY()), false);
        }
        return generalPath.getBounds2D();
    }

    private Shape right(Rectangle2D rectangle2D) {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.append(this.getCaretShape(TextHitInfo.afterOffset(this.length)), false);
        if (this.isVertical()) {
            float f = (float)rectangle2D.getMaxY();
            generalPath.append(new Line2D.Float((float)rectangle2D.getMinX(), f, (float)rectangle2D.getMaxX(), f), false);
        } else {
            float f = (float)rectangle2D.getMaxX();
            generalPath.append(new Line2D.Float(f, (float)rectangle2D.getMinY(), f, (float)rectangle2D.getMaxY()), false);
        }
        return generalPath.getBounds2D();
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo textHitInfo) {
        boolean bl;
        int n;
        this.checkHitInfo(textHitInfo);
        int n2 = textHitInfo.getCharIndex();
        if (n2 == -1 || n2 == this.length) {
            int n3 = this.isLeftToRight() == (n2 == -1) ? 0 : this.length - 1;
            n = this.visualToLogical[n3];
            bl = this.isLeftToRight() == (n2 == -1) ? this.isCharacterLTR(n) : !this.isCharacterLTR(n);
        } else {
            boolean bl2;
            int n4 = this.logicalToVisual[n2];
            if (this.isCharacterLTR(n2) == textHitInfo.isLeadingEdge()) {
                --n4;
                bl2 = false;
            } else {
                ++n4;
                bl2 = true;
            }
            if (n4 >= 0 && n4 < this.length) {
                n = this.visualToLogical[n4];
                bl = bl2 == this.isLeftToRight();
            } else {
                n = bl2 == this.isLeftToRight() ? this.length : -1;
                bl = n == this.length;
            }
        }
        return bl ? TextHitInfo.leading(n) : TextHitInfo.trailing(n);
    }

    protected void handleJustify(float f) {
        int n;
        int n2;
        double d = f - this.getVisibleAdvance();
        int n3 = 0;
        int n4 = this.offset + this.length - 1;
        while (Character.isWhitespace(this.string[n4])) {
            --n4;
        }
        int[] nArray = new int[this.length * 10];
        for (int i = 0; i < this.runs.length; ++i) {
            Run run = this.runs[i];
            for (n2 = 0; n2 < run.glyphVector.getNumGlyphs(); ++n2) {
                n = run.runStart + run.glyphVector.getGlyphCharIndex(n2);
                if (!Character.isWhitespace(this.string[n])) continue;
                nArray[n3 * 2] = i;
                nArray[n3 * 2 + 1] = n2;
                ++n3;
            }
        }
        d /= (double)n3;
        double d2 = 0.0;
        n2 = 0;
        for (n = 0; n < this.runs.length; ++n) {
            Run run = this.runs[n];
            for (int i = 0; i < run.glyphVector.getNumGlyphs(); ++i) {
                if (nArray[n2 * 2] == n && nArray[n2 * 2 + 1] == i) {
                    ++n2;
                    d2 += d;
                }
                Point2D point2D = run.glyphVector.getGlyphPosition(i);
                point2D.setLocation(point2D.getX() + d2, point2D.getY());
                run.glyphVector.setGlyphPosition(i, point2D);
            }
        }
    }

    public TextHitInfo hitTestChar(float f, float f2) {
        return this.hitTestChar(f, f2, this.getNaturalBounds());
    }

    public TextHitInfo hitTestChar(float f, float f2, Rectangle2D rectangle2D) {
        TextHitInfo textHitInfo;
        block14: {
            block13: {
                if (this.isVertical()) {
                    if ((double)f2 < rectangle2D.getMinY()) {
                        return TextHitInfo.leading(0);
                    }
                    if ((double)f2 > rectangle2D.getMaxY()) {
                        return TextHitInfo.trailing(this.getCharacterCount() - 1);
                    }
                } else {
                    if ((double)f < rectangle2D.getMinX()) {
                        return TextHitInfo.leading(0);
                    }
                    if ((double)f > rectangle2D.getMaxX()) {
                        return TextHitInfo.trailing(this.getCharacterCount() - 1);
                    }
                }
                textHitInfo = null;
                if (!this.isVertical()) break block13;
                int n = this.runs.length;
                Run run = null;
                for (int i = 0; i < n && run == null; ++i) {
                    Run run2 = this.runs[i];
                    Rectangle2D rectangle2D2 = run2.glyphVector.getLogicalBounds();
                    if (!(rectangle2D2.getMinY() + (double)run2.location <= (double)f2) || !(rectangle2D2.getMaxY() + (double)run2.location >= (double)f2)) continue;
                    run = run2;
                }
                if (run == null) break block14;
                GlyphVector glyphVector = run.glyphVector;
                for (int i = run.runStart; i < run.runEnd && textHitInfo == null; ++i) {
                    int n2 = i - run.runStart;
                    Rectangle2D rectangle2D3 = glyphVector.getGlyphLogicalBounds(n2).getBounds2D();
                    if (!(rectangle2D3.getMinY() + (double)run.location <= (double)f2) || !(rectangle2D3.getMaxY() + (double)run.location >= (double)f2)) continue;
                    boolean bl = true;
                    if (rectangle2D3.getCenterY() + (double)run.location <= (double)f2) {
                        bl = false;
                    }
                    textHitInfo = bl ? TextHitInfo.leading(i) : TextHitInfo.trailing(i);
                }
                break block14;
            }
            int n = this.runs.length;
            Run run = null;
            for (int i = 0; i < n && run == null; ++i) {
                Run run3 = this.runs[i];
                Rectangle2D rectangle2D4 = run3.glyphVector.getLogicalBounds();
                if (!(rectangle2D4.getMinX() + (double)run3.location <= (double)f) || !(rectangle2D4.getMaxX() + (double)run3.location >= (double)f)) continue;
                run = run3;
            }
            if (run != null) {
                GlyphVector glyphVector = run.glyphVector;
                for (int i = run.runStart; i < run.runEnd && textHitInfo == null; ++i) {
                    int n3 = i - run.runStart;
                    Rectangle2D rectangle2D5 = glyphVector.getGlyphLogicalBounds(n3).getBounds2D();
                    if (!(rectangle2D5.getMinX() + (double)run.location <= (double)f) || !(rectangle2D5.getMaxX() + (double)run.location >= (double)f)) continue;
                    boolean bl = true;
                    if (rectangle2D5.getCenterX() + (double)run.location <= (double)f) {
                        bl = false;
                    }
                    textHitInfo = bl ? TextHitInfo.leading(i) : TextHitInfo.trailing(i);
                }
            }
        }
        return textHitInfo;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public boolean isVertical() {
        return false;
    }

    public int hashCode() {
        if (this.hash == 0 && this.runs.length > 0) {
            this.hash = this.runs.length;
            for (int i = 0; i < this.runs.length; ++i) {
                this.hash ^= this.runs[i].glyphVector.hashCode();
            }
        }
        return this.hash;
    }

    public String toString() {
        return "TextLayout [string:" + new String(this.string, this.offset, this.length) + " Rendercontext:" + this.frc + "]";
    }

    private Rectangle2D getNaturalBounds() {
        if (this.naturalBounds == null) {
            this.naturalBounds = new Rectangle2D.Float(0.0f, -this.getAscent(), this.getAdvance(), this.getAscent() + this.getDescent());
        }
        return this.naturalBounds;
    }

    private void checkHitInfo(TextHitInfo textHitInfo) {
        if (textHitInfo == null) {
            throw new IllegalArgumentException("Null hit info not allowed");
        }
        int n = textHitInfo.getInsertionIndex();
        if (n < 0 || n > this.length) {
            throw new IllegalArgumentException("Hit index out of range");
        }
    }

    private int hitToCaret(TextHitInfo textHitInfo) {
        int n;
        int n2 = textHitInfo.getCharIndex();
        if (n2 < 0) {
            n = this.isLeftToRight() ? 0 : this.length;
        } else if (n2 >= this.length) {
            n = this.isLeftToRight() ? this.length : 0;
        } else {
            n = this.logicalToVisual[n2];
            if (textHitInfo.isLeadingEdge() != this.isCharacterLTR(n2)) {
                ++n;
            }
        }
        return n;
    }

    private TextHitInfo caretToHit(int n) {
        int n2;
        boolean bl;
        TextHitInfo textHitInfo = n == 0 || n == this.length ? (n == this.length == this.isLeftToRight() ? TextHitInfo.leading(this.length) : TextHitInfo.trailing(-1)) : ((bl = this.isCharacterLTR(n2 = this.visualToLogical[n])) ? TextHitInfo.leading(n2) : TextHitInfo.trailing(n2));
        return textHitInfo;
    }

    private boolean isCharacterLTR(int n) {
        byte by = this.getCharacterLevel(n);
        return (by & 1) == 0;
    }

    private Run findRunAtIndex(int n) {
        Run run = null;
        for (int i = 0; i < this.runs.length && run == null; ++i) {
            Run run2 = this.runs[i];
            if (run2.runStart > n || run2.runEnd <= n) continue;
            run = run2;
        }
        return run;
    }

    private void layoutRuns() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.runs.length; ++i) {
            this.runs[i].location = f;
            Rectangle2D rectangle2D = this.runs[i].glyphVector.getLogicalBounds();
            f = (float)((double)f + (this.isVertical() ? rectangle2D.getHeight() : rectangle2D.getWidth()));
        }
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, TextLayout textLayout) {
            byte by;
            byte by2 = textLayout.getCharacterLevel(textHitInfo.getCharIndex());
            TextHitInfo textHitInfo3 = by2 == (by = textLayout.getCharacterLevel(textHitInfo2.getCharIndex())) ? (textHitInfo2.isLeadingEdge() && !textHitInfo.isLeadingEdge() ? textHitInfo2 : textHitInfo) : (by2 < by ? textHitInfo : textHitInfo2);
            return textHitInfo3;
        }
    }

    private class Run {
        GlyphVector glyphVector;
        Font font;
        int runStart;
        int runEnd;
        float location;

        Run(GlyphVector glyphVector, Font font, int n, int n2) {
            this.glyphVector = glyphVector;
            this.font = font;
            this.runStart = n;
            this.runEnd = n2;
        }

        boolean isLeftToRight() {
            return (this.glyphVector.getLayoutFlags() & 4) == 0;
        }
    }
}

