/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.io.Serializable;

public final class NumericShaper
implements Serializable {
    private static final long serialVersionUID = -8022764705923730308L;
    public static final int ALL_RANGES = 524287;
    public static final int ARABIC = 2;
    public static final int BENGALI = 16;
    public static final int DEVANAGARI = 8;
    public static final int EASTERN_ARABIC = 4;
    public static final int ETHIOPIC = 65536;
    public static final int EUROPEAN = 1;
    public static final int GUJARATI = 64;
    public static final int GURMUKHI = 32;
    public static final int KANNADA = 1024;
    public static final int KHMER = 131072;
    public static final int LAO = 8192;
    public static final int MALAYALAM = 2048;
    public static final int MONGOLIAN = 262144;
    public static final int MYANMAR = 32768;
    public static final int ORIYA = 128;
    public static final int TAMIL = 256;
    public static final int TELUGU = 512;
    public static final int THAI = 4096;
    public static final int TIBETAN = 16384;
    private static final char[] zeroDigits = new char[]{'0', '\u0660', '\u06f0', '\u0966', '\u09e6', '\u0a66', '\u0ae6', '\u0b66', '\u0be6', '\u0c66', '\u0ce6', '\u0d66', '\u0e50', '\u0ed0', '\u0f20', '\u1040', '\u1368', '\u17e0', '\u1810'};
    private int key;
    private int mask;

    private NumericShaper(int n, int n2) {
        this.key = Integer.numberOfTrailingZeros(n);
        this.mask = n2;
    }

    public int getRanges() {
        return this.mask & 0x7FFFF;
    }

    public boolean isContextual() {
        return this.mask > 0;
    }

    public void shape(char[] cArray, int n, int n2) {
        this.shape(cArray, n, n2, 1 << this.key);
    }

    private int classify(Character.UnicodeBlock unicodeBlock) {
        if (unicodeBlock == null) {
            return 0;
        }
        if (unicodeBlock == Character.UnicodeBlock.ARABIC) {
            return 4;
        }
        if (unicodeBlock == Character.UnicodeBlock.BENGALI) {
            return 16;
        }
        if (unicodeBlock == Character.UnicodeBlock.DEVANAGARI) {
            return 8;
        }
        if (unicodeBlock == Character.UnicodeBlock.ETHIOPIC) {
            return 65536;
        }
        if (unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B) {
            return 1;
        }
        if (unicodeBlock == Character.UnicodeBlock.GUJARATI) {
            return 64;
        }
        if (unicodeBlock == Character.UnicodeBlock.GURMUKHI) {
            return 32;
        }
        if (unicodeBlock == Character.UnicodeBlock.KANNADA) {
            return 1024;
        }
        if (unicodeBlock == Character.UnicodeBlock.KHMER) {
            return 131072;
        }
        if (unicodeBlock == Character.UnicodeBlock.LAO) {
            return 8192;
        }
        if (unicodeBlock == Character.UnicodeBlock.MALAYALAM) {
            return 2048;
        }
        if (unicodeBlock == Character.UnicodeBlock.MONGOLIAN) {
            return 262144;
        }
        if (unicodeBlock == Character.UnicodeBlock.MYANMAR) {
            return 32768;
        }
        if (unicodeBlock == Character.UnicodeBlock.ORIYA) {
            return 128;
        }
        if (unicodeBlock == Character.UnicodeBlock.TAMIL) {
            return 256;
        }
        if (unicodeBlock == Character.UnicodeBlock.TELUGU) {
            return 512;
        }
        if (unicodeBlock == Character.UnicodeBlock.THAI) {
            return 4096;
        }
        if (unicodeBlock == Character.UnicodeBlock.TIBETAN) {
            return 16384;
        }
        return 0;
    }

    public void shape(char[] cArray, int n, int n2, int n3) {
        int n4;
        if (this.isContextual()) {
            if (Integer.bitCount(n3) != 1 || (n3 & 0xFFF80000) != 0) {
                throw new IllegalArgumentException("invalid context argument");
            }
            n4 = (n3 & this.mask) == 0 ? -1 : Integer.numberOfTrailingZeros(n3);
        } else {
            n4 = this.key;
        }
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            if (c >= '0' && c <= '9') {
                if (n4 < 0 || c == '0' && (1 << n4 == 256 || 1 << n4 == 65536)) continue;
                cArray[n + i] = (char)(zeroDigits[n4] + c - 48);
                continue;
            }
            if (!this.isContextual()) continue;
            int n5 = this.classify(Character.UnicodeBlock.of(c));
            if (n5 == 4 && (this.mask & 4) == 0 && (this.mask & 2) != 0) {
                n5 = 2;
            }
            if ((this.mask & n5) == 0) continue;
            n4 = Integer.numberOfTrailingZeros(n5);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof NumericShaper)) {
            return false;
        }
        NumericShaper numericShaper = (NumericShaper)object;
        return this.key == numericShaper.key && this.mask == numericShaper.mask;
    }

    public int hashCode() {
        return this.key ^ this.mask;
    }

    public String toString() {
        return "key=" + this.key + "; mask=" + this.mask;
    }

    public static NumericShaper getShaper(int n) {
        if (Integer.bitCount(n) != 1) {
            throw new IllegalArgumentException("more than one bit set in argument");
        }
        if ((n & 0xFFF80000) != 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        return new NumericShaper(n, Integer.MIN_VALUE | n);
    }

    public static NumericShaper getContextualShaper(int n) {
        if ((n & 0xFFF80000) != 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        return new NumericShaper(1, n);
    }

    public static NumericShaper getContextualShaper(int n, int n2) {
        if (Integer.bitCount(n2) != 1) {
            throw new IllegalArgumentException("more than one bit set in context");
        }
        if ((n & 0xFFF80000) != 0 || (n2 & 0xFFF80000) != 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        return new NumericShaper(n2, n);
    }
}

