/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.geom.Rectangle2D;

public final class GlyphMetrics {
    public static final byte COMBINING = 2;
    public static final byte COMPONENT = 3;
    public static final byte LIGATURE = 1;
    public static final byte STANDARD = 0;
    public static final byte WHITESPACE = 4;
    private boolean horizontal;
    private float advanceX;
    private float advanceY;
    private Rectangle2D bounds;
    private byte glyphType;

    public GlyphMetrics(boolean bl, float f, float f2, Rectangle2D rectangle2D, byte by) {
        this.horizontal = bl;
        this.advanceX = f;
        this.advanceY = f2;
        this.bounds = rectangle2D;
        this.glyphType = by;
    }

    public GlyphMetrics(float f, Rectangle2D rectangle2D, byte by) {
        this(true, f, f, rectangle2D, by);
    }

    public float getAdvance() {
        return this.horizontal ? this.advanceX : this.advanceY;
    }

    public float getAdvanceX() {
        return this.advanceX;
    }

    public float getAdvanceY() {
        return this.advanceY;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public float getLSB() {
        if (this.horizontal) {
            return (float)this.bounds.getX();
        }
        return (float)this.bounds.getY();
    }

    public float getRSB() {
        if (this.horizontal) {
            return (float)((double)this.advanceX - (this.bounds.getX() + this.bounds.getWidth()));
        }
        return (float)((double)this.advanceY - (this.bounds.getY() + this.bounds.getHeight()));
    }

    public int getType() {
        return this.glyphType;
    }

    public boolean isCombining() {
        return this.glyphType == 2;
    }

    public boolean isComponent() {
        return this.glyphType == 3;
    }

    public boolean isLigature() {
        return this.glyphType == 1;
    }

    public boolean isStandard() {
        return this.glyphType == 0;
    }

    public boolean isWhitespace() {
        return this.glyphType == 4;
    }
}

