/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Image;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.rmi.Remote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    public static final DataFlavor plainTextFlavor = new DataFlavor("text/plain; charset=unicode; class=java.io.InputStream", "plain unicode text");
    public static final DataFlavor stringFlavor = new DataFlavor(String.class, "Java Unicode String");
    public static final DataFlavor javaFileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List", "Java File List");
    public static final DataFlavor imageFlavor = new DataFlavor(Image.class, "Java Image");
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private MimeType mimeType;
    private Class<?> representationClass;
    private String humanPresentableName;

    protected static final Class<?> tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
                return Class.forName(string, true, classLoader2);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
                    return Class.forName(string, true, classLoader3);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    if (classLoader != null) {
                        return Class.forName(string, true, classLoader);
                    }
                    throw new ClassNotFoundException(string);
                }
            }
        }
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            Class<?> clazz = dataFlavor.representationClass;
            if (Reader.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
                return dataFlavor;
            }
            if (!InputStream.class.isAssignableFrom(clazz) || !"text".equals(dataFlavor.getPrimaryType())) continue;
            String string = dataFlavorArray[i].getParameter("charset");
            if (string == null) {
                string = "us-ascii";
            }
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (inputStreamReader == null) continue;
            return dataFlavor;
        }
        return null;
    }

    public DataFlavor() {
    }

    public DataFlavor(Class<?> clazz, String string) {
        block4: {
            if (clazz == null) {
                throw new NullPointerException("representationClass must not be null");
            }
            try {
                this.mimeType = new MimeType(javaSerializedObjectMimeType);
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        if (string == null) {
            string = javaSerializedObjectMimeType;
        }
        this.humanPresentableName = string;
        this.representationClass = clazz;
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        this.init(string, string2, classLoader);
    }

    public DataFlavor(String string, String string2) {
        try {
            this.init(string, string2, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Class not found: " + classNotFoundException.getMessage());
            illegalArgumentException.initCause(classNotFoundException);
            throw illegalArgumentException;
        }
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        this.init(string, null, this.getClass().getClassLoader());
    }

    private void init(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("The mime type must not be null");
        }
        try {
            this.mimeType = new MimeType(string);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid mime type");
            illegalArgumentException.initCause(mimeTypeParseException);
            throw illegalArgumentException;
        }
        String string3 = this.mimeType.getParameter("class");
        if (string3 == null) {
            if (this.mimeType.getBaseType().equals(javaSerializedObjectMimeType)) {
                throw new IllegalArgumentException("Serialized object type must have a representation class parameter");
            }
            this.representationClass = InputStream.class;
        } else {
            this.representationClass = DataFlavor.tryToLoadClass(string3, classLoader);
        }
        this.mimeType.addParameter("class", this.representationClass.getName());
        if (string2 == null && (string2 = this.mimeType.getParameter("humanPresentableName")) == null) {
            string2 = this.mimeType.getBaseType();
        }
        this.humanPresentableName = string2;
    }

    public String getMimeType() {
        return this.mimeType.toString();
    }

    public Class<?> getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        return this.mimeType.getPrimaryType();
    }

    public String getSubType() {
        return this.mimeType.getSubType();
    }

    public String getParameter(String string) {
        if ("humanPresentableName".equals(string)) {
            return this.getHumanPresentableName();
        }
        return this.mimeType.getParameter(string);
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean isMimeTypeEqual(String string) {
        if (string == null) {
            throw new NullPointerException("mimeType must not be null");
        }
        boolean bl = false;
        try {
            if (this.mimeType != null) {
                MimeType mimeType = new MimeType(string);
                bl = this.mimeType.matches(mimeType);
            }
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            // empty catch block
        }
        return bl;
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.getMimeType());
    }

    public boolean isMimeTypeSerializedObject() {
        return this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return InputStream.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassSerializable() {
        return Serializable.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassRemote() {
        return Remote.class.isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isRepresentationClassRemote() && this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        return this.getPrimaryType().equals(javaFileListFlavor.getPrimaryType()) && this.getSubType().equals(javaFileListFlavor.getSubType()) && DataFlavor.javaFileListFlavor.representationClass.isAssignableFrom(this.representationClass);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        String string = this.getPrimaryType();
        if (!string.equals(dataFlavor.getPrimaryType())) {
            return false;
        }
        String string2 = this.getSubType();
        if (!string2.equals(dataFlavor.getSubType())) {
            return false;
        }
        if (!this.representationClass.equals(dataFlavor.representationClass)) {
            return false;
        }
        if (!(!string.equals("text") || this.isRepresentationClassCharBuffer() || this.isRepresentationClassReader() || this.representationClass == String.class || this.representationClass.isArray() && this.representationClass.getComponentType() == Character.TYPE)) {
            String string3 = this.getParameter("charset");
            String string4 = dataFlavor.getParameter("charset");
            String string5 = Charset.defaultCharset().name();
            if (string3 == null || string3.equals(string5)) {
                return string4 == null || string4.equals(string5);
            }
            return string3.equals(string4);
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)object);
    }

    public boolean equals(String string) {
        return this.isMimeTypeEqual(string);
    }

    public int hashCode() {
        return this.mimeType.toString().hashCode() ^ this.representationClass.hashCode();
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string + "=" + string2;
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.mimeType != null) {
            this.mimeType.addParameter("humanPresentableName", this.humanPresentableName);
            objectOutput.writeObject(this.mimeType);
            this.mimeType.removeParameter("humanPresentableName");
        } else {
            objectOutput.writeObject(null);
        }
        objectOutput.writeObject(this.representationClass);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.mimeType = (MimeType)objectInput.readObject();
        String string = null;
        if (this.mimeType != null) {
            this.humanPresentableName = this.mimeType.getParameter("humanPresentableName");
            this.mimeType.removeParameter("humanPresentableName");
            string = this.mimeType.getParameter("class");
            if (string == null) {
                throw new IOException("No class in mime type");
            }
        }
        try {
            this.representationClass = (Class)objectInput.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            if (optionalDataException.eof && optionalDataException.length == 0) {
                if (string != null) {
                    this.representationClass = DataFlavor.tryToLoadClass(string, this.getClass().getClassLoader());
                }
            }
            throw optionalDataException;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[representationClass=" + this.getRepresentationClass().getName() + ",mimeType=" + this.getMimeType() + ",humanPresentableName=" + this.getHumanPresentableName() + "]";
    }

    public final Class<?> getDefaultRepresentationClass() {
        return InputStream.class;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        if (Reader.class.isAssignableFrom(this.representationClass)) {
            return (Reader)transferable.getTransferData(this);
        }
        if (String.class.isAssignableFrom(this.representationClass)) {
            return new StringReader((String)transferable.getTransferData(this));
        }
        if (InputStream.class.isAssignableFrom(this.representationClass) && "text".equals(this.getPrimaryType())) {
            InputStream inputStream = (InputStream)transferable.getTransferData(this);
            String string = this.getParameter("charset");
            if (string == null) {
                string = "us-ascii";
            }
            return new InputStreamReader(inputStream, string);
        }
        throw new UnsupportedFlavorException(this);
    }

    public boolean isRepresentationClassByteBuffer() {
        return ByteBuffer.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        return CharBuffer.class.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        return Reader.class.isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorTextType() {
        if (this.equals(stringFlavor) || this.getPrimaryType().equals("text")) {
            String string = this.getParameter("charset");
            Class<?> clazz = this.getRepresentationClass();
            if (string != null) {
                if (Reader.class.isAssignableFrom(clazz) || CharBuffer.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
                    return true;
                }
                if (InputStream.class.isAssignableFrom(clazz) || ByteBuffer.class.isAssignableFrom(clazz)) {
                    return Charset.isSupported(string);
                }
            } else if (InputStream.class.isAssignableFrom(clazz) || ByteBuffer.class.isAssignableFrom(clazz)) {
                return true;
            }
        }
        return false;
    }
}

