/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.classpath.SystemProperties;
import gnu.java.awt.AWTUtilities;
import gnu.java.awt.peer.GLightweightPeer;
import gnu.java.awt.peer.headless.HeadlessToolkit;
import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.AWTEventListener;
import java.awt.event.AWTEventListenerProxy;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Toolkit {
    private static String default_toolkit_name = "gnu.java.awt.peer.gtk.GtkToolkit";
    private static Toolkit toolkit;
    private static Properties props;
    protected final Map<String, Object> desktopProperties = new Hashtable<String, Object>();
    protected final PropertyChangeSupport desktopPropsSupport = new PropertyChangeSupport(this);
    AWTEventListenerProxy[] awtEventListeners = new AWTEventListenerProxy[0];
    private GLightweightPeer lightweightPeer;

    protected abstract DesktopPeer createDesktopPeer(Desktop var1) throws HeadlessException;

    protected abstract ButtonPeer createButton(Button var1);

    protected abstract TextFieldPeer createTextField(TextField var1);

    protected abstract LabelPeer createLabel(Label var1);

    protected abstract ListPeer createList(List var1);

    protected abstract CheckboxPeer createCheckbox(Checkbox var1);

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1);

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1);

    protected abstract TextAreaPeer createTextArea(TextArea var1);

    protected abstract ChoicePeer createChoice(Choice var1);

    protected abstract FramePeer createFrame(Frame var1);

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1);

    protected abstract DialogPeer createDialog(Dialog var1);

    protected abstract MenuBarPeer createMenuBar(MenuBar var1);

    protected abstract MenuPeer createMenu(Menu var1);

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1);

    protected abstract MenuItemPeer createMenuItem(MenuItem var1);

    protected MouseInfoPeer getMouseInfoPeer() {
        throw new UnsupportedOperationException("No mouse info peer.");
    }

    protected abstract FileDialogPeer createFileDialog(FileDialog var1);

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1);

    protected LightweightPeer createComponent(Component component) {
        if (this.lightweightPeer == null) {
            this.lightweightPeer = new GLightweightPeer();
        }
        return this.lightweightPeer;
    }

    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] nArray) {
        nArray[0] = -16753572;
        nArray[1] = -16777088;
        nArray[2] = -1;
        nArray[3] = -4144960;
        nArray[4] = -8355712;
        nArray[5] = -4144960;
        nArray[6] = -4144960;
        nArray[7] = -1;
        nArray[8] = -16777216;
        nArray[9] = -16777216;
        nArray[10] = -4144960;
        nArray[11] = -16777216;
        nArray[12] = -4144960;
        nArray[13] = -16777216;
        nArray[14] = -16777072;
        nArray[15] = -1;
        nArray[16] = -8355712;
        nArray[17] = -4144960;
        nArray[18] = -16777216;
        nArray[19] = -1;
        nArray[20] = -2039584;
        nArray[21] = -8355712;
        nArray[22] = -16777216;
        nArray[23] = -2039584;
        nArray[24] = -2039808;
        nArray[25] = -16777216;
    }

    public void setDynamicLayout(boolean bl) {
    }

    protected boolean isDynamicLayoutSet() {
        return false;
    }

    public boolean isDynamicLayoutActive() {
        return false;
    }

    public abstract Dimension getScreenSize();

    public abstract int getScreenResolution();

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return new Insets(0, 0, 0, 0);
    }

    public abstract ColorModel getColorModel();

    public abstract String[] getFontList();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    public static synchronized Toolkit getDefaultToolkit() {
        if (toolkit != null) {
            return toolkit;
        }
        String string = SystemProperties.getProperty("awt.toolkit", default_toolkit_name);
        try {
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            Class<?> clazz = Class.forName(string, true, classLoader);
            Object obj = clazz.newInstance();
            if (!(obj instanceof Toolkit)) {
                throw new AWTError(string + " is not a subclass of " + "java.awt.Toolkit");
            }
            toolkit = (Toolkit)obj;
            Toolkit.initAccessibility();
            return toolkit;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (GraphicsEnvironment.isHeadless()) {
                toolkit = new HeadlessToolkit();
                return toolkit;
            }
            AWTError aWTError = new AWTError("Cannot load AWT toolkit: " + string);
            throw (AWTError)aWTError.initCause(throwable);
        }
    }

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract Image createImage(String var1);

    public abstract Image createImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] byArray) {
        return this.createImage(byArray, 0, byArray.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract PrintJob getPrintJob(Frame var1, String var2, Properties var3);

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return null;
    }

    public abstract void beep();

    public abstract Clipboard getSystemClipboard();

    public Clipboard getSystemSelection() {
        return null;
    }

    public int getMenuShortcutKeyMask() {
        return 2;
    }

    public boolean getLockingKeyState(int n) {
        if (AWTUtilities.isValidKey(n)) {
            throw new UnsupportedOperationException("cannot get locking state of key code " + n);
        }
        throw new IllegalArgumentException("invalid key code " + n);
    }

    public void setLockingKeyState(int n, boolean bl) {
        if (n != 20 && n != 144 && n != 145) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    protected static Container getNativeContainer(Component component) {
        component = component.getParent();
        while (true) {
            if (component == null) {
                return null;
            }
            if (!(component instanceof Container)) {
                component = component.getParent();
                continue;
            }
            if (!(component.getPeer() instanceof LightweightPeer)) break;
            component = component.getParent();
        }
        return (Container)component;
    }

    public Cursor createCustomCursor(Image image, Point point, String string) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("No custom cursor in an headless graphics environment.");
        }
        return null;
    }

    public Dimension getBestCursorSize(int n, int n2) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("No best cursor size in an headless graphics environment.");
        }
        return new Dimension(0, 0);
    }

    public int getMaximumCursorColors() {
        return 0;
    }

    public boolean isFrameStateSupported(int n) {
        return false;
    }

    public static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public final EventQueue getSystemEventQueue() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAwtEventQueueAccess();
        }
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1);

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        return null;
    }

    public final Object getDesktopProperty(String string) {
        return this.desktopProperties.get(string);
    }

    protected final void setDesktopProperty(String string, Object object) {
        Object object2 = this.getDesktopProperty(string);
        this.desktopProperties.put(string, object);
        this.desktopPropsSupport.firePropertyChange(string, object2, object);
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        return null;
    }

    protected void initializeDesktopProperties() {
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.desktopPropsSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.desktopPropsSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.desktopPropsSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.desktopPropsSupport.getPropertyChangeListeners(string);
    }

    public void addAWTEventListener(AWTEventListener aWTEventListener, long l) {
        AWTEventListenerProxy[] aWTEventListenerProxyArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        boolean bl = false;
        for (int i = 0; i < this.awtEventListeners.length; ++i) {
            AWTEventListenerProxy aWTEventListenerProxy;
            aWTEventListenerProxyArray = this.awtEventListeners[i];
            if (aWTEventListenerProxyArray.getListener() != aWTEventListener) continue;
            bl = true;
            this.awtEventListeners[i] = aWTEventListenerProxy = new AWTEventListenerProxy(aWTEventListenerProxyArray.getEventMask() | l, aWTEventListener);
            break;
        }
        if (!bl) {
            AWTEventListenerProxy aWTEventListenerProxy = new AWTEventListenerProxy(l, aWTEventListener);
            aWTEventListenerProxyArray = new AWTEventListenerProxy[this.awtEventListeners.length + 1];
            System.arraycopy(this.awtEventListeners, 0, aWTEventListenerProxyArray, 0, this.awtEventListeners.length);
            aWTEventListenerProxyArray[aWTEventListenerProxyArray.length - 1] = aWTEventListenerProxy;
            this.awtEventListeners = aWTEventListenerProxyArray;
        }
    }

    public void removeAWTEventListener(AWTEventListener aWTEventListener) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        int n = -1;
        for (int i = 0; i < this.awtEventListeners.length; ++i) {
            AWTEventListenerProxy aWTEventListenerProxy = this.awtEventListeners[i];
            if (aWTEventListenerProxy.getListener() != aWTEventListener) continue;
            n = i;
            break;
        }
        if (n != -1) {
            AWTEventListenerProxy[] aWTEventListenerProxyArray = new AWTEventListenerProxy[this.awtEventListeners.length - 1];
            if (n > 0) {
                System.arraycopy(this.awtEventListeners, 0, aWTEventListenerProxyArray, 0, n);
            }
            if (n < this.awtEventListeners.length - 1) {
                System.arraycopy(this.awtEventListeners, n + 1, aWTEventListenerProxyArray, n, this.awtEventListeners.length - n - 1);
            }
            this.awtEventListeners = aWTEventListenerProxyArray;
        }
    }

    public AWTEventListener[] getAWTEventListeners() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        AWTEventListener[] aWTEventListenerArray = new AWTEventListener[this.awtEventListeners.length];
        System.arraycopy(this.awtEventListeners, 0, aWTEventListenerArray, 0, this.awtEventListeners.length);
        return aWTEventListenerArray;
    }

    public AWTEventListener[] getAWTEventListeners(long l) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("listenToAllAWTEvents"));
        }
        ArrayList<AWTEventListenerProxy> arrayList = new ArrayList<AWTEventListenerProxy>(this.awtEventListeners.length);
        for (int i = 0; i < this.awtEventListeners.length; ++i) {
            if ((this.awtEventListeners[i].getEventMask() & l) == 0L) continue;
            arrayList.add(this.awtEventListeners[i]);
        }
        return arrayList.toArray(new AWTEventListener[arrayList.size()]);
    }

    void globalDispatchEvent(AWTEvent aWTEvent) {
        for (int i = 0; i < this.awtEventListeners.length; ++i) {
            AWTEventListenerProxy aWTEventListenerProxy = this.awtEventListeners[i];
            if ((aWTEventListenerProxy.getEventMask() & AWTEvent.eventIdToMask(aWTEvent.getID())) == 0L) continue;
            aWTEventListenerProxy.eventDispatched(aWTEvent);
        }
    }

    public abstract Map<TextAttribute, ?> mapInputMethodHighlight(InputMethodHighlight var1);

    public abstract boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType var1);

    public abstract boolean isModalityTypeSupported(Dialog.ModalityType var1);

    private static void initAccessibility() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                Object object;
                Object object2;
                Properties properties = new Properties();
                String string2 = File.separator;
                try {
                    object2 = new File(System.getProperty("user.home") + string2 + ".accessibility.properties");
                    object = new FileInputStream((File)object2);
                    properties.load((InputStream)object);
                    ((FileInputStream)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (properties.size() == 0) {
                    try {
                        object2 = new File(System.getProperty("gnu.classpath.home.url") + string2 + "accessibility.properties");
                        object = new FileInputStream((File)object2);
                        properties.load((InputStream)object);
                        ((FileInputStream)object).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((object2 = SystemProperties.getProperty("javax.accessibility.screen_magnifier_present")) == null && (object2 = properties.getProperty("screen_magnifier_present")) != null) {
                    SystemProperties.setProperty("javax.accessibility.screen_magnifier_present", (String)object2);
                }
                if ((object = SystemProperties.getProperty("javax.accessibility.screen_reader_present")) == null && (object = properties.getProperty("screen_reader_present")) != null) {
                    SystemProperties.setProperty("javax.accessibility.screen_reader_present", (String)object);
                }
                if ((string = SystemProperties.getProperty("javax.accessibility.assistive_technologies")) == null && (string = properties.getProperty("assistive_technologies")) != null) {
                    SystemProperties.setProperty("javax.accessibility.assistive_technologies", string);
                }
                if (string != null) {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        try {
                            Class<?> clazz = classLoader.loadClass(string3);
                            clazz.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            AWTError aWTError = new AWTError("Assistive Technology class not found: " + string3);
                            aWTError.initCause(classNotFoundException);
                            throw aWTError;
                        }
                        catch (InstantiationException instantiationException) {
                            AWTError aWTError = new AWTError("Assistive Technology class cannot be instantiated: " + string3);
                            aWTError.initCause(instantiationException);
                            throw aWTError;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            AWTError aWTError = new AWTError("Assistive Technology class cannot be accessed: " + string3);
                            aWTError.initCause(aWTError);
                            throw aWTError;
                        }
                    }
                }
                return null;
            }
        });
    }

    static {
        props = new Properties();
    }
}

