/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scrollbar
extends Component
implements Accessible,
Adjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final long serialVersionUID = 8451667562882310543L;
    private int lineIncrement;
    private int pageIncrement;
    private int maximum;
    private int minimum;
    private int orientation;
    private int value;
    private int visibleAmount;
    private AdjustmentListener adjustment_listeners;
    private transient boolean valueIsAdjusting = false;
    private static transient long next_scrollbar_number;

    public Scrollbar() {
        this(1);
    }

    public Scrollbar(int n) throws IllegalArgumentException {
        this(n, 0, 10, 0, 100);
    }

    public Scrollbar(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + n);
        }
        this.orientation = n;
        this.setValues(n2, n3, n4, n5);
        this.lineIncrement = 1;
        this.pageIncrement = 10;
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + n);
        }
        this.orientation = n;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int n) {
        this.setValues(n, this.visibleAmount, this.minimum, this.maximum);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int n) {
        this.setValues(this.value, this.visibleAmount, this.minimum, n);
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(int n) {
        this.setValues(this.value, this.visibleAmount, n, this.maximum);
    }

    @Override
    public int getVisibleAmount() {
        return this.getVisible();
    }

    public int getVisible() {
        return this.visibleAmount;
    }

    @Override
    public void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.minimum, this.maximum);
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        ScrollbarPeer scrollbarPeer;
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n4 <= n3) {
            n4 = n3 + 1;
        }
        if (n < n3) {
            n = n3;
        }
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        if (n > n4 - n2) {
            n = n4 - n2;
        }
        if ((scrollbarPeer = (ScrollbarPeer)this.getPeer()) != null && (this.value != n || this.visibleAmount != n2 || this.minimum != n3 || this.maximum != n4)) {
            scrollbarPeer.setValues(n, n2, n3, n4);
        }
        this.value = n;
        this.visibleAmount = n2;
        this.minimum = n3;
        this.maximum = n4;
    }

    @Override
    public int getUnitIncrement() {
        return this.getLineIncrement();
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    @Override
    public synchronized void setUnitIncrement(int n) {
        this.setLineIncrement(n);
    }

    public void setLineIncrement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Unit increment less than zero.");
        }
        if (n == 0) {
            n = 1;
        }
        if (n == this.lineIncrement) {
            return;
        }
        this.lineIncrement = n;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.getPeer();
        if (scrollbarPeer != null) {
            scrollbarPeer.setLineIncrement(this.lineIncrement);
        }
    }

    @Override
    public int getBlockIncrement() {
        return this.getPageIncrement();
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    @Override
    public synchronized void setBlockIncrement(int n) {
        this.setPageIncrement(n);
    }

    public void setPageIncrement(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Block increment less than zero.");
        }
        if (n == 0) {
            n = 1;
        }
        if (n == this.pageIncrement) {
            return;
        }
        this.pageIncrement = n;
        ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.getPeer();
        if (scrollbarPeer != null) {
            scrollbarPeer.setPageIncrement(this.pageIncrement);
        }
    }

    @Override
    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
        super.addNotify();
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustment_listeners = AWTEventMulticaster.add(this.adjustment_listeners, adjustmentListener);
        this.enableEvents(256L);
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustment_listeners = AWTEventMulticaster.remove(this.adjustment_listeners, adjustmentListener);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        this.value = adjustmentEvent.getValue();
        if (this.adjustment_listeners != null) {
            this.adjustment_listeners.adjustmentValueChanged(adjustmentEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 601 && aWTEvent.id >= 601) {
            AdjustmentEvent adjustmentEvent = (AdjustmentEvent)aWTEvent;
            boolean bl = adjustmentEvent.getValueIsAdjusting();
            if (bl) {
                this.setValueIsAdjusting(true);
            }
            try {
                this.setValue(((AdjustmentEvent)aWTEvent).getValue());
                if (this.adjustment_listeners != null || (this.eventMask & 0x100L) != 0L) {
                    this.processEvent(aWTEvent);
                }
                Object var5_4 = null;
                if (!bl) return;
                this.setValueIsAdjusting(false);
                return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!bl) throw throwable;
                this.setValueIsAdjusting(false);
                throw throwable;
            }
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    @Override
    protected String paramString() {
        return "value=" + this.getValue() + ",visibleAmount=" + this.getVisibleAmount() + ",minimum=" + this.getMinimum() + ",maximum=" + this.getMaximum() + ",pageIncrement=" + this.pageIncrement + ",lineIncrement=" + this.lineIncrement + ",orientation=" + (this.orientation == 0 ? "HORIZONTAL" : "VERTICAL") + super.paramString();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == AdjustmentListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.adjustment_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.getListeners(AdjustmentListener.class);
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean bl) {
        this.valueIsAdjusting = bl;
    }

    @Override
    String generateName() {
        return "scrollbar" + Scrollbar.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_scrollbar_number++;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTScrollBar
    extends Component.AccessibleAWTComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -344337268523697807L;

        protected AccessibleAWTScrollBar() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Scrollbar.this.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            if (Scrollbar.this.getValueIsAdjusting()) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(Scrollbar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            Scrollbar.this.setValue(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Scrollbar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Scrollbar.this.getMaximum());
        }
    }
}

