/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    private static final long serialVersionUID = -4345857070255674764L;
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    public Rectangle(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rectangle(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Rectangle(Point point, Dimension dimension) {
        this.x = point.x;
        this.y = point.y;
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public Rectangle(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Rectangle(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setRect(double d, double d2, double d3, double d4) {
        this.x = (int)Math.floor(d);
        this.y = (int)Math.floor(d2);
        this.width = (int)Math.ceil(d + d3) - this.x;
        this.height = (int)Math.ceil(d2 + d4) - this.y;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.move(n, n2);
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        return this.width > 0 && this.height > 0 && n3 > 0 && n4 > 0 && n >= this.x && n + n3 <= this.x + this.width && n2 >= this.y && n2 + n4 <= this.y + this.height;
    }

    public boolean inside(int n, int n2) {
        return this.width > 0 && this.height > 0 && n >= this.x && n < this.x + this.width && n2 >= this.y && n2 < this.y + this.height;
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.width > 0 && rectangle.height > 0 && this.width > 0 && this.height > 0 && rectangle.x < this.x + this.width && rectangle.x + rectangle.width > this.x && rectangle.y < this.y + this.height && rectangle.y + rectangle.height > this.y;
    }

    public Rectangle intersection(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        Rectangle.intersect(this, rectangle, rectangle2);
        return rectangle2;
    }

    public Rectangle union(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        Rectangle.union(this, rectangle, rectangle2);
        return rectangle2;
    }

    public void add(int n, int n2) {
        this.add((double)n, (double)n2);
    }

    public void add(Point point) {
        this.add((double)point.x, (double)point.y);
    }

    public void add(Rectangle rectangle) {
        Rectangle.union(this, rectangle, this);
    }

    public void grow(int n, int n2) {
        this.x -= n;
        this.y -= n2;
        this.width += n + n;
        this.height += n2 + n2;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public int outcode(double d, double d2) {
        int n = 0;
        if (this.width <= 0) {
            n |= 5;
        } else if (d < (double)this.x) {
            n |= 1;
        } else if (d > (double)(this.x + this.width)) {
            n |= 4;
        }
        if (this.height <= 0) {
            n |= 0xA;
        } else if (d2 < (double)this.y) {
            n |= 2;
        } else if (d2 > (double)(this.y + this.height)) {
            n |= 8;
        }
        return n;
    }

    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = rectangle2D.getBounds2D();
        Rectangle.intersect(this, rectangle2D, rectangle2D2);
        return rectangle2D2;
    }

    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = rectangle2D.getBounds2D();
        Rectangle.union(this, rectangle2D, rectangle2D2);
        return rectangle2D2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D rectangle2D = (Rectangle2D)object;
        return rectangle2D.getX() == (double)this.x && rectangle2D.getY() == (double)this.y && rectangle2D.getWidth() == (double)this.width && rectangle2D.getHeight() == (double)this.height;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + ']';
    }
}

