/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.peer.MenuComponentPeer;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;

public abstract class MenuComponent
implements Serializable {
    private static final long serialVersionUID = -4536902356223894379L;
    private Font font;
    private String name;
    transient MenuContainer parent;
    transient MenuComponentPeer peer;
    private transient Object tree_lock = this;
    private static transient Toolkit toolkit = Toolkit.getDefaultToolkit();
    AccessibleContext accessibleContext;
    private boolean nameExplicitlySet;
    private boolean newEventsOnly;
    transient FocusListener focusListener;

    public MenuComponent() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.parent != null) {
            return this.parent.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    String generateName() {
        return null;
    }

    public void setName(String string) {
        this.name = string;
        this.nameExplicitlySet = true;
    }

    public MenuContainer getParent() {
        return this.parent;
    }

    final void setParent(MenuContainer menuContainer) {
        this.parent = menuContainer;
    }

    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    final void setPeer(MenuComponentPeer menuComponentPeer) {
        this.peer = menuComponentPeer;
    }

    public void removeNotify() {
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.peer = null;
    }

    final Toolkit getToolkit() {
        return toolkit;
    }

    protected final Object getTreeLock() {
        return this.tree_lock;
    }

    final void setTreeLock(Object object) {
        this.tree_lock = object;
    }

    public boolean postEvent(Event event) {
        boolean bl = false;
        MenuContainer menuContainer = this.getParent();
        if (menuContainer != null) {
            bl = menuContainer.postEvent(event);
        }
        return bl;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        Event event = Component.translateEvent(aWTEvent);
        if (event != null) {
            this.postEvent(event);
        }
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        this.processEvent(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent && this.focusListener != null) {
            switch (aWTEvent.id) {
                case 1004: {
                    this.focusListener.focusGained((FocusEvent)aWTEvent);
                    break;
                }
                case 1005: {
                    this.focusListener.focusLost((FocusEvent)aWTEvent);
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "name=" + this.getName();
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    protected abstract class AccessibleAWTMenuComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent,
    AccessibleSelection {
        private static final long serialVersionUID = -4269533416223798698L;

        protected AccessibleAWTMenuComponent() {
        }

        public void addAccessibleSelection(int n) {
        }

        public void addFocusListener(FocusListener focusListener) {
            MenuComponent.this.focusListener = AWTEventMulticaster.add(MenuComponent.this.focusListener, focusListener);
        }

        public void clearAccessibleSelection() {
        }

        public boolean contains(Point point) {
            return this.getBounds().contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public String getAccessibleDescription() {
            return MenuComponent.this.getName();
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public String getAccessibleName() {
            return MenuComponent.this.getName();
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        public Color getBackground() {
            return SystemColor.menu;
        }

        public Rectangle getBounds() {
            return null;
        }

        public Cursor getCursor() {
            return Cursor.getDefaultCursor();
        }

        public Font getFont() {
            return MenuComponent.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return MenuComponent.this.getToolkit().getFontMetrics(font);
        }

        public Color getForeground() {
            return SystemColor.menuText;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public Point getLocation() {
            return this.getBounds().getLocation();
        }

        public Point getLocationOnScreen() {
            return null;
        }

        public Dimension getSize() {
            return this.getBounds().getSize();
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public boolean isEnabled() {
            return false;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isShowing() {
            return false;
        }

        public boolean isVisible() {
            return false;
        }

        public void removeAccessibleSelection(int n) {
        }

        public void removeFocusListener(FocusListener focusListener) {
            MenuComponent.this.focusListener = AWTEventMulticaster.remove(MenuComponent.this.focusListener, focusListener);
        }

        public void requestFocus() {
        }

        public void selectAllAccessibleSelection() {
            for (int i = 0; i < this.getAccessibleChildrenCount(); ++i) {
                this.addAccessibleSelection(i);
            }
        }

        public void setBackground(Color color) {
        }

        public void setBounds(Rectangle rectangle) {
        }

        public void setCursor(Cursor cursor) {
        }

        public void setEnabled(boolean bl) {
        }

        public void setFont(Font font) {
            MenuComponent.this.setFont(font);
        }

        public void setForeground(Color color) {
        }

        public void setLocation(Point point) {
            this.getBounds().setLocation(point);
        }

        public void setSize(Dimension dimension) {
            this.getBounds().setSize(dimension);
        }

        public void setVisible(boolean bl) {
        }
    }
}

