/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.ArrayList;

public class MediaTracker
implements Serializable {
    public static final int LOADING = 1;
    public static final int ABORTED = 2;
    public static final int ERRORED = 4;
    public static final int COMPLETE = 8;
    Component target;
    MediaEntry head;
    static final long serialVersionUID = -483174189758638095L;

    public MediaTracker(Component component) {
        this.target = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(Image image, int n) {
        MediaEntry mediaEntry = new MediaEntry();
        mediaEntry.id = n;
        mediaEntry.image = image;
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            mediaEntry.next = this.head;
            this.head = mediaEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(Image image, int n, int n2, int n3) {
        MediaEntry mediaEntry = new MediaEntry();
        mediaEntry.id = n;
        mediaEntry.image = image;
        mediaEntry.width = n2;
        mediaEntry.height = n3;
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            mediaEntry.next = this.head;
            this.head = mediaEntry;
        }
    }

    public boolean checkAll() {
        return this.checkAll(false);
    }

    public boolean checkAll(boolean bl) {
        MediaEntry mediaEntry = this.head;
        boolean bl2 = true;
        while (mediaEntry != null) {
            if ((mediaEntry.status & 0xE) == 0) {
                if (bl && (mediaEntry.status & 1) == 0) {
                    int n;
                    if (this.target.prepareImage(mediaEntry.image, mediaEntry)) {
                        mediaEntry.status = 8;
                    } else {
                        mediaEntry.status = 1;
                        n = this.target.checkImage(mediaEntry.image, mediaEntry);
                        if ((n & 0x80) != 0) {
                            mediaEntry.status = 2;
                        } else if ((n & 0x40) != 0) {
                            mediaEntry.status = 4;
                        } else if ((n & 0x20) != 0) {
                            mediaEntry.status = 8;
                        }
                    }
                    int n2 = n = (mediaEntry.status & 0xE) != 0 ? 1 : 0;
                    if (n == 0) {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
            }
            mediaEntry = mediaEntry.next;
        }
        return bl2;
    }

    public boolean isErrorAny() {
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if ((mediaEntry.status & 4) != 0) {
                return true;
            }
            mediaEntry = mediaEntry.next;
        }
        return false;
    }

    public Object[] getErrorsAny() {
        MediaEntry mediaEntry = this.head;
        ArrayList<Image> arrayList = null;
        while (mediaEntry != null) {
            if ((mediaEntry.status & 4) != 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Image>();
                }
                arrayList.add(mediaEntry.image);
            }
            mediaEntry = mediaEntry.next;
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAll() throws InterruptedException {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!this.checkAll(true)) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAll(long l) throws InterruptedException {
        long l2 = System.currentTimeMillis();
        boolean bl = this.checkAll(true);
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!bl) {
                this.wait(l);
                bl = this.checkAll(true);
                if (System.currentTimeMillis() - l2 <= l) continue;
            }
        }
        return bl;
    }

    public int statusAll(boolean bl) {
        int n = 0;
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if (bl && mediaEntry.status == 0) {
                if (this.target.prepareImage(mediaEntry.image, mediaEntry)) {
                    mediaEntry.status = 8;
                } else {
                    mediaEntry.status = 1;
                    int n2 = this.target.checkImage(mediaEntry.image, mediaEntry);
                    if ((n2 & 0x80) != 0) {
                        mediaEntry.status = 2;
                    } else if ((n2 & 0x40) != 0) {
                        mediaEntry.status = 4;
                    } else if ((n2 & 0x20) != 0) {
                        mediaEntry.status = 8;
                    }
                }
            }
            n |= mediaEntry.status;
            mediaEntry = mediaEntry.next;
        }
        return n;
    }

    public boolean checkID(int n) {
        return this.checkID(n, false);
    }

    public boolean checkID(int n, boolean bl) {
        MediaEntry mediaEntry = this.head;
        boolean bl2 = true;
        while (mediaEntry != null) {
            if (mediaEntry.id == n && (mediaEntry.status & 0xE) == 0) {
                if (bl && (mediaEntry.status & 1) == 0) {
                    int n2;
                    mediaEntry.status = 1;
                    if (this.target.prepareImage(mediaEntry.image, mediaEntry)) {
                        mediaEntry.status = 8;
                    } else {
                        n2 = this.target.checkImage(mediaEntry.image, mediaEntry);
                        if ((n2 & 0x80) != 0) {
                            mediaEntry.status = 2;
                        } else if ((n2 & 0x40) != 0) {
                            mediaEntry.status = 4;
                        } else if ((n2 & 0x20) != 0) {
                            mediaEntry.status = 8;
                        }
                    }
                    int n3 = n2 = (mediaEntry.status & 0xE) != 0 ? 1 : 0;
                    if (n2 == 0) {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
            }
            mediaEntry = mediaEntry.next;
        }
        return bl2;
    }

    public boolean isErrorID(int n) {
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if (mediaEntry.id == n && (mediaEntry.status & 4) != 0) {
                return true;
            }
            mediaEntry = mediaEntry.next;
        }
        return false;
    }

    public Object[] getErrorsID(int n) {
        MediaEntry mediaEntry = this.head;
        ArrayList<Image> arrayList = null;
        while (mediaEntry != null) {
            if (mediaEntry.id == n && (mediaEntry.status & 4) != 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Image>();
                }
                arrayList.add(mediaEntry.image);
            }
            mediaEntry = mediaEntry.next;
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForID(int n) throws InterruptedException {
        MediaEntry mediaEntry = this.head;
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!this.checkID(n, true)) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForID(int n, long l) throws InterruptedException {
        MediaEntry mediaEntry = this.head;
        long l2 = System.currentTimeMillis();
        boolean bl = this.checkID(n, true);
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            while (!bl) {
                this.wait(l);
                bl = this.checkID(n, true);
                if (System.currentTimeMillis() - l2 <= l) continue;
            }
        }
        return bl;
    }

    public int statusID(int n, boolean bl) {
        int n2 = 0;
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if (mediaEntry.id == n) {
                if (bl && mediaEntry.status == 0) {
                    if (this.target.prepareImage(mediaEntry.image, mediaEntry)) {
                        mediaEntry.status = 8;
                    } else {
                        mediaEntry.status = 1;
                        int n3 = this.target.checkImage(mediaEntry.image, mediaEntry);
                        if ((n3 & 0x80) != 0) {
                            mediaEntry.status = 2;
                        } else if ((n3 & 0x40) != 0) {
                            mediaEntry.status = 4;
                        } else if ((n3 & 0x20) != 0) {
                            mediaEntry.status = 8;
                        }
                    }
                }
                n2 |= mediaEntry.status;
            }
            mediaEntry = mediaEntry.next;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImage(Image image) {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            MediaEntry mediaEntry = this.head;
            MediaEntry mediaEntry2 = null;
            while (mediaEntry != null) {
                if (mediaEntry.image == image) {
                    if (mediaEntry2 == null) {
                        this.head = mediaEntry.next;
                    } else {
                        mediaEntry2.next = mediaEntry.next;
                    }
                } else {
                    mediaEntry2 = mediaEntry;
                }
                mediaEntry = mediaEntry.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImage(Image image, int n) {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            MediaEntry mediaEntry = this.head;
            MediaEntry mediaEntry2 = null;
            while (mediaEntry != null) {
                if (mediaEntry.id == n && mediaEntry.image == image) {
                    if (mediaEntry2 == null) {
                        this.head = mediaEntry.next;
                    } else {
                        mediaEntry2.next = mediaEntry.next;
                    }
                } else {
                    mediaEntry2 = mediaEntry;
                }
                mediaEntry = mediaEntry.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImage(Image image, int n, int n2, int n3) {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            MediaEntry mediaEntry = this.head;
            MediaEntry mediaEntry2 = null;
            while (mediaEntry != null) {
                if (mediaEntry.id == n && mediaEntry.image == image && mediaEntry.width == n2 && mediaEntry.height == n3) {
                    if (mediaEntry2 == null) {
                        this.head = mediaEntry.next;
                    } else {
                        mediaEntry2.next = mediaEntry.next;
                    }
                } else {
                    mediaEntry2 = mediaEntry;
                }
                mediaEntry = mediaEntry.next;
            }
        }
    }

    class MediaEntry
    implements ImageObserver {
        int id;
        Image image;
        MediaEntry next;
        int status;
        int width;
        int height;

        MediaEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            this.status = (n & 0x80) != 0 ? 2 : ((n & 0x40) != 0 ? 4 : ((n & 0x20) != 0 ? 8 : 0));
            MediaTracker mediaTracker = MediaTracker.this;
            synchronized (mediaTracker) {
                MediaTracker.this.notifyAll();
            }
            return (this.status & 0xE) == 0;
        }
    }
}

