/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.util.WeakHashMap;

final class LightweightDispatcher {
    private static WeakHashMap instances = new WeakHashMap();
    private Component lastTarget;
    private Component mouseEventTarget;

    static LightweightDispatcher getInstance() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        LightweightDispatcher lightweightDispatcher = (LightweightDispatcher)instances.get(threadGroup);
        if (lightweightDispatcher == null) {
            lightweightDispatcher = new LightweightDispatcher();
            instances.put(threadGroup, lightweightDispatcher);
        }
        return lightweightDispatcher;
    }

    private LightweightDispatcher() {
    }

    public boolean dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            return this.handleMouseEvent(mouseEvent);
        }
        return false;
    }

    private boolean handleMouseEvent(MouseEvent mouseEvent) {
        Container container = (Container)mouseEvent.getSource();
        Component component = this.findTarget(container, mouseEvent.getX(), mouseEvent.getY());
        this.trackEnterExit(component, mouseEvent);
        int n = mouseEvent.getID();
        if (!this.isDragging(mouseEvent) && n != 500) {
            Component component2 = this.mouseEventTarget = component != container ? component : null;
        }
        if (this.mouseEventTarget != null) {
            switch (n) {
                case 504: 
                case 505: {
                    break;
                }
                case 501: 
                case 502: 
                case 503: {
                    this.redispatch(mouseEvent, this.mouseEventTarget, n);
                    break;
                }
                case 500: {
                    if (component != this.mouseEventTarget) break;
                    this.redispatch(mouseEvent, this.mouseEventTarget, n);
                    break;
                }
                case 506: {
                    if (!this.isDragging(mouseEvent)) break;
                    this.redispatch(mouseEvent, this.mouseEventTarget, n);
                    break;
                }
                case 507: {
                    this.redispatch(mouseEvent, this.mouseEventTarget, n);
                }
            }
            mouseEvent.consume();
        }
        return mouseEvent.isConsumed();
    }

    private Component findTarget(Container container, int n, int n2) {
        Component component = null;
        int n3 = container.ncomponents;
        for (int i = 0; i < n3 && component == null; ++i) {
            Component component2 = container.component[i];
            int n4 = n - component2.x;
            int n5 = n2 - component2.y;
            if (component2 == null || !component2.visible || !(component2.peer instanceof LightweightPeer) || !component2.contains(n4, n5)) continue;
            if (component2 instanceof Container) {
                Component component3 = this.findTarget((Container)component2, n4, n5);
                if (component3 == null) continue;
                component = component3;
                continue;
            }
            if (!this.isMouseListening(component2)) continue;
            component = component2;
        }
        if (component == null && container.contains(n, n2) && this.isMouseListening(container)) {
            component = container;
        }
        return component;
    }

    private boolean isMouseListening(Component component) {
        return component.mouseListener != null || component.mouseMotionListener != null || component.mouseWheelListener != null || (component.eventMask & 0x10L) != 0L || (component.eventMask & 0x20L) != 0L || (component.eventMask & 0x20000L) != 0L;
    }

    private void trackEnterExit(Component component, MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        if (component != this.lastTarget) {
            if (this.lastTarget != null) {
                this.redispatch(mouseEvent, this.lastTarget, 505);
            }
            if (n == 505) {
                mouseEvent.consume();
            }
            if (component != null) {
                this.redispatch(mouseEvent, component, 504);
            }
            if (n == 504) {
                mouseEvent.consume();
            }
            this.lastTarget = component;
        }
    }

    private void redispatch(MouseEvent mouseEvent, Component component, int n) {
        Component component2 = mouseEvent.getComponent();
        assert (component != null);
        if (component.isShowing()) {
            Serializable serializable;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            for (serializable = component; serializable != null && serializable != component2; serializable = serializable.getParent()) {
                n2 -= serializable.x;
                n3 -= serializable.y;
            }
            if (n == 507) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
                serializable = new MouseWheelEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
            } else {
                serializable = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            if (component == component2) {
                ((Container)component).dispatchNoLightweight((AWTEvent)serializable);
            } else {
                component.dispatchEvent((AWTEvent)serializable);
            }
        }
    }

    private boolean isDragging(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        int n2 = mouseEvent.getID();
        if (n2 == 501 || n2 == 502) {
            switch (mouseEvent.getButton()) {
                case 1: {
                    n ^= 0x400;
                    break;
                }
                case 2: {
                    n ^= 0x800;
                    break;
                }
                case 3: {
                    n ^= 0x1000;
                }
            }
        }
        return (n & 0x1C00) != 0;
    }
}

