/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyboardFocusManager
implements KeyEventDispatcher,
KeyEventPostProcessor {
    public static final int FORWARD_TRAVERSAL_KEYS = 0;
    public static final int BACKWARD_TRAVERSAL_KEYS = 1;
    public static final int UP_CYCLE_TRAVERSAL_KEYS = 2;
    public static final int DOWN_CYCLE_TRAVERSAL_KEYS = 3;
    private static final Set DEFAULT_FORWARD_KEYS;
    private static final Set DEFAULT_BACKWARD_KEYS;
    private static Map currentKeyboardFocusManagers;
    private static Map currentFocusOwners;
    private static Map currentPermanentFocusOwners;
    private static Map currentFocusedWindows;
    private static Map currentActiveWindows;
    private static Map currentFocusCycleRoots;
    private FocusTraversalPolicy defaultPolicy;
    private Set[] defaultFocusKeys = new Set[]{DEFAULT_FORWARD_KEYS, DEFAULT_BACKWARD_KEYS, Collections.EMPTY_SET, Collections.EMPTY_SET};
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private final ArrayList keyEventDispatchers = new ArrayList();
    private final ArrayList keyEventPostProcessors = new ArrayList();
    private static HashMap focusRequests;

    public static KeyboardFocusManager getCurrentKeyboardFocusManager() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (currentKeyboardFocusManagers.get(threadGroup) == null) {
            KeyboardFocusManager.setCurrentKeyboardFocusManager(null);
        }
        return (KeyboardFocusManager)currentKeyboardFocusManagers.get(threadGroup);
    }

    public static void setCurrentKeyboardFocusManager(KeyboardFocusManager keyboardFocusManager) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("replaceKeyboardFocusManager"));
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        KeyboardFocusManager keyboardFocusManager2 = keyboardFocusManager == null ? new DefaultKeyboardFocusManager() : keyboardFocusManager;
        currentKeyboardFocusManagers.put(threadGroup, keyboardFocusManager2);
    }

    public Component getFocusOwner() {
        return (Component)this.getObject(currentFocusOwners);
    }

    protected Component getGlobalFocusOwner() {
        return (Component)this.getGlobalObject(currentFocusOwners, true);
    }

    protected void setGlobalFocusOwner(Component component) {
        if (component == null || component.focusable) {
            this.setGlobalObject(currentFocusOwners, component, "focusOwner");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGlobalFocusOwner() {
        Map map = currentFocusOwners;
        synchronized (map) {
            EventQueue eventQueue;
            Component component = this.getGlobalFocusOwner();
            Component component2 = this.getGlobalPermanentFocusOwner();
            this.setGlobalFocusOwner(null);
            this.setGlobalPermanentFocusOwner(null);
            if (component != null) {
                eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                if (component != component2) {
                    eventQueue.postEvent(new FocusEvent(component, 1005, true));
                } else {
                    eventQueue.postEvent(new FocusEvent(component, 1005, false));
                }
            }
            if (component != component2) {
                eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                eventQueue.postEvent(new FocusEvent(component2, 1005, false));
            }
        }
    }

    public Component getPermanentFocusOwner() {
        return (Component)this.getObject(currentPermanentFocusOwners);
    }

    protected Component getGlobalPermanentFocusOwner() {
        return (Component)this.getGlobalObject(currentPermanentFocusOwners, true);
    }

    protected void setGlobalPermanentFocusOwner(Component component) {
        if (component == null || component.focusable) {
            this.setGlobalObject(currentPermanentFocusOwners, component, "permanentFocusOwner");
        }
    }

    public Window getFocusedWindow() {
        return (Window)this.getObject(currentFocusedWindows);
    }

    protected Window getGlobalFocusedWindow() {
        return (Window)this.getGlobalObject(currentFocusedWindows, true);
    }

    protected void setGlobalFocusedWindow(Window window) {
        if (window == null || window.focusable) {
            this.setGlobalObject(currentFocusedWindows, window, "focusedWindow");
        }
    }

    public Window getActiveWindow() {
        return (Window)this.getObject(currentActiveWindows);
    }

    protected Window getGlobalActiveWindow() {
        return (Window)this.getGlobalObject(currentActiveWindows, true);
    }

    protected void setGlobalActiveWindow(Window window) {
        this.setGlobalObject(currentActiveWindows, window, "activeWindow");
    }

    public FocusTraversalPolicy getDefaultFocusTraversalPolicy() {
        if (this.defaultPolicy == null) {
            this.defaultPolicy = new DefaultFocusTraversalPolicy();
        }
        return this.defaultPolicy;
    }

    public void setDefaultFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        if (focusTraversalPolicy == null) {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("defaultFocusTraversalPolicy", this.defaultPolicy, focusTraversalPolicy);
        this.defaultPolicy = focusTraversalPolicy;
    }

    public void setDefaultFocusTraversalKeys(int n, Set<? extends AWTKeyStroke> set) {
        String string;
        Set set2;
        Set set3;
        Set set4;
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        if (set == null) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 0: {
                set4 = this.defaultFocusKeys[1];
                set3 = this.defaultFocusKeys[2];
                set2 = this.defaultFocusKeys[3];
                string = "forwardDefaultFocusTraversalKeys";
                break;
            }
            case 1: {
                set4 = this.defaultFocusKeys[0];
                set3 = this.defaultFocusKeys[2];
                set2 = this.defaultFocusKeys[3];
                string = "backwardDefaultFocusTraversalKeys";
                break;
            }
            case 2: {
                set4 = this.defaultFocusKeys[0];
                set3 = this.defaultFocusKeys[1];
                set2 = this.defaultFocusKeys[3];
                string = "upCycleDefaultFocusTraversalKeys";
                break;
            }
            case 3: {
                set4 = this.defaultFocusKeys[0];
                set3 = this.defaultFocusKeys[1];
                set2 = this.defaultFocusKeys[2];
                string = "downCycleDefaultFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator<? extends AWTKeyStroke> iterator = set.iterator();
        while (--n2 >= 0) {
            AWTKeyStroke aWTKeyStroke = iterator.next();
            if (aWTKeyStroke instanceof AWTKeyStroke && !set4.contains(aWTKeyStroke) && !set3.contains(aWTKeyStroke) && !set2.contains(aWTKeyStroke) && aWTKeyStroke.keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        set = Collections.unmodifiableSet(new HashSet<AWTKeyStroke>(set));
        this.firePropertyChange(string, this.defaultFocusKeys[n], set);
        this.defaultFocusKeys[n] = set;
    }

    public Set<AWTKeyStroke> getDefaultFocusTraversalKeys(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        return this.defaultFocusKeys[n];
    }

    public Container getCurrentFocusCycleRoot() {
        return (Container)this.getObject(currentFocusCycleRoots);
    }

    protected Container getGlobalCurrentFocusCycleRoot() {
        return (Container)this.getGlobalObject(currentFocusCycleRoots, true);
    }

    public void setGlobalCurrentFocusCycleRoot(Container container) {
        this.setGlobalObject(currentFocusCycleRoots, container, "currentFocusCycleRoot");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.propertyChangeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(string, vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(string, vetoableChangeListener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String string) {
        return this.vetoableChangeSupport.getVetoableChangeListeners(string);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public void addKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        if (keyEventDispatcher != null) {
            this.keyEventDispatchers.add(keyEventDispatcher);
        }
    }

    public void removeKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        this.keyEventDispatchers.remove(keyEventDispatcher);
    }

    protected List<KeyEventDispatcher> getKeyEventDispatchers() {
        return (List)this.keyEventDispatchers.clone();
    }

    public void addKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        if (keyEventPostProcessor != null) {
            this.keyEventPostProcessors.add(keyEventPostProcessor);
        }
    }

    public void removeKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        this.keyEventPostProcessors.remove(keyEventPostProcessor);
    }

    protected List<KeyEventPostProcessor> getKeyEventPostProcessors() {
        return (List)this.keyEventPostProcessors.clone();
    }

    public abstract boolean dispatchEvent(AWTEvent var1);

    public final void redispatchEvent(Component component, AWTEvent aWTEvent) {
        aWTEvent.isFocusManagerEvent = true;
        component.dispatchEvent(aWTEvent);
        aWTEvent.isFocusManagerEvent = false;
    }

    @Override
    public abstract boolean dispatchKeyEvent(KeyEvent var1);

    @Override
    public abstract boolean postProcessKeyEvent(KeyEvent var1);

    public abstract void processKeyEvent(Component var1, KeyEvent var2);

    protected abstract void enqueueKeyEvents(long var1, Component var3);

    protected abstract void dequeueKeyEvents(long var1, Component var3);

    protected abstract void discardKeyEvents(Component var1);

    public abstract void focusNextComponent(Component var1);

    public abstract void focusPreviousComponent(Component var1);

    public abstract void upFocusCycle(Component var1);

    public abstract void downFocusCycle(Container var1);

    public final void focusNextComponent() {
        this.focusNextComponent(null);
    }

    public final void focusPreviousComponent() {
        this.focusPreviousComponent(null);
    }

    public final void upFocusCycle() {
        this.upFocusCycle(null);
    }

    public final void downFocusCycle() {
        Component component = this.getGlobalFocusOwner();
        if (component instanceof Container && ((Container)component).isFocusCycleRoot()) {
            this.downFocusCycle((Container)component);
        }
    }

    private Object getObject(Map map) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        return map.get(threadGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getGlobalObject(Map map, boolean bl) {
        Object object;
        Object object2;
        if (bl && this != (object2 = (KeyboardFocusManager)currentKeyboardFocusManagers.get(object = Thread.currentThread().getThreadGroup()))) {
            throw new SecurityException("Attempted to retrieve an object from a keyboard focus manager that isn't associated with the current thread group.");
        }
        object = map;
        synchronized (object) {
            object2 = map.values();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Component component = (Component)iterator.next();
                if (component == null) continue;
                return component;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGlobalObject(Map map, Object object, String string) {
        Map map2 = map;
        synchronized (map2) {
            ThreadGroup threadGroup2;
            Object object2 = this.getGlobalObject(map, false);
            Set set = map.keySet();
            for (ThreadGroup threadGroup2 : set) {
                if (map.get(threadGroup2) == null) continue;
                map.put(threadGroup2, null);
                break;
            }
            threadGroup2 = Thread.currentThread().getThreadGroup();
            this.firePropertyChange(string, object2, object);
            try {
                this.fireVetoableChange(string, object2, object);
                map.put(threadGroup2, object);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    static AWTEvent retargetFocusEvent(AWTEvent aWTEvent) {
        FocusEvent focusEvent;
        Component component;
        if (aWTEvent instanceof FocusEvent && focusRequests.containsKey(component = (focusEvent = (FocusEvent)aWTEvent).getComponent())) {
            Component component2 = (Component)focusRequests.get(component);
            aWTEvent = new FocusEvent(component2, focusEvent.id, focusEvent.isTemporary());
            focusRequests.remove(component);
        }
        return aWTEvent;
    }

    static void addLightweightFocusRequest(Component component, Component component2) {
        focusRequests.put(component, component2);
    }

    static {
        HashSet hashSet = new HashSet();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        DEFAULT_FORWARD_KEYS = Collections.unmodifiableSet(hashSet);
        hashSet = new HashSet();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 192));
        DEFAULT_BACKWARD_KEYS = Collections.unmodifiableSet(hashSet);
        currentKeyboardFocusManagers = new HashMap();
        currentFocusOwners = new HashMap();
        currentPermanentFocusOwners = new HashMap();
        currentFocusedWindows = new HashMap();
        currentActiveWindows = new HashMap();
        currentFocusCycleRoots = new HashMap();
        focusRequests = new HashMap();
    }
}

