/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ReplicateScaleFilter;

public abstract class Image {
    public static final Object UndefinedProperty = new String("undefined property");
    public static final int SCALE_DEFAULT = 1;
    public static final int SCALE_FAST = 2;
    public static final int SCALE_SMOOTH = 4;
    public static final int SCALE_REPLICATE = 8;
    public static final int SCALE_AREA_AVERAGING = 16;
    protected float accelerationPriority;

    public abstract int getWidth(ImageObserver var1);

    public abstract int getHeight(ImageObserver var1);

    public abstract ImageProducer getSource();

    public abstract Graphics getGraphics();

    public abstract Object getProperty(String var1, ImageObserver var2);

    public Image getScaledInstance(int n, int n2, int n3) {
        ReplicateScaleFilter replicateScaleFilter;
        switch (n3) {
            case 4: 
            case 16: {
                replicateScaleFilter = new AreaAveragingScaleFilter(n, n2);
                break;
            }
            default: {
                replicateScaleFilter = new ReplicateScaleFilter(n, n2);
            }
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getSource(), replicateScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public abstract void flush();

    public void setAccelerationPriority(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Invalid priority value.");
        }
        this.accelerationPriority = f;
    }

    public float getAccelerationPriority() {
        return this.accelerationPriority;
    }
}

