/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridBagLayout
implements Serializable,
LayoutManager2 {
    private static final long serialVersionUID = 8838754796412211005L;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected static final int MAXGRIDSIZE = 512;
    protected Hashtable<Component, GridBagConstraints> comptable = new Hashtable();
    private Hashtable<Component, GridBagConstraints> internalcomptable = new Hashtable();
    protected GridBagLayoutInfo layoutInfo;
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    public double[] columnWeights;
    public int[] columnWidths;
    public double[] rowWeights;
    public int[] rowHeights;

    private int sumIntArray(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        return n2;
    }

    private int sumIntArray(int[] nArray) {
        return this.sumIntArray(nArray, nArray.length);
    }

    private double sumDoubleArray(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof GridBagConstraints)) {
            throw new IllegalArgumentException("constraints " + object + " are not an instance of GridBagConstraints");
        }
        this.setConstraints(component, (GridBagConstraints)object);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (container == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (container == null) {
            return new Dimension(0, 0);
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 1);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container container) {
        this.arrangeGrid(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.layoutInfo = null;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        if (gridBagConstraints2.gridx < 0) {
            gridBagConstraints2.gridx = -1;
        }
        if (gridBagConstraints2.gridy < 0) {
            gridBagConstraints2.gridy = -1;
        }
        if (gridBagConstraints2.gridwidth == 0) {
            gridBagConstraints2.gridwidth = 0;
        } else if (gridBagConstraints2.gridwidth < 0) {
            gridBagConstraints2.gridwidth = 1;
        }
        if (gridBagConstraints2.gridheight == 0) {
            gridBagConstraints2.gridheight = 0;
        } else if (gridBagConstraints2.gridheight < 0) {
            gridBagConstraints2.gridheight = 1;
        }
        this.comptable.put(component, gridBagConstraints2);
    }

    public GridBagConstraints getConstraints(Component component) {
        return (GridBagConstraints)this.lookupConstraints(component).clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = this.comptable.get(component);
        }
        return gridBagConstraints;
    }

    private GridBagConstraints lookupInternalConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.internalcomptable.get(component);
        if (gridBagConstraints == null) {
            gridBagConstraints = (GridBagConstraints)this.lookupConstraints(component).clone();
            this.internalcomptable.put(component, gridBagConstraints);
        }
        return gridBagConstraints;
    }

    public Point getLayoutOrigin() {
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        return new Point(this.layoutInfo.pos_x, this.layoutInfo.pos_y);
    }

    public int[][] getLayoutDimensions() {
        int[][] nArrayArray = new int[2][];
        if (this.layoutInfo == null) {
            nArrayArray[0] = new int[0];
            nArrayArray[1] = new int[0];
            return nArrayArray;
        }
        nArrayArray[0] = new int[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWidths, 0, nArrayArray[0], 0, this.layoutInfo.cols);
        nArrayArray[1] = new int[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowHeights, 0, nArrayArray[1], 0, this.layoutInfo.rows);
        return nArrayArray;
    }

    public double[][] getLayoutWeights() {
        double[][] dArrayArray = new double[2][];
        if (this.layoutInfo == null) {
            dArrayArray[0] = new double[0];
            dArrayArray[1] = new double[0];
            return dArrayArray;
        }
        dArrayArray[0] = new double[this.layoutInfo.cols];
        System.arraycopy(this.layoutInfo.colWeights, 0, dArrayArray[0], 0, this.layoutInfo.cols);
        dArrayArray[1] = new double[this.layoutInfo.rows];
        System.arraycopy(this.layoutInfo.rowWeights, 0, dArrayArray[1], 0, this.layoutInfo.rows);
        return dArrayArray;
    }

    public Point location(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.layoutInfo == null) {
            return new Point(0, 0);
        }
        int n6 = this.layoutInfo.pos_x;
        int n7 = this.layoutInfo.pos_y;
        for (n5 = 0; n5 < this.layoutInfo.cols && n >= n6 + (n4 = this.layoutInfo.colWidths[n5]); ++n5) {
            n6 += n4;
        }
        for (n3 = 0; n3 < this.layoutInfo.rows && n2 >= n7 + (n4 = this.layoutInfo.rowHeights[n3]); ++n3) {
            n7 += n4;
        }
        return new Point(n5, n3);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        Insets insets = gridBagConstraints.insets;
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
    }

    protected void ArrangeGrid(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray.length == 0) {
            return;
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        if (gridBagLayoutInfo.cols == 0 && gridBagLayoutInfo.rows == 0) {
            return;
        }
        Component component = null;
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2 = componentArray[i];
            if (!component2.isVisible()) continue;
            Dimension dimension = component2.getPreferredSize();
            GridBagConstraints gridBagConstraints = this.lookupInternalConstraints(component2);
            rectangle.y = component != null && gridBagConstraints.gridheight == 0 ? (rectangle.y += rectangle.height) : this.sumIntArray(gridBagLayoutInfo.rowHeights, gridBagConstraints.gridy);
            rectangle.x = component != null && gridBagConstraints.gridwidth == 0 ? (rectangle.x += rectangle.width) : this.sumIntArray(gridBagLayoutInfo.colWidths, gridBagConstraints.gridx);
            rectangle.width = this.sumIntArray(gridBagLayoutInfo.colWidths, gridBagConstraints.gridx + gridBagConstraints.gridwidth) - rectangle.x;
            rectangle.height = this.sumIntArray(gridBagLayoutInfo.rowHeights, gridBagConstraints.gridy + gridBagConstraints.gridheight) - rectangle.y;
            this.AdjustForGravity(gridBagConstraints, rectangle);
            dimension.width += gridBagConstraints.ipadx;
            dimension.height += gridBagConstraints.ipady;
            switch (gridBagConstraints.fill) {
                case 2: {
                    dimension.width = rectangle.width;
                    break;
                }
                case 3: {
                    dimension.height = rectangle.height;
                    break;
                }
                case 1: {
                    dimension.width = rectangle.width;
                    dimension.height = rectangle.height;
                }
            }
            int n = 0;
            int n2 = 0;
            switch (gridBagConstraints.anchor) {
                case 11: {
                    n = rectangle.x + (rectangle.width - dimension.width) / 2;
                    n2 = rectangle.y;
                    break;
                }
                case 15: {
                    n = rectangle.x + (rectangle.width - dimension.width) / 2;
                    n2 = rectangle.y + rectangle.height - dimension.height;
                    break;
                }
                case 17: {
                    n = rectangle.x;
                    n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
                    break;
                }
                case 13: {
                    n = rectangle.x + rectangle.width - dimension.width;
                    n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
                    break;
                }
                case 12: {
                    n = rectangle.x + rectangle.width - dimension.width;
                    n2 = rectangle.y;
                    break;
                }
                case 18: {
                    n = rectangle.x;
                    n2 = rectangle.y;
                    break;
                }
                case 14: {
                    n = rectangle.x + rectangle.width - dimension.width;
                    n2 = rectangle.y + rectangle.height - dimension.height;
                    break;
                }
                case 16: {
                    n = rectangle.x;
                    n2 = rectangle.y + rectangle.height - dimension.height;
                    break;
                }
                default: {
                    n = rectangle.x + (rectangle.width - dimension.width) / 2;
                    n2 = rectangle.y + (rectangle.height - dimension.height) / 2;
                }
            }
            component2.setBounds(gridBagLayoutInfo.pos_x + n, gridBagLayoutInfo.pos_y + n2, dimension.width, dimension.height);
            component = component2;
        }
        this.layoutInfo = this.getLayoutInfo(container, 2);
    }

    protected GridBagLayoutInfo GetLayoutInfo(Container container, int n) {
        int n2;
        Serializable serializable;
        int n3;
        GridBagConstraints gridBagConstraints;
        Serializable serializable2;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        HashMap<Integer, Component> hashMap = new HashMap<Integer, Component>();
        HashMap<Integer, Component> hashMap2 = new HashMap<Integer, Component>();
        Component[] componentArray = container.getComponents();
        ArrayList<Component> arrayList = new ArrayList<Component>(componentArray.length);
        ArrayList<Component> arrayList2 = new ArrayList<Component>(componentArray.length);
        for (int i = 0; i < componentArray.length; ++i) {
            GridBagConstraints gridBagConstraints2;
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            serializable2 = this.lookupConstraints(component);
            gridBagConstraints = (GridBagConstraints)((GridBagConstraints)serializable2).clone();
            this.internalcomptable.put(component, gridBagConstraints);
            if (gridBagConstraints.gridx == -1) {
                if (gridBagConstraints.gridy == -1) {
                    gridBagConstraints.gridy = n4;
                }
                if (!hashMap.containsKey(new Integer(gridBagConstraints.gridy))) {
                    n3 = 0;
                } else {
                    Component component2 = (Component)hashMap.get(new Integer(gridBagConstraints.gridy));
                    serializable = this.lookupInternalConstraints(component2);
                    n3 = serializable.gridx + Math.max(1, serializable.gridwidth);
                }
                for (int j = gridBagConstraints.gridy + 1; j < gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight); ++j) {
                    if (!hashMap.containsKey(new Integer(j))) continue;
                    serializable = (Component)hashMap.get(new Integer(j));
                    gridBagConstraints2 = this.lookupInternalConstraints((Component)serializable);
                    n3 = Math.max(n3, gridBagConstraints2.gridx + Math.max(1, gridBagConstraints2.gridwidth));
                }
                gridBagConstraints.gridx = n3;
            } else if (gridBagConstraints.gridy == -1) {
                if (!hashMap2.containsKey(new Integer(gridBagConstraints.gridx))) {
                    n3 = n4;
                } else {
                    Component component3 = (Component)hashMap2.get(new Integer(gridBagConstraints.gridx));
                    serializable = this.lookupInternalConstraints(component3);
                    n3 = serializable.gridy + Math.max(1, serializable.gridheight);
                }
                for (int j = gridBagConstraints.gridx + 1; j < gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth); ++j) {
                    if (!hashMap2.containsKey(new Integer(j))) continue;
                    serializable = (Component)hashMap2.get(new Integer(j));
                    gridBagConstraints2 = this.lookupInternalConstraints((Component)serializable);
                    n3 = Math.max(n3, gridBagConstraints2.gridy + Math.max(1, gridBagConstraints2.gridheight));
                }
                gridBagConstraints.gridy = n3;
            }
            n5 = Math.max(n5, gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth));
            n6 = Math.max(n6, gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight));
            this.sortBySpan(component, gridBagConstraints.gridwidth, arrayList, true);
            this.sortBySpan(component, gridBagConstraints.gridheight, arrayList2, false);
            if (gridBagConstraints.gridwidth == 0) {
                n4 = gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight);
                continue;
            }
            if (gridBagConstraints.gridwidth == 0) continue;
            for (n3 = gridBagConstraints.gridy; n3 < gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight); ++n3) {
                if (hashMap.containsKey(new Integer(n3))) {
                    Component component4 = (Component)hashMap.get(new Integer(n3));
                    serializable = this.lookupInternalConstraints(component4);
                    if (gridBagConstraints.gridx <= serializable.gridx) continue;
                    hashMap.put(new Integer(n3), component);
                    continue;
                }
                hashMap.put(new Integer(n3), component);
            }
            for (n3 = gridBagConstraints.gridx; n3 < gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth); ++n3) {
                if (hashMap2.containsKey(new Integer(n3))) {
                    Component component5 = (Component)hashMap2.get(new Integer(n3));
                    serializable = this.lookupInternalConstraints(component5);
                    if (gridBagConstraints.gridy <= serializable.gridy) continue;
                    hashMap2.put(new Integer(n3), component);
                    continue;
                }
                hashMap2.put(new Integer(n3), component);
            }
        }
        GridBagLayoutInfo gridBagLayoutInfo = new GridBagLayoutInfo(n5, n6);
        for (n2 = 0; n2 < n5; ++n2) {
            if (this.columnWidths != null && this.columnWidths.length > n2) {
                gridBagLayoutInfo.colWidths[n2] = this.columnWidths[n2];
            }
            if (this.columnWeights == null || this.columnWeights.length <= n2) continue;
            gridBagLayoutInfo.colWeights[n2] = this.columnWeights[n2];
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (this.rowHeights != null && this.rowHeights.length > n2) {
                gridBagLayoutInfo.rowHeights[n2] = this.rowHeights[n2];
            }
            if (this.rowWeights == null || this.rowWeights.length <= n2) continue;
            gridBagLayoutInfo.rowWeights[n2] = this.rowWeights[n2];
        }
        for (n2 = 0; n2 < componentArray.length; ++n2) {
            Component component;
            serializable2 = componentArray[n2];
            if (!((Component)serializable2).isVisible()) continue;
            gridBagConstraints = this.lookupInternalConstraints((Component)serializable2);
            if (gridBagConstraints.gridwidth == 0 || gridBagConstraints.gridwidth == -1) {
                if (gridBagConstraints.gridwidth == 0) {
                    for (n3 = gridBagConstraints.gridy; n3 < gridBagConstraints.gridy + Math.max(1, gridBagConstraints.gridheight); ++n3) {
                        if (!hashMap.containsKey(new Integer(n3))) continue;
                        component = (Component)hashMap.get(new Integer(n3));
                        serializable = this.lookupInternalConstraints(component);
                        if (serializable.gridwidth == -1) {
                            gridBagConstraints.gridx = n5 - 1;
                            break;
                        }
                        gridBagConstraints.gridx = Math.max(gridBagConstraints.gridx, serializable.gridx + Math.max(1, serializable.gridwidth));
                    }
                    gridBagConstraints.gridwidth = n5 - gridBagConstraints.gridx;
                } else if (gridBagConstraints.gridwidth == -1) {
                    gridBagConstraints.gridwidth = n5 - gridBagConstraints.gridx - 1;
                }
                arrayList.remove(arrayList.indexOf(serializable2));
                this.sortBySpan((Component)serializable2, gridBagConstraints.gridwidth, arrayList, true);
            }
            if (gridBagConstraints.gridheight != 0 && gridBagConstraints.gridheight != -1) continue;
            if (gridBagConstraints.gridheight == 0) {
                for (n3 = gridBagConstraints.gridx; n3 < gridBagConstraints.gridx + Math.max(1, gridBagConstraints.gridwidth); ++n3) {
                    if (!hashMap2.containsKey(new Integer(n3)) || (component = (Component)hashMap.get(new Integer(n3))) == null) continue;
                    serializable = this.lookupInternalConstraints(component);
                    if (serializable.gridheight == -1) {
                        gridBagConstraints.gridy = n6 - 1;
                        break;
                    }
                    gridBagConstraints.gridy = Math.max(gridBagConstraints.gridy, serializable.gridy + Math.max(1, serializable.gridheight));
                }
                gridBagConstraints.gridheight = n6 - gridBagConstraints.gridy;
            } else if (gridBagConstraints.gridheight == -1) {
                gridBagConstraints.gridheight = n6 - gridBagConstraints.gridy - 1;
            }
            arrayList2.remove(arrayList2.indexOf(serializable2));
            this.sortBySpan((Component)serializable2, gridBagConstraints.gridheight, arrayList2, false);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            serializable2 = (Component)arrayList.get(n2);
            if (!((Component)serializable2).isVisible()) continue;
            gridBagConstraints = this.lookupInternalConstraints((Component)serializable2);
            int n7 = n3 = n == 2 ? ((Component)serializable2).getPreferredSize().width : ((Component)serializable2).getMinimumSize().width;
            if (gridBagConstraints.insets != null) {
                n3 += gridBagConstraints.insets.left + gridBagConstraints.insets.right;
            }
            this.distributeSizeAndWeight(n3 += gridBagConstraints.ipadx, gridBagConstraints.weightx, gridBagConstraints.gridx, gridBagConstraints.gridwidth, gridBagLayoutInfo.colWidths, gridBagLayoutInfo.colWeights);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            serializable2 = (Component)arrayList2.get(n2);
            if (!((Component)serializable2).isVisible()) continue;
            gridBagConstraints = this.lookupInternalConstraints((Component)serializable2);
            int n8 = n3 = n == 2 ? ((Component)serializable2).getPreferredSize().height : ((Component)serializable2).getMinimumSize().height;
            if (gridBagConstraints.insets != null) {
                n3 += gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
            }
            this.distributeSizeAndWeight(n3 += gridBagConstraints.ipady, gridBagConstraints.weighty, gridBagConstraints.gridy, gridBagConstraints.gridheight, gridBagLayoutInfo.rowHeights, gridBagLayoutInfo.rowWeights);
        }
        if (dimension.width > 0 && dimension.height > 0) {
            this.calcCellSizes(gridBagLayoutInfo.colWidths, gridBagLayoutInfo.colWeights, dimension.width);
            this.calcCellSizes(gridBagLayoutInfo.rowHeights, gridBagLayoutInfo.rowWeights, dimension.height);
        }
        n2 = this.sumIntArray(gridBagLayoutInfo.colWidths);
        int n9 = this.sumIntArray(gridBagLayoutInfo.rowHeights);
        gridBagLayoutInfo.pos_x = n2 >= dimension.width ? insets.left : insets.left + (dimension.width - n2) / 2;
        gridBagLayoutInfo.pos_y = n9 >= dimension.height ? insets.top : insets.top + (dimension.height - n9) / 2;
        return gridBagLayoutInfo;
    }

    protected Dimension GetMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        if (container == null || gridBagLayoutInfo == null) {
            return new Dimension(0, 0);
        }
        Insets insets = container.getInsets();
        int n = this.sumIntArray(gridBagLayoutInfo.colWidths) + insets.left + insets.right;
        int n2 = this.sumIntArray(gridBagLayoutInfo.rowHeights) + insets.top + insets.bottom;
        return new Dimension(n, n2);
    }

    protected Dimension getMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    private void sortBySpan(Component component, int n, ArrayList<Component> arrayList, boolean bl) {
        if (n == 0 || n == -1) {
            arrayList.add(component);
        } else {
            int n2 = 0;
            if (arrayList.size() > 0) {
                int n3;
                GridBagConstraints gridBagConstraints = this.lookupInternalConstraints(arrayList.get(n2));
                int n4 = n3 = bl ? gridBagConstraints.gridwidth : gridBagConstraints.gridheight;
                while (n3 != 0 && n3 != -1 && n >= n3 && ++n2 < arrayList.size()) {
                    gridBagConstraints = this.lookupInternalConstraints(arrayList.get(n2));
                    n3 = bl ? gridBagConstraints.gridwidth : gridBagConstraints.gridheight;
                }
            }
            arrayList.add(n2, component);
        }
    }

    private void distributeSizeAndWeight(int n, double d, int n2, int n3, int[] nArray, double[] dArray) {
        if (n3 == 1) {
            nArray[n2] = Math.max(nArray[n2], n);
            dArray[n2] = Math.max(dArray[n2], d);
        } else {
            int n4 = n3;
            int n5 = -1;
            for (int i = n2; i < n2 + n3; ++i) {
                if ((double)nArray[i] == 0.0) {
                    --n4;
                    continue;
                }
                n -= nArray[i];
                n5 = i;
            }
            if (n4 == 0) {
                nArray[n2 + n3 - 1] = n;
            } else if (n > 0) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + n;
            }
            this.calcCellWeights(d, dArray, n2, n3);
        }
    }

    private void calcCellWeights(double d, double[] dArray, int n, int n2) {
        double d2 = 0.0;
        for (int i = n; i < n + n2; ++i) {
            d2 += dArray[i];
        }
        if (d > d2) {
            if (d2 == 0.0) {
                int n3 = n + n2 - 1;
                dArray[n3] = dArray[n3] + d;
            } else {
                double d3;
                double d4 = d3 = d - d2;
                int n4 = n;
                while (n4 < n + n2) {
                    double d5 = d3 * dArray[n4] / d2;
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] + d5;
                    d4 -= d5;
                }
                if (d4 > 0.0 && dArray[n + n2 - 1] != 0.0) {
                    int n6 = n + n2 - 1;
                    dArray[n6] = dArray[n6] + d4;
                }
            }
        }
    }

    private void calcCellSizes(int[] nArray, double[] dArray, int n) {
        int n2 = this.sumIntArray(nArray);
        double d = this.sumDoubleArray(dArray);
        int n3 = n - n2;
        if (n3 == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = (int)((double)nArray[i] + (double)n3 * dArray[i] / d);
            if (n4 <= 0) continue;
            nArray[i] = n4;
        }
    }

    private void dumpLayoutInfo(GridBagLayoutInfo gridBagLayoutInfo) {
        System.out.println("GridBagLayoutInfo:");
        System.out.println("cols: " + gridBagLayoutInfo.cols + ", rows: " + gridBagLayoutInfo.rows);
        System.out.print("colWidths: ");
        this.dumpArray(gridBagLayoutInfo.colWidths);
        System.out.print("rowHeights: ");
        this.dumpArray(gridBagLayoutInfo.rowHeights);
        System.out.print("colWeights: ");
        this.dumpArray(gridBagLayoutInfo.colWeights);
        System.out.print("rowWeights: ");
        this.dumpArray(gridBagLayoutInfo.rowWeights);
    }

    private void dumpArray(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print(string);
            System.out.print(nArray[i]);
            string = ", ";
        }
        System.out.println();
    }

    private void dumpArray(double[] dArray) {
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(string);
            System.out.print(dArray[i]);
            string = ", ";
        }
        System.out.println();
    }

    protected void arrangeGrid(Container container) {
        this.ArrangeGrid(container);
    }

    protected GridBagLayoutInfo getLayoutInfo(Container container, int n) {
        return this.GetLayoutInfo(container, n);
    }

    protected void adjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        this.AdjustForGravity(gridBagConstraints, rectangle);
    }
}

