/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.CharacterIterator;

public abstract class FontMetrics
implements Serializable {
    private static final long serialVersionUID = 1681126225205050147L;
    protected Font font;
    private static final FontRenderContext gRC = new FontRenderContext(null, false, false);

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return 0;
    }

    public int getAscent() {
        return 1;
    }

    public int getDescent() {
        return 1;
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent() + this.getLeading();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getMaxDecent();
    }

    public int getMaxDecent() {
        return this.getDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int n) {
        char[] cArray = Character.toChars(n);
        return this.charsWidth(cArray, 0, cArray.length);
    }

    public int charWidth(char c) {
        return 1;
    }

    public int stringWidth(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        return this.charsWidth(cArray, 0, cArray.length);
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 += this.charWidth(cArray[i]);
        }
        return n3;
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = this.charWidth((char)byArray[i]);
        }
        return n3;
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            nArray[c] = this.charWidth(c);
        }
        return nArray;
    }

    public String toString() {
        return this.getClass() + "[font=" + this.font + ",ascent=" + this.getAscent() + ",descent=" + this.getDescent() + ",height=" + this.getHeight() + "]";
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return this.getLineMetrics(string, 0, string.length(), graphics);
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, Graphics graphics) {
        FontRenderContext fontRenderContext = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getFontRenderContext() : gRC;
        return this.font.getLineMetrics(string, n, n2, fontRenderContext);
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, Graphics graphics) {
        FontRenderContext fontRenderContext = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getFontRenderContext() : gRC;
        return this.font.getLineMetrics(cArray, n, n2, fontRenderContext);
    }

    public Rectangle2D getMaxCharBounds(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return this.font.getMaxCharBounds(((Graphics2D)graphics).getFontRenderContext());
        }
        return this.font.getMaxCharBounds(gRC);
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        FontRenderContext fontRenderContext = graphics instanceof Graphics2D ? ((Graphics2D)graphics).getFontRenderContext() : gRC;
        return this.font.getLineMetrics(characterIterator, n, n2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, Graphics graphics) {
        return this.font.getStringBounds(string, this.getFontRenderContext(graphics));
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(string, n, n2, this.getFontRenderContext(graphics));
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(cArray, n, n2, this.getFontRenderContext(graphics));
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, Graphics graphics) {
        return this.font.getStringBounds(characterIterator, n, n2, this.getFontRenderContext(graphics));
    }

    private FontRenderContext getFontRenderContext(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return ((Graphics2D)graphics).getFontRenderContext();
        }
        return gRC;
    }

    public boolean hasUniformLineMetrics() {
        return this.font.hasUniformLineMetrics();
    }
}

