/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    private static final long serialVersionUID = -7262534875583282631L;
    private int align;
    private int hgap;
    private int vgap;

    public void addLayoutComponent(String string, Component component) {
    }

    public int getAlignment() {
        return this.align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int n) {
        this(n, 5, 5);
    }

    public FlowLayout(int n, int n2, int n3) {
        this.setVgap(n3);
        this.setHgap(n2);
        this.setAlignment(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            Component[] componentArray = container.component;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            ComponentOrientation componentOrientation = container.getComponentOrientation();
            boolean bl = componentOrientation.isLeftToRight();
            int n2 = insets.top + this.vgap;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                int n5;
                int n6 = insets.left + this.hgap + insets.right;
                int n7 = 0;
                boolean bl2 = false;
                for (n5 = n3; n5 < n; ++n5) {
                    if (!componentArray[n5].visible) continue;
                    Dimension dimension2 = componentArray[n5].getPreferredSize();
                    n4 = n6 + this.hgap + dimension2.width;
                    if (n4 > dimension.width && bl2) break;
                    n6 = n4;
                    n7 = Math.max(n7, dimension2.height);
                    bl2 = true;
                }
                n4 = this.align;
                if (this.align == 3) {
                    n4 = bl ? 0 : 2;
                } else if (this.align == 4) {
                    int n8 = n4 = bl ? 2 : 0;
                }
                int n9 = n4 == 2 ? insets.left + (dimension.width - n6) + this.hgap : (n4 == 1 ? insets.left + (dimension.width - n6) / 2 + this.hgap : insets.left + this.hgap);
                for (int i = n3; i < n5; ++i) {
                    if (!componentArray[i].visible) continue;
                    Dimension dimension3 = componentArray[i].getPreferredSize();
                    componentArray[i].setBounds(n9, n2 + (n7 - dimension3.height) / 2, dimension3.width, dimension3.height);
                    n9 += dimension3.width + this.hgap;
                }
                n3 = n5;
                n2 += n7 + this.vgap;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, false);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",align=" + this.align + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getSize(Container container, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            Component[] componentArray = container.component;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                if (!componentArray[i].visible) continue;
                Dimension dimension = bl ? componentArray[i].getMinimumSize() : componentArray[i].getPreferredSize();
                n2 += dimension.width;
                n3 = Math.max(dimension.height, n3);
            }
            Insets insets = container.getInsets();
            n2 = n == 0 ? (n2 += 2 * this.hgap + insets.left + insets.right) : (n2 += (n + 1) * this.hgap + insets.left + insets.right);
            return new Dimension(n2, n3 += 2 * this.vgap + insets.top + insets.bottom);
        }
    }
}

