/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.LowPriorityEvent;
import gnu.java.awt.peer.NativeEventLoopRunningEvent;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.PaintEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

public class EventQueue {
    private static final int NORM_PRIORITY = 0;
    private static final int LOW_PRIORITY = 1;
    private Queue[] queues;
    private EventQueue next;
    private EventQueue prev;
    private AWTEvent currentEvent;
    private long lastWhen = System.currentTimeMillis();
    private EventDispatchThread dispatchThread = new EventDispatchThread(this);
    private boolean nativeLoopRunning = false;

    private boolean isShutdown() {
        if (this.nativeLoopRunning) {
            return false;
        }
        if (this.peekEvent() != null) {
            return false;
        }
        return !Frame.hasDisplayableFrames();
    }

    public EventQueue() {
        this.queues = new Queue[2];
        this.queues[0] = new Queue();
        this.queues[1] = new Queue();
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        if (this.next != null) {
            return this.next.getNextEvent();
        }
        AWTEvent aWTEvent = this.getNextEventImpl(true);
        while (aWTEvent == null) {
            if (this.isShutdown()) {
                this.dispatchThread = null;
                throw new InterruptedException();
            }
            this.wait();
            aWTEvent = this.getNextEventImpl(true);
        }
        return aWTEvent;
    }

    private AWTEvent getNextEventImpl(boolean bl) {
        AWTEvent aWTEvent = null;
        for (int i = 0; i < this.queues.length && aWTEvent == null; ++i) {
            Queue queue = this.queues[i];
            if (queue.queueHead == null) continue;
            aWTEvent = queue.queueHead;
            if (!bl) continue;
            queue.queueHead = aWTEvent.queueNext;
            if (queue.queueHead == null) {
                queue.queueTail = null;
            }
            aWTEvent.queueNext = null;
        }
        return aWTEvent;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.next != null) {
            return this.next.peekEvent();
        }
        return this.getNextEventImpl(false);
    }

    public synchronized AWTEvent peekEvent(int n) {
        if (this.next != null) {
            return this.next.peekEvent(n);
        }
        AWTEvent aWTEvent = null;
        for (int i = 0; i < this.queues.length && aWTEvent == null; ++i) {
            Queue queue = this.queues[i];
            aWTEvent = queue.queueHead;
            while (aWTEvent != null && aWTEvent.id != n) {
                aWTEvent = aWTEvent.queueNext;
            }
        }
        return aWTEvent;
    }

    public void postEvent(AWTEvent aWTEvent) {
        this.postEventImpl(aWTEvent);
    }

    private final synchronized void postEventImpl(AWTEvent aWTEvent) {
        int n = 0;
        if (aWTEvent instanceof PaintEvent || aWTEvent instanceof LowPriorityEvent) {
            n = 1;
        }
        if (aWTEvent instanceof NativeEventLoopRunningEvent) {
            this.nativeLoopRunning = ((NativeEventLoopRunningEvent)aWTEvent).isRunning();
            this.notify();
            return;
        }
        this.postEventImpl(aWTEvent, n);
    }

    private final void postEventImpl(AWTEvent aWTEvent, int n) {
        if (aWTEvent == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.postEvent(aWTEvent);
            return;
        }
        Object object = aWTEvent.getSource();
        Queue queue = this.queues[n];
        if (object instanceof Component) {
            Component component = (Component)object;
            ComponentPeer componentPeer = component.peer;
            if (componentPeer != null && aWTEvent instanceof PaintEvent && !(componentPeer instanceof LightweightPeer)) {
                componentPeer.coalescePaintEvent((PaintEvent)aWTEvent);
            }
            AWTEvent aWTEvent2 = null;
            AWTEvent aWTEvent3 = queue.queueHead;
            while (aWTEvent3 != null) {
                Component component2;
                AWTEvent aWTEvent4;
                Object object2 = aWTEvent3.getSource();
                if (aWTEvent3.id == aWTEvent.id && object2 == component && (aWTEvent4 = (component2 = (Component)object2).coalesceEvents(aWTEvent3, aWTEvent)) != null) {
                    if (aWTEvent3 != aWTEvent4) {
                        if (aWTEvent2 != null) {
                            assert (aWTEvent2.queueNext == aWTEvent3);
                            aWTEvent2.queueNext = aWTEvent4;
                        } else {
                            assert (queue.queueHead == aWTEvent3);
                            queue.queueHead = aWTEvent4;
                        }
                        aWTEvent4.queueNext = aWTEvent3.queueNext;
                        if (queue.queueTail == aWTEvent3) {
                            queue.queueTail = aWTEvent4;
                        }
                        aWTEvent3.queueNext = null;
                    }
                    return;
                }
                aWTEvent2 = aWTEvent3;
                aWTEvent3 = aWTEvent3.queueNext;
            }
        }
        if (queue.queueHead == null) {
            queue.queueHead = aWTEvent;
            queue.queueTail = aWTEvent;
        } else {
            queue.queueTail.queueNext = aWTEvent;
            queue.queueTail = aWTEvent;
        }
        if (this.dispatchThread == null || !this.dispatchThread.isAlive()) {
            this.dispatchThread = new EventDispatchThread(this);
            this.dispatchThread.start();
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Can't call invokeAndWait from event dispatch thread");
        }
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Object object = new Object();
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, object, true);
        Object object2 = object;
        synchronized (object2) {
            eventQueue.postEvent(invocationEvent);
            object.wait();
        }
        object2 = invocationEvent.getException();
        if (object2 != null) {
            throw new InvocationTargetException((Throwable)object2);
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, null, false);
        eventQueue.postEvent(invocationEvent);
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eventQueue.next != null) {
            eventQueue = eventQueue.next;
        }
        return Thread.currentThread() == eventQueue.dispatchThread;
    }

    public static AWTEvent getCurrentEvent() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread thread = Thread.currentThread();
        while (thread != eventQueue.dispatchThread) {
            if (eventQueue.next == null) {
                return null;
            }
            eventQueue = eventQueue.next;
        }
        return eventQueue.currentEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void push(EventQueue eventQueue) {
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.push(eventQueue);
            return;
        }
        if (this.dispatchThread == null) {
            this.dispatchThread = new EventDispatchThread(this);
        }
        EventQueue eventQueue2 = eventQueue;
        synchronized (eventQueue2) {
            while (this.peekEvent() != null) {
                try {
                    eventQueue.postEventImpl(this.getNextEvent());
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            eventQueue.prev = this;
        }
        this.next = eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pop() throws EmptyStackException {
        EventQueue eventQueue = this.prev;
        if (eventQueue == null) {
            throw new EmptyStackException();
        }
        EventQueue eventQueue2 = eventQueue;
        synchronized (eventQueue2) {
            EventQueue eventQueue3 = this;
            synchronized (eventQueue3) {
                EventQueue eventQueue4 = this.next;
                if (eventQueue4 != null) {
                    eventQueue4.pop();
                } else {
                    eventQueue.next = null;
                    while (this.peekEvent() != null) {
                        try {
                            eventQueue.postEventImpl(this.getNextEvent());
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    this.prev = null;
                    if (this.dispatchThread != null) {
                        this.dispatchThread.interrupt();
                        this.dispatchThread = null;
                    }
                }
            }
        }
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        this.currentEvent = aWTEvent;
        if (aWTEvent instanceof InputEvent) {
            this.lastWhen = ((InputEvent)aWTEvent).getWhen();
        } else if (aWTEvent instanceof ActionEvent) {
            this.lastWhen = ((ActionEvent)aWTEvent).getWhen();
        } else if (aWTEvent instanceof InvocationEvent) {
            this.lastWhen = ((InvocationEvent)aWTEvent).getWhen();
        }
        if (aWTEvent instanceof ActiveEvent) {
            ActiveEvent activeEvent = (ActiveEvent)((Object)aWTEvent);
            activeEvent.dispatch();
        } else {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)object;
                component.dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                MenuComponent menuComponent = (MenuComponent)object;
                menuComponent.dispatchEvent(aWTEvent);
            }
        }
    }

    public static long getMostRecentEventTime() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (Thread.currentThread() != eventQueue.dispatchThread) {
            return System.currentTimeMillis();
        }
        return eventQueue.lastWhen;
    }

    private class Queue {
        AWTEvent queueHead;
        AWTEvent queueTail;

        private Queue() {
        }
    }
}

