/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;

class EventDispatchThread
extends Thread {
    private static final int DEFAULT_PRIORITY = 6;
    private static int dispatchThreadNum;
    private EventQueue queue;

    EventDispatchThread(EventQueue eventQueue) {
        this.setName("AWT-EventQueue-" + ++dispatchThreadNum);
        this.queue = eventQueue;
        int n = 6;
        try {
            String string = System.getProperty("gnu.awt.dispatchthread.priority");
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setPriority(n);
        this.setDaemon(false);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    AWTEvent aWTEvent = this.queue.getNextEvent();
                    this.queue.dispatchEvent(aWTEvent);
                }
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception during event dispatch:");
                throwable.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

