/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choice
extends Component
implements ItemSelectable,
Serializable,
Accessible {
    private static transient long next_choice_number;
    private static final long serialVersionUID = -4075310674757313071L;
    Vector pItems = new Vector();
    private int selectedIndex = -1;
    private ItemListener item_listeners;

    public Choice() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public synchronized void add(String string) {
        if (string == null) {
            throw new NullPointerException("item must be non-null");
        }
        this.pItems.addElement(string);
        if (this.peer != null) {
            ((ChoicePeer)this.peer).add(string, this.getItemCount() - 1);
        }
        if (this.selectedIndex == -1) {
            this.select(0);
        }
    }

    public synchronized void addItem(String string) {
        this.add(string);
    }

    public synchronized void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index may not be less then 0");
        }
        if (n > this.getItemCount()) {
            n = this.getItemCount();
        }
        this.pItems.insertElementAt(string, n);
        if (this.peer != null) {
            ((ChoicePeer)this.peer).add(string, n);
        }
        if (this.selectedIndex == -1 || this.selectedIndex >= n) {
            this.select(0);
        }
    }

    public synchronized void remove(String string) {
        int n = this.pItems.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("item \"" + string + "\" not found in Choice");
        }
        this.remove(n);
    }

    public synchronized void remove(int n) {
        this.pItems.removeElementAt(n);
        if (this.peer != null) {
            ((ChoicePeer)this.peer).remove(n);
        }
        if (this.getItemCount() == 0) {
            this.selectedIndex = -1;
        } else {
            if (this.selectedIndex > n) {
                --this.selectedIndex;
            } else if (this.selectedIndex == n) {
                this.selectedIndex = 0;
            }
            if (this.peer != null) {
                ((ChoicePeer)this.peer).select(this.selectedIndex);
            }
        }
    }

    public synchronized void removeAll() {
        if (this.getItemCount() <= 0) {
            return;
        }
        this.pItems.removeAllElements();
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.removeAll();
        }
        this.selectedIndex = -1;
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex == -1 ? null : (String)this.pItems.elementAt(this.selectedIndex);
    }

    @Override
    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return null;
        }
        Object[] objectArray = new Object[]{this.pItems.elementAt(this.selectedIndex)};
        return objectArray;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + n);
        }
        if (this.selectedIndex == n) {
            return;
        }
        this.selectedIndex = n;
        if (this.peer != null) {
            ((ChoicePeer)this.peer).select(n);
        }
    }

    public synchronized void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    @Override
    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
        if (aWTEvent.id <= 701 && aWTEvent.id >= 701 && (this.item_listeners != null || (this.eventMask & 0x200L) != 0L)) {
            this.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        int n = this.pItems.indexOf((String)itemEvent.getItem());
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    @Override
    protected String paramString() {
        return "selectedIndex=" + this.selectedIndex + "," + super.paramString();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == ItemListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.item_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "choice" + Choice.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_choice_number++;
    }

    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private static final long serialVersionUID = 7175603582428509322L;

        public AccessibleAWTChoice() {
            super(Choice.this);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public int getAccessibleActionCount() {
            return Choice.this.pItems.size();
        }

        public String getAccessibleActionDescription(int n) {
            return (String)Choice.this.pItems.get(n);
        }

        public boolean doAccessibleAction(int n) {
            if (n < 0 || n >= Choice.this.pItems.size()) {
                return false;
            }
            Choice.this.select(n);
            return true;
        }
    }
}

