/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable,
Accessible {
    private static transient long next_chkmenuitem_number;
    private static final long serialVersionUID = 6190621106981774043L;
    private boolean state;
    private transient ItemListener item_listeners;

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String string) {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) {
        super(string);
        this.state = bl;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean bl) {
        this.state = bl;
        if (this.peer != null) {
            CheckboxMenuItemPeer checkboxMenuItemPeer = (CheckboxMenuItemPeer)this.peer;
            checkboxMenuItemPeer.setState(bl);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        if (!this.state) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getLabel()};
        return objectArray;
    }

    @Override
    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckboxMenuItem(this);
        }
        super.addNotify();
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
        this.enableEvents(512L);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            CheckboxMenuItem checkboxMenuItem = this;
            synchronized (checkboxMenuItem) {
                this.state = ((ItemEvent)aWTEvent).getStateChange() == 1;
            }
        }
        if (aWTEvent.id <= 701 && aWTEvent.id >= 701 && (this.item_listeners != null || (this.eventMask & 0x200L) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    @Override
    public String paramString() {
        return "label=" + this.getLabel() + ",state=" + this.state + "," + super.paramString();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        if (clazz == ItemListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.item_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckboxMenuItem();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "chkmenuitem" + CheckboxMenuItem.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_chkmenuitem_number++;
    }

    protected class AccessibleAWTCheckboxMenuItem
    extends MenuItem.AccessibleAWTMenuItem
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -1122642964303476L;

        protected AccessibleAWTCheckboxMenuItem() {
            super(CheckboxMenuItem.this);
        }
    }
}

