/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.java2d.CubicSegment;
import gnu.java.awt.java2d.LineSegment;
import gnu.java.awt.java2d.QuadSegment;
import gnu.java.awt.java2d.Segment;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class BasicStroke
implements Stroke {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private final float width;
    private final int cap;
    private final int join;
    private final float limit;
    private final float[] dash;
    private final float phase;
    private Segment start;
    private Segment end;

    public BasicStroke(float f, int n, int n2, float f2, float[] fArray, float f3) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("width " + f + " < 0");
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("cap " + n + " out of range [" + 0 + ".." + 2 + "]");
        }
        if (f2 < 1.0f && n2 == 0) {
            throw new IllegalArgumentException("miterlimit " + f2 + " < 1.0f while join == JOIN_MITER");
        }
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("join " + n2 + " out of range [" + 0 + ".." + 2 + "]");
        }
        if (f3 < 0.0f && fArray != null) {
            throw new IllegalArgumentException("dashPhase " + f3 + " < 0.0f while dash != null");
        }
        if (fArray != null) {
            if (fArray.length == 0) {
                throw new IllegalArgumentException("dash.length is 0");
            }
            boolean bl = true;
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == 0.0f) continue;
                bl = false;
                break;
            }
            if (bl) {
                throw new IllegalArgumentException("all dashes are 0.0f");
            }
        }
        this.width = f;
        this.cap = n;
        this.join = n2;
        this.limit = f2;
        this.dash = fArray == null ? null : (float[])fArray.clone();
        this.phase = f3;
    }

    public BasicStroke(float f, int n, int n2, float f2) {
        this(f, n, n2, f2, null, 0.0f);
    }

    public BasicStroke(float f, int n, int n2) {
        this(f, n, n2, 10.0f, null, 0.0f);
    }

    public BasicStroke(float f) {
        this(f, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    public Shape createStrokedShape(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        if (this.dash == null) {
            return this.solidStroke(pathIterator);
        }
        return this.dashedStroke(pathIterator);
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.limit;
    }

    public float[] getDashArray() {
        return this.dash;
    }

    public float getDashPhase() {
        return this.phase;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.width);
        n ^= this.cap;
        n ^= this.join;
        n ^= Float.floatToIntBits(this.limit);
        if (this.dash != null) {
            for (int i = 0; i < this.dash.length; ++i) {
                n ^= Float.floatToIntBits(this.dash[i]);
            }
        }
        return n ^= Float.floatToIntBits(this.phase);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicStroke)) {
            return false;
        }
        BasicStroke basicStroke = (BasicStroke)object;
        return this.width == basicStroke.width && this.cap == basicStroke.cap && this.join == basicStroke.join && this.limit == basicStroke.limit && Arrays.equals(this.dash, basicStroke.dash) && this.phase == basicStroke.phase;
    }

    private Shape solidStroke(PathIterator pathIterator) {
        double[] dArray = new double[6];
        boolean bl = false;
        GeneralPath generalPath = new GeneralPath();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    d3 = d4 = dArray[0];
                    d = d2 = dArray[1];
                    if (!bl) break;
                    this.capEnds();
                    this.convertPath(generalPath, this.start);
                    this.end = null;
                    this.start = null;
                    bl = false;
                    break;
                }
                case 1: {
                    Segment[] segmentArray = new LineSegment(d4, d2, dArray[0], dArray[1]).getDisplacedSegments((double)this.width / 2.0);
                    if (!bl) {
                        this.start = segmentArray[0];
                        this.end = segmentArray[1];
                        bl = true;
                    } else {
                        this.addSegments(segmentArray);
                    }
                    d4 = dArray[0];
                    d2 = dArray[1];
                    break;
                }
                case 2: {
                    Segment[] segmentArray = new QuadSegment(d4, d2, dArray[0], dArray[1], dArray[2], dArray[3]).getDisplacedSegments((double)this.width / 2.0);
                    if (!bl) {
                        this.start = segmentArray[0];
                        this.end = segmentArray[1];
                        bl = true;
                    } else {
                        this.addSegments(segmentArray);
                    }
                    d4 = dArray[2];
                    d2 = dArray[3];
                    break;
                }
                case 3: {
                    Segment[] segmentArray = new CubicSegment(d4, d2, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]).getDisplacedSegments((double)this.width / 2.0);
                    if (!bl) {
                        this.start = segmentArray[0];
                        this.end = segmentArray[1];
                        bl = true;
                    } else {
                        this.addSegments(segmentArray);
                    }
                    d4 = dArray[4];
                    d2 = dArray[5];
                    break;
                }
                case 4: {
                    Segment[] segmentArray;
                    if (d4 == d3 && d2 == d) {
                        this.joinSegments(new Segment[]{this.start.first, this.end.first});
                    } else {
                        segmentArray = new LineSegment(d4, d2, d3, d).getDisplacedSegments((double)this.width / 2.0);
                        this.addSegments(segmentArray);
                    }
                    this.convertPath(generalPath, this.start);
                    this.convertPath(generalPath, this.end);
                    this.end = null;
                    this.start = null;
                    bl = false;
                    generalPath.setWindingRule(0);
                }
            }
            pathIterator.next();
        }
        if (bl) {
            this.capEnds();
            this.convertPath(generalPath, this.start);
        }
        return generalPath;
    }

    private Shape dashedStroke(PathIterator pathIterator) {
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(pathIterator, Math.sqrt(this.width / 3.0f));
        double[] dArray = new double[2];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = this.phase != 0.0f;
        double d5 = 0.0;
        int n = 0;
        GeneralPath generalPath = new GeneralPath();
        while (!flatteningPathIterator.isDone()) {
            switch (flatteningPathIterator.currentSegment(dArray)) {
                case 0: {
                    d3 = d4 = dArray[0];
                    d = d2 = dArray[1];
                    if (!bl) break;
                    this.capEnds();
                    this.convertPath(generalPath, this.start);
                    this.end = null;
                    this.start = null;
                    bl = false;
                    break;
                }
                case 1: {
                    boolean bl4 = false;
                    while (!bl4) {
                        double d6 = Math.sqrt((d4 - dArray[0]) * (d4 - dArray[0]) + (d2 - dArray[1]) * (d2 - dArray[1]));
                        boolean bl5 = true;
                        double[] dArray2 = null;
                        if (bl3 && d5 + d6 <= (double)this.phase || d5 + d6 <= (double)this.dash[n]) {
                            bl5 = false;
                        } else {
                            dArray2 = (double[])dArray.clone();
                            double d7 = bl3 ? (double)this.phase - d5 : (double)this.dash[n] - d5;
                            dArray[0] = d4 + (dArray[0] - d4) * d7 / d6;
                            dArray[1] = d2 + (dArray[1] - d2) * d7 / d6;
                        }
                        if (bl3 || !bl2) {
                            d3 = d4 = dArray[0];
                            d = d2 = dArray[1];
                            if (bl) {
                                this.capEnds();
                                this.convertPath(generalPath, this.start);
                                this.end = null;
                                this.start = null;
                                bl = false;
                            }
                        } else {
                            Segment[] segmentArray = new LineSegment(d4, d2, dArray[0], dArray[1]).getDisplacedSegments((double)this.width / 2.0);
                            if (!bl) {
                                this.start = segmentArray[0];
                                this.end = segmentArray[1];
                                bl = true;
                            } else {
                                this.addSegments(segmentArray);
                            }
                            d4 = dArray[0];
                            d2 = dArray[1];
                        }
                        if (!bl5) {
                            d5 += d6;
                            bl4 = true;
                            continue;
                        }
                        if (bl3) {
                            bl3 = false;
                        }
                        bl2 = !bl2;
                        d5 = 0.0;
                        dArray = dArray2;
                        if (n + 1 == this.dash.length) {
                            n = 0;
                            continue;
                        }
                        ++n;
                    }
                    break;
                }
            }
            flatteningPathIterator.next();
        }
        if (bl) {
            this.capEnds();
            this.convertPath(generalPath, this.start);
        }
        return generalPath;
    }

    private void capEnds() {
        Segment segment = this.end.last;
        this.end.reverseAll();
        this.end = null;
        this.capEnd(this.start, segment);
        this.start.last = segment.last;
        this.end = null;
        this.capEnd(this.start, this.start);
    }

    private void convertPath(GeneralPath generalPath, Segment segment) {
        Segment segment2 = segment;
        generalPath.moveTo((float)segment.P1.getX(), (float)segment.P1.getY());
        do {
            if (segment2 instanceof LineSegment) {
                generalPath.lineTo((float)segment2.P2.getX(), (float)segment2.P2.getY());
                continue;
            }
            if (segment2 instanceof QuadSegment) {
                generalPath.quadTo((float)((QuadSegment)segment2).cp.getX(), (float)((QuadSegment)segment2).cp.getY(), (float)segment2.P2.getX(), (float)segment2.P2.getY());
                continue;
            }
            if (!(segment2 instanceof CubicSegment)) continue;
            generalPath.curveTo((float)((CubicSegment)segment2).cp1.getX(), (float)((CubicSegment)segment2).cp1.getY(), (float)((CubicSegment)segment2).cp2.getX(), (float)((CubicSegment)segment2).cp2.getY(), (float)segment2.P2.getX(), (float)segment2.P2.getY());
        } while ((segment2 = segment2.next) != segment && segment2 != null);
        generalPath.closePath();
    }

    private void addSegments(Segment[] segmentArray) {
        this.joinSegments(segmentArray);
        this.start.add(segmentArray[0]);
        this.end.add(segmentArray[1]);
    }

    private void joinSegments(Segment[] segmentArray) {
        double[] dArray = this.start.last.cp2();
        double[] dArray2 = new double[]{this.start.last.P2.getX(), this.start.last.P2.getY()};
        double[] dArray3 = new double[]{segmentArray[0].first.P1.getX(), segmentArray[0].first.P1.getY()};
        double[] dArray4 = segmentArray[0].cp1();
        Point2D point2D = this.lineIntersection(dArray[0], dArray[1], dArray2[0], dArray2[1], dArray3[0], dArray3[1], dArray4[0], dArray4[1], false);
        double d = (dArray2[0] - dArray[0]) * (dArray4[1] - dArray3[1]) - (dArray4[0] - dArray3[0]) * (dArray2[1] - dArray[1]);
        if (d > 0.0) {
            this.joinInnerSegments(this.start, segmentArray[0], point2D);
            this.joinOuterSegments(this.end, segmentArray[1], point2D);
        } else {
            this.joinInnerSegments(this.end, segmentArray[1], point2D);
            this.joinOuterSegments(this.start, segmentArray[0], point2D);
        }
    }

    private void capEnd(Segment segment, Segment segment2) {
        switch (this.cap) {
            case 0: {
                segment.add(new LineSegment(segment.last.P2, segment2.P1));
                break;
            }
            case 2: {
                double[] dArray = segment.last.cp2();
                double[] dArray2 = new double[]{segment.last.P2.getX(), segment.last.P2.getY()};
                double d = dArray2[0] - dArray[0];
                double d2 = dArray2[1] - dArray[1];
                double d3 = Math.sqrt(d * d + d2 * d2);
                d = 0.5 * (double)this.width * d / d3;
                d2 = 0.5 * (double)this.width * d2 / d3;
                Point2D.Double double_ = new Point2D.Double(dArray2[0] + d, dArray2[1] + d2);
                Point2D.Double double_2 = new Point2D.Double(segment2.P1.getX() + d, segment2.P1.getY() + d2);
                segment.add(new LineSegment(segment.last.P2, double_));
                segment.add(new LineSegment(double_, double_2));
                segment.add(new LineSegment(double_2, segment2.P1));
                break;
            }
            case 1: {
                double[] dArray = segment.last.cp2();
                double[] dArray3 = new double[]{segment.last.P2.getX(), segment.last.P2.getY()};
                double d = dArray3[0] - dArray[0];
                double d4 = dArray3[1] - dArray[1];
                if (d != 0.0 && d4 != 0.0) {
                    double d5 = Math.sqrt(d * d + d4 * d4);
                    d = 0.6666666666666666 * (double)this.width * d / d5;
                    d4 = 0.6666666666666666 * (double)this.width * d4 / d5;
                }
                Point2D.Double double_ = new Point2D.Double(dArray3[0] + d, dArray3[1] + d4);
                Point2D.Double double_3 = new Point2D.Double(segment2.P1.getX() + d, segment2.P1.getY() + d4);
                segment.add(new CubicSegment(segment.last.P2, double_, double_3, segment2.P1));
            }
        }
        segment.add(segment2);
    }

    private Point2D lineIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        double d9 = d;
        double d10 = d2;
        double d11 = d3 - d9;
        double d12 = d4 - d10;
        double d13 = d5;
        double d14 = d6;
        double d15 = d7 - d13;
        double d16 = d8 - d14;
        double d17 = d15 * d12 - d16 * d11;
        double d18 = d15 * (d14 - d10) + d16 * (d9 - d13);
        if (Math.abs(d17) < 1.0E-6) {
            return null;
        }
        d18 /= d17;
        if (!bl && (d18 > 1.0 || d18 < 0.0)) {
            return null;
        }
        return new Point2D.Double(d9 + d18 * d11, d10 + d18 * d12);
    }

    private void joinOuterSegments(Segment segment, Segment segment2, Point2D point2D) {
        switch (this.join) {
            case 0: {
                double[] dArray = segment.last.cp2();
                double[] dArray2 = new double[]{segment.last.P2.getX(), segment.last.P2.getY()};
                double[] dArray3 = new double[]{segment2.P1.getX(), segment2.P1.getY()};
                double[] dArray4 = segment2.cp1();
                Point2D point2D2 = this.lineIntersection(dArray[0], dArray[1], dArray2[0], dArray2[1], dArray3[0], dArray3[1], dArray4[0], dArray4[1], true);
                if (point2D2 == null || point2D == null) {
                    segment.add(new LineSegment(segment.last.P2, segment2.P1));
                    break;
                }
                if (point2D2.distance(point2D) / (double)this.width < (double)this.limit) {
                    segment.add(new LineSegment(segment.last.P2, point2D2));
                    segment.add(new LineSegment(point2D2, segment2.P1));
                    break;
                }
                segment.add(new LineSegment(segment.last.P2, segment2.P1));
                break;
            }
            case 1: {
                double[] dArray = segment.last.cp2();
                double[] dArray5 = new double[]{segment.last.P2.getX(), segment.last.P2.getY()};
                double d = dArray5[0] - dArray[0];
                double d2 = dArray5[1] - dArray[1];
                double d3 = Math.sqrt(d * d + d2 * d2);
                d = 0.5 * (double)this.width * d / d3;
                d2 = 0.5 * (double)this.width * d2 / d3;
                Point2D.Double double_ = new Point2D.Double(dArray5[0] + d, dArray5[1] + d2);
                dArray = new double[]{segment2.P1.getX(), segment2.P1.getY()};
                dArray5 = segment2.cp1();
                d = dArray[0] - dArray5[0];
                d2 = dArray[1] - dArray5[1];
                d3 = Math.sqrt(d * d + d2 * d2);
                d = 0.5 * (double)this.width * d / d3;
                d2 = 0.5 * (double)this.width * d2 / d3;
                Point2D.Double double_2 = new Point2D.Double(dArray[0] + d, dArray[1] + d2);
                segment.add(new CubicSegment(segment.last.P2, double_, double_2, segment2.P1));
                break;
            }
            case 2: {
                segment.add(new LineSegment(segment.last.P2, segment2.P1));
            }
        }
    }

    private void joinInnerSegments(Segment segment, Segment segment2, Point2D point2D) {
        double[] dArray = segment.last.cp2();
        double[] dArray2 = new double[]{segment.last.P2.getX(), segment.last.P2.getY()};
        double[] dArray3 = new double[]{segment2.P1.getX(), segment2.P1.getY()};
        double[] dArray4 = segment2.cp1();
        if (point2D == null) {
            segment.add(new LineSegment(segment.last.P2, segment2.P1));
            point2D = new Point2D.Double((segment2.P1.getX() + segment.last.P2.getX()) / 2.0, (segment2.P1.getY() + segment.last.P2.getY()) / 2.0);
        } else {
            segment.last.P2 = segment2.P1 = point2D;
        }
    }
}

