/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.java2d.AlphaCompositeContext;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AlphaComposite
implements Composite {
    private static final LinkedHashMap cache = new LinkedHashMap(11, 0.75f, true){
        private static final int MAX_CACHE_SIZE = 2048;

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 2048;
        }
    };
    public static final int CLEAR = 1;
    public static final int SRC = 2;
    public static final int DST = 9;
    public static final int SRC_OVER = 3;
    public static final int DST_OVER = 4;
    public static final int SRC_IN = 5;
    public static final int DST_IN = 6;
    public static final int SRC_OUT = 7;
    public static final int DST_OUT = 8;
    public static final int SRC_ATOP = 10;
    public static final int DST_ATOP = 11;
    public static final int XOR = 12;
    public static final AlphaComposite Clear = AlphaComposite.getInstance(1);
    public static final AlphaComposite Src = AlphaComposite.getInstance(2);
    public static final AlphaComposite Dst = AlphaComposite.getInstance(9);
    public static final AlphaComposite SrcOver = AlphaComposite.getInstance(3);
    public static final AlphaComposite DstOver = AlphaComposite.getInstance(4);
    public static final AlphaComposite SrcIn = AlphaComposite.getInstance(5);
    public static final AlphaComposite DstIn = AlphaComposite.getInstance(6);
    public static final AlphaComposite SrcOut = AlphaComposite.getInstance(7);
    public static final AlphaComposite DstOut = AlphaComposite.getInstance(8);
    public static final AlphaComposite SrcAtop = AlphaComposite.getInstance(10);
    public static final AlphaComposite DstAtop = AlphaComposite.getInstance(11);
    public static final AlphaComposite Xor = AlphaComposite.getInstance(12);
    private final int rule;
    private final float alpha;

    private AlphaComposite(int n, float f) {
        this.rule = n;
        this.alpha = f;
    }

    public static AlphaComposite getInstance(int n) {
        return AlphaComposite.getInstance(n, 1.0f);
    }

    public static AlphaComposite getInstance(int n, float f) {
        if (n < 1 || n > 12 || !(f >= 0.0f) || !(f <= 1.0f)) {
            throw new IllegalArgumentException();
        }
        Long l = new Long((long)n + Double.doubleToLongBits(f));
        AlphaComposite alphaComposite = (AlphaComposite)cache.get(l);
        if (alphaComposite == null) {
            alphaComposite = new AlphaComposite(n, f);
            cache.put(l, alphaComposite);
        }
        return alphaComposite;
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return new AlphaCompositeContext(this, colorModel, colorModel2);
    }

    public AlphaComposite derive(int n) {
        if (this.rule == n) {
            return this;
        }
        return AlphaComposite.getInstance(n, this.getAlpha());
    }

    public AlphaComposite derive(float f) {
        if (this.getAlpha() == f) {
            return this;
        }
        return AlphaComposite.getInstance(this.getRule(), f);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getRule() {
        return this.rule;
    }

    public int hashCode() {
        return 31 * Float.floatToIntBits(this.alpha) + this.rule;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlphaComposite)) {
            return false;
        }
        AlphaComposite alphaComposite = (AlphaComposite)object;
        return this.rule == alphaComposite.rule && this.alpha == alphaComposite.alpha;
    }
}

