/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.xpath.XPathParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.TreeMap;

public class XPathTokenizer
implements XPathParser.yyInput {
    static final Map<String, Integer> keywords = new TreeMap<String, Integer>();
    Reader in;
    XPathToken token;
    XPathToken lastToken;

    public XPathTokenizer(String string) {
        this(new StringReader(string));
    }

    XPathTokenizer(Reader reader) {
        this.in = reader.markSupported() ? reader : new BufferedReader(reader);
    }

    public boolean advance() throws IOException {
        this.lastToken = this.token;
        int n = this.in.read();
        switch (n) {
            case -1: {
                return false;
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return this.advance();
            }
            case 34: 
            case 39: {
                this.token = this.consume_literal(n);
                break;
            }
            case 40: {
                this.token = new XPathToken(260);
                break;
            }
            case 41: {
                this.token = new XPathToken(261);
                break;
            }
            case 91: {
                this.token = new XPathToken(262);
                break;
            }
            case 93: {
                this.token = new XPathToken(263);
                break;
            }
            case 44: {
                this.token = new XPathToken(264);
                break;
            }
            case 124: {
                this.token = new XPathToken(265);
                break;
            }
            case 47: {
                this.in.mark(1);
                int n2 = this.in.read();
                if (n2 == 47) {
                    this.token = new XPathToken(267);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(266);
                break;
            }
            case 61: {
                this.token = new XPathToken(268);
                break;
            }
            case 33: {
                this.in.mark(1);
                int n3 = this.in.read();
                if (n3 == 61) {
                    this.token = new XPathToken(269);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(256);
                break;
            }
            case 62: {
                this.in.mark(1);
                int n4 = this.in.read();
                if (n4 == 61) {
                    this.token = new XPathToken(272);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(270);
                break;
            }
            case 60: {
                this.in.mark(1);
                int n5 = this.in.read();
                if (n5 == 61) {
                    this.token = new XPathToken(273);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(271);
                break;
            }
            case 43: {
                this.token = new XPathToken(274);
                break;
            }
            case 45: {
                this.token = new XPathToken(275);
                break;
            }
            case 64: {
                this.token = new XPathToken(276);
                break;
            }
            case 42: {
                this.token = new XPathToken(277);
                break;
            }
            case 36: {
                this.token = new XPathToken(278);
                break;
            }
            case 58: {
                this.in.mark(1);
                int n6 = this.in.read();
                if (n6 == 58) {
                    this.token = new XPathToken(280);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(279);
                break;
            }
            case 46: {
                this.in.mark(1);
                int n7 = this.in.read();
                if (n7 == 46) {
                    this.token = new XPathToken(282);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(281);
                break;
            }
            default: {
                this.token = n >= 48 && n <= 57 ? this.consume_digits(n) : (n == 95 || Character.isLetter((char)n) ? this.consume_name(n) : new XPathToken(256));
            }
        }
        return true;
    }

    public int token() {
        return this.token.type;
    }

    public Object value() {
        return this.token.val;
    }

    XPathToken consume_literal(int n) throws IOException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        int n2;
        while ((n2 = this.in.read()) != -1) {
            if (n2 == n) {
                return new XPathToken(257, cPStringBuilder.toString());
            }
            cPStringBuilder.append((char)n2);
        }
        return new XPathToken(256);
    }

    XPathToken consume_digits(int n) throws IOException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append((char)n);
        while (true) {
            this.in.mark(1);
            n = this.in.read();
            if (n < 48 || n > 57) break;
            cPStringBuilder.append((char)n);
        }
        this.in.reset();
        return new XPathToken(258, cPStringBuilder.toString());
    }

    XPathToken consume_name(int n) throws IOException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append((char)n);
        while (true) {
            this.in.mark(1);
            n = this.in.read();
            if (!this.isNameChar(n)) break;
            cPStringBuilder.append((char)n);
        }
        this.in.reset();
        String string = cPStringBuilder.toString();
        Integer n2 = keywords.get(string);
        if (n2 == null) {
            return new XPathToken(259, string);
        }
        int n3 = n2;
        switch (n3) {
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                this.in.mark(1);
                while ((n = this.in.read()) == 32 || n == 9) {
                }
                if (n == 40) break;
                this.in.reset();
                return new XPathToken(259, string);
            }
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: {
                this.in.mark(1);
                while ((n = this.in.read()) == 32 || n == 9) {
                }
                if (n == 58 && (n = this.in.read()) == 58) {
                    this.in.reset();
                    return new XPathToken(n3);
                }
                this.in.reset();
                return new XPathToken(259, string);
            }
            case 296: 
            case 297: {
                if (this.lastToken == null) {
                    return new XPathToken(259, string);
                }
                switch (this.lastToken.type) {
                    case 260: 
                    case 262: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: {
                        return new XPathToken(259, string);
                    }
                }
            }
        }
        return new XPathToken(n3);
    }

    boolean isNameChar(int n) {
        return n == 95 || n == 45 || n == 46 || n >= 48 && n <= 57 || n >= 768 && n <= 837 || n >= 864 && n <= 865 || n >= 1155 && n <= 1158 || n >= 1425 && n <= 1441 || n >= 1443 && n <= 1465 || n >= 1467 && n <= 1469 || n == 1471 || n >= 1473 && n <= 1474 || n == 1476 || n >= 1611 && n <= 1618 || n == 1648 || n >= 1750 && n <= 1756 || n >= 1757 && n <= 1759 || n >= 1760 && n <= 1764 || n >= 1767 && n <= 1768 || n >= 1770 && n <= 1773 || n >= 2305 && n <= 2307 || n == 2364 || n >= 2366 && n <= 2380 || n == 2381 || n >= 2385 && n <= 2388 || n >= 2402 && n <= 2403 || n >= 2433 && n <= 2435 || n == 2492 || n == 2494 || n == 2495 || n >= 2496 && n <= 2500 || n >= 2503 && n <= 2504 || n >= 2507 && n <= 2509 || n == 2519 || n >= 2530 && n <= 2531 || n == 2562 || n == 2620 || n == 2622 || n == 2623 || n >= 2624 && n <= 2626 || n >= 2631 && n <= 2632 || n >= 2635 && n <= 2637 || n >= 2672 && n <= 2673 || n >= 2689 && n <= 2691 || n == 2748 || n >= 2750 && n <= 2757 || n >= 2759 && n <= 2761 || n >= 2763 && n <= 2765 || n >= 2817 && n <= 2819 || n == 2876 || n >= 2878 && n <= 2883 || n >= 2887 && n <= 2888 || n >= 2891 && n <= 2893 || n >= 2902 && n <= 2903 || n >= 2946 && n <= 2947 || n >= 3006 && n <= 3010 || n >= 3014 && n <= 3016 || n >= 3018 && n <= 3021 || n == 3031 || n >= 3073 && n <= 3075 || n >= 3134 && n <= 3140 || n >= 3142 && n <= 3144 || n >= 3146 && n <= 3149 || n >= 3157 && n <= 3158 || n >= 3202 && n <= 3203 || n >= 3262 && n <= 3268 || n >= 3270 && n <= 3272 || n >= 3274 && n <= 3277 || n >= 3285 && n <= 3286 || n >= 3330 && n <= 3331 || n >= 3390 && n <= 3395 || n >= 3398 && n <= 3400 || n >= 3402 && n <= 3405 || n == 3415 || n == 3633 || n >= 3636 && n <= 3642 || n >= 3655 && n <= 3662 || n == 3761 || n >= 3764 && n <= 3769 || n >= 3771 && n <= 3772 || n >= 3784 && n <= 3789 || n >= 3864 && n <= 3865 || n == 3893 || n == 3895 || n == 3897 || n == 3902 || n == 3903 || n >= 3953 && n <= 3972 || n >= 3974 && n <= 3979 || n >= 3984 && n <= 3989 || n == 3991 || n >= 3993 && n <= 4013 || n >= 4017 && n <= 4023 || n == 4025 || n >= 8400 && n <= 8412 || n == 8417 || n >= 12330 && n <= 12335 || n == 12441 || n == 12442 || n == 183 || n == 720 || n == 721 || n == 903 || n == 1600 || n == 3654 || n == 3782 || n == 12293 || n >= 12337 && n <= 12341 || n >= 12445 && n <= 12446 || n >= 12540 && n <= 12542 || Character.isLetter((char)n);
    }

    static {
        keywords.put("ancestor", new Integer(283));
        keywords.put("ancestor-or-self", new Integer(284));
        keywords.put("attribute", new Integer(285));
        keywords.put("child", new Integer(286));
        keywords.put("descendant", new Integer(287));
        keywords.put("descendant-or-self", new Integer(288));
        keywords.put("following", new Integer(289));
        keywords.put("following-sibling", new Integer(290));
        keywords.put("namespace", new Integer(291));
        keywords.put("parent", new Integer(292));
        keywords.put("preceding", new Integer(293));
        keywords.put("preceding-sibling", new Integer(294));
        keywords.put("self", new Integer(295));
        keywords.put("div", new Integer(296));
        keywords.put("mod", new Integer(297));
        keywords.put("or", new Integer(298));
        keywords.put("and", new Integer(299));
        keywords.put("comment", new Integer(300));
        keywords.put("processing-instruction", new Integer(301));
        keywords.put("text", new Integer(302));
        keywords.put("node", new Integer(303));
    }

    static class XPathToken {
        int type;
        String val;

        XPathToken(int n) {
            this(n, null);
        }

        XPathToken(int n, String string) {
            this.type = n;
            this.val = string;
        }

        public String getText() {
            return this.val;
        }

        public String toString() {
            return this.val;
        }
    }
}

