/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.dom.JAXPFactory;
import gnu.xml.xpath.DocumentOrderComparator;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expr
implements XPathExpression {
    protected static final Comparator<Node> documentOrderComparator = new DocumentOrderComparator();
    protected static final DecimalFormat decimalFormat = new DecimalFormat("####################################################.####################################################", new DecimalFormatSymbols(Locale.US));

    @Override
    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        Object object2 = null;
        Node node2 = null;
        if (object instanceof Node) {
            node2 = (Node)object;
            object2 = this.evaluate(node2, 1, 1);
            if (XPathConstants.STRING == qName && !(object2 instanceof String)) {
                object2 = Expr._string(node2, object2);
            } else if (XPathConstants.NUMBER == qName && !(object2 instanceof Double)) {
                object2 = new Double(Expr._number(node2, object2));
            } else if (XPathConstants.BOOLEAN == qName && !(object2 instanceof Boolean)) {
                object2 = Expr._boolean(node2, object2) ? Boolean.TRUE : Boolean.FALSE;
            } else if (XPathConstants.NODE == qName) {
                if (object2 instanceof Collection) {
                    Collection collection = (Collection)object2;
                    switch (collection.size()) {
                        case 0: {
                            object2 = null;
                            break;
                        }
                        case 1: {
                            object2 = collection.iterator().next();
                            break;
                        }
                        default: {
                            throw new XPathExpressionException("multiple nodes in node-set");
                        }
                    }
                } else if (object2 != null) {
                    throw new XPathExpressionException("return value is not a node-set");
                }
            } else if (XPathConstants.NODESET == qName) {
                if (object2 != null && !(object2 instanceof Collection)) {
                    throw new XPathExpressionException("return value is not a node-set");
                }
                if (object2 != null) {
                    Collection collection = (Collection)object2;
                    object2 = new ExprNodeSet(collection);
                }
            }
        }
        return object2;
    }

    @Override
    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        try {
            JAXPFactory jAXPFactory = new JAXPFactory();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)jAXPFactory).newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return this.evaluate(document, qName);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XPathExpressionException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XPathExpressionException(sAXException);
        }
        catch (IOException iOException) {
            throw new XPathExpressionException(iOException);
        }
    }

    @Override
    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    public abstract Object evaluate(Node var1, int var2, int var3);

    public abstract Expr clone(Object var1);

    public abstract boolean references(QName var1);

    public static Collection<Node> _id(Node node2, Object object) {
        HashSet<Node> hashSet = new HashSet<Node>();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = Expr.stringValue((Node)iterator.next());
                hashSet.addAll(Expr._id(node2, string));
            }
        } else {
            Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
            String string = Expr._string(node2, object);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                Element element = document.getElementById(stringTokenizer.nextToken());
                if (element == null) continue;
                hashSet.add(element);
            }
        }
        return hashSet;
    }

    public static String _local_name(Node node2, Collection<Node> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Node node3 = Expr.firstNode(collection);
        String string = node3.getLocalName();
        return string == null ? "" : string;
    }

    public static String _namespace_uri(Node node2, Collection<Node> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Node node3 = Expr.firstNode(collection);
        String string = node3.getNamespaceURI();
        return string == null ? "" : string;
    }

    public static String _name(Node node2, Collection<Node> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Node node3 = Expr.firstNode(collection);
        String string = null;
        switch (node3.getNodeType()) {
            case 1: 
            case 2: 
            case 7: {
                string = node3.getNodeName();
            }
        }
        return string == null ? "" : string;
    }

    static Node firstNode(Collection<Node> collection) {
        ArrayList<Node> arrayList = new ArrayList<Node>(collection);
        Collections.sort(arrayList, documentOrderComparator);
        return (Node)arrayList.get(0);
    }

    public static String _string(Node node2, Object object) {
        if (object == null) {
            return Expr.stringValue(node2);
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (d == 0.0) {
                return "0";
            }
            if (Double.isInfinite(d)) {
                if (d < 0.0) {
                    return "-Infinity";
                }
                return "Infinity";
            }
            String string = decimalFormat.format(d);
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return "";
            }
            Node node3 = Expr.firstNode(collection);
            return Expr.stringValue(node3);
        }
        throw new IllegalArgumentException(object.toString());
    }

    public static boolean _boolean(Node node2, Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d.isNaN()) {
                return false;
            }
            return d != 0.0;
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() != 0;
        }
        return false;
    }

    public static double _number(Node node2, Object object) {
        Object object2;
        if (object == null) {
            object = Collections.singleton(node2);
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof Collection) {
            object2 = (Collection)object;
            object = Expr.stringValue((Collection<Node>)object2);
        }
        if (object instanceof String) {
            object2 = ((String)object).trim();
            try {
                return Double.parseDouble((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }
        return Double.NaN;
    }

    public static String stringValue(Collection<Node> collection) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        Iterator<Node> iterator = collection.iterator();
        while (iterator.hasNext()) {
            cPStringBuilder.append(Expr.stringValue(iterator.next()));
        }
        return cPStringBuilder.toString();
    }

    public static String stringValue(Node node2) {
        return Expr.stringValue(node2, false);
    }

    static String stringValue(Node node2, boolean bl) {
        switch (node2.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                CPStringBuilder cPStringBuilder = new CPStringBuilder();
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    cPStringBuilder.append(Expr.stringValue(node3, true));
                }
                return cPStringBuilder.toString();
            }
            case 3: 
            case 4: {
                return node2.getNodeValue();
            }
            case 2: 
            case 7: 
            case 8: {
                if (bl) break;
                return node2.getNodeValue();
            }
        }
        return "";
    }

    static int intValue(Object object) {
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.isNaN() ? 0 : d.intValue();
        }
        return (int)Math.ceil(Expr._number(null, object));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExprNodeSet
    implements NodeList {
        private ArrayList<Node> list;

        ExprNodeSet(Collection<Node> collection) {
            this.list = collection instanceof ArrayList ? (ArrayList<Object>)collection : new ArrayList<Node>(collection);
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Node item(int n) {
            try {
                return this.list.get(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
    }
}

