/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GMonthType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GMonthType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gMonth"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            switch (n2) {
                case 0: {
                    if (c == '-') {
                        switch (i) {
                            case 0: {
                                continue block10;
                            }
                            case 1: {
                                n2 = 1;
                                n3 = i + 1;
                                continue block10;
                            }
                        }
                        throw new DatatypeException(i, "illegal GMonth value");
                    }
                }
                default: {
                    throw new DatatypeException(i, "illegal GMonth value");
                }
            }
        }
        switch (n2) {
            case 1: {
                if (n - n3 == 2) break;
                throw new DatatypeException("illegal GMonth value");
            }
            default: {
                throw new DatatypeException("illegal GMonth value");
            }
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            GMonth gMonth = new GMonth();
            gMonth.month = Integer.parseInt(string.substring(2));
            return gMonth;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GMonth
    implements Comparable {
        int month;

        GMonth() {
        }

        public int hashCode() {
            return this.month;
        }

        public boolean equals(Object object) {
            if (object instanceof GMonth) {
                return ((GMonth)object).month == this.month;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof GMonth) {
                GMonth gMonth = (GMonth)object;
                if (gMonth.month == this.month) {
                    return 0;
                }
                return this.month < gMonth.month ? -1 : 1;
            }
            return 0;
        }
    }
}

