/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class DateType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    DateType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "date"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '-' && i == 0) {
                ++n3;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            switch (n2) {
                case 0: {
                    if (c != '-') break;
                    String string2 = string.substring(n3, i);
                    if ("0000".equals(string2) || string2.length() < 4) {
                        throw new DatatypeException(i, "invalid date value");
                    }
                    n2 = 1;
                    n3 = i + 1;
                    continue block7;
                }
                case 1: {
                    if (c != '-') break;
                    if (i - n3 != 2) {
                        throw new DatatypeException(i, "invalid date value");
                    }
                    n2 = 2;
                    n3 = i + 1;
                    continue block7;
                }
            }
            throw new DatatypeException(i, "invalid date value");
        }
        switch (n2) {
            case 2: {
                if (n - n3 == 2) break;
                throw new DatatypeException("invalid date value");
            }
            default: {
                throw new DatatypeException("invalid date value");
            }
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        try {
            int n4;
            block7: for (int i = 0; i < n; ++i) {
                n4 = string.charAt(i);
                if (n4 == 45 && i == 0) {
                    ++n3;
                    continue;
                }
                if (n4 >= 48 && n4 <= 57) continue;
                switch (n2) {
                    case 0: {
                        if (n4 != 45) continue block7;
                        gregorianCalendar.set(1, Integer.parseInt(string.substring(0, i)));
                        n2 = 1;
                        n3 = i + 1;
                        continue block7;
                    }
                    case 1: {
                        if (n4 != 45) continue block7;
                        gregorianCalendar.set(2, Integer.parseInt(string.substring(n3, i)));
                        n2 = 2;
                        n3 = i + 1;
                        continue block7;
                    }
                    case 2: {
                        if (n4 != 84) continue block7;
                        gregorianCalendar.set(5, Integer.parseInt(string.substring(n3, i)));
                        n2 = 7;
                        n3 = i + 1;
                        continue block7;
                    }
                }
            }
            if (n - n3 > 0 && n2 == 7) {
                String string2 = string.substring(n - n3);
                n4 = string2.indexOf(58);
                if (n4 == -1) {
                    TimeZone timeZone;
                    if ("Z".equals(string2)) {
                        string2 = "UTC";
                    }
                    if ((timeZone = TimeZone.getTimeZone(string2)) == null) {
                        return null;
                    }
                    gregorianCalendar.set(15, timeZone.getRawOffset());
                } else {
                    String string3 = string2.substring(0, n4);
                    String string4 = string2.substring(n4 + 1);
                    int n5 = Integer.parseInt(string3) * 360000;
                    n5 = n5 < 0 ? (n5 -= Integer.parseInt(string4) * 60000) : (n5 += Integer.parseInt(string4) * 60000);
                    gregorianCalendar.set(15, n5);
                }
            }
            return gregorianCalendar.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

