/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.NSFilter;
import gnu.xml.pipeline.PipelineFactory;
import gnu.xml.pipeline.TeeConsumer;
import gnu.xml.pipeline.ValidationConsumer;
import gnu.xml.pipeline.WellFormednessFilter;
import gnu.xml.util.Resolver;
import java.io.IOException;
import java.net.MalformedURLException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class DoParse {
    private static SAXParseException fatal;
    private static int errorCount;
    private static int fatalCount;

    private DoParse() {
    }

    public static void main(String[] stringArray) throws IOException {
        int n = 1;
        if (stringArray.length != 2) {
            System.err.println("Usage: DoParse [filename|URL] pipeline-spec");
            System.err.println("Example pipeline specs:");
            System.err.println("  'nsfix | validate'");
            System.err.println("       ... restore namespace syntax, validate");
            System.err.println("  'nsfix | write ( stdout )'");
            System.err.println("       ... restore namespace syntax, write to stdout as XML");
            System.exit(1);
        }
        try {
            stringArray[0] = Resolver.getURL(stringArray[0]);
            InputSource inputSource = new InputSource(stringArray[0]);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            EventConsumer eventConsumer = PipelineFactory.createPipeline(stringArray[1]);
            xMLReader.setErrorHandler(new MyErrorHandler());
            EventFilter.bind(xMLReader, eventConsumer);
            xMLReader.parse(inputSource);
            try {
                if (xMLReader.getFeature("http://org.xml/sax/features/validation")) {
                    n = errorCount + fatalCount > 0 ? 1 : 0;
                } else if (fatalCount == 0) {
                    n = 0;
                }
            }
            catch (SAXException sAXException) {
                if (DoParse.hasValidator(eventConsumer)) {
                    n = errorCount + fatalCount > 0 ? 1 : 0;
                } else if (fatalCount == 0) {
                    n = 0;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("** Malformed URL: " + malformedURLException.getMessage());
            System.err.println("Is '" + stringArray[0] + "' a non-existent file?");
            malformedURLException.printStackTrace();
        }
        catch (SAXParseException sAXParseException) {
            if (sAXParseException != fatal) {
                System.err.print(DoParse.printParseException("Parsing Aborted", sAXParseException));
                sAXParseException.printStackTrace();
                if (sAXParseException.getException() != null) {
                    System.err.println("++ Wrapped exception:");
                    sAXParseException.getException().printStackTrace();
                }
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(n);
    }

    private static boolean hasValidator(EventConsumer eventConsumer) {
        if (eventConsumer == null) {
            return false;
        }
        if (eventConsumer instanceof ValidationConsumer) {
            return true;
        }
        if (eventConsumer instanceof TeeConsumer) {
            TeeConsumer teeConsumer = (TeeConsumer)eventConsumer;
            return DoParse.hasValidator(teeConsumer.getFirst()) || DoParse.hasValidator(teeConsumer.getRest());
        }
        if (eventConsumer instanceof WellFormednessFilter || eventConsumer instanceof NSFilter) {
            return DoParse.hasValidator(((EventFilter)eventConsumer).getNext());
        }
        return false;
    }

    private static String printParseException(String string, SAXParseException sAXParseException) {
        int n;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        cPStringBuilder.append("** ");
        cPStringBuilder.append(string);
        cPStringBuilder.append(": ");
        cPStringBuilder.append(sAXParseException.getMessage());
        cPStringBuilder.append('\n');
        if (sAXParseException.getSystemId() != null) {
            cPStringBuilder.append("   URI:  ");
            cPStringBuilder.append(sAXParseException.getSystemId());
            cPStringBuilder.append('\n');
        }
        if ((n = sAXParseException.getLineNumber()) != -1) {
            cPStringBuilder.append("   line: ");
            cPStringBuilder.append(n);
            cPStringBuilder.append('\n');
        }
        if ((n = sAXParseException.getColumnNumber()) != -1) {
            cPStringBuilder.append("   char: ");
            cPStringBuilder.append(n);
            cPStringBuilder.append('\n');
        }
        return cPStringBuilder.toString();
    }

    static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            errorCount++;
            System.err.print(DoParse.printParseException("Error", sAXParseException));
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            fatalCount++;
            if (fatal == null) {
                fatal = sAXParseException;
            }
            System.err.print(DoParse.printParseException("Nonrecoverable Error", sAXParseException));
        }
    }
}

