/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.ReaderInputStream;
import gnu.xml.dom.ls.SAXEventSink;
import gnu.xml.transform.ErrorListenerErrorHandler;
import gnu.xml.transform.URIResolverEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XSLURIResolver
implements URIResolver {
    final Map<String, Long> lastModifiedCache = new HashMap<String, Long>();
    final Map<String, Node> nodeCache = new HashMap<String, Node>();
    DocumentBuilder builder;
    URIResolver userResolver;
    ErrorListener userListener;

    XSLURIResolver() {
    }

    void setUserResolver(URIResolver uRIResolver) {
        this.userResolver = uRIResolver;
    }

    void setUserListener(ErrorListener errorListener) {
        this.userListener = errorListener;
    }

    void flush() {
        this.lastModifiedCache.clear();
        this.nodeCache.clear();
    }

    public Source resolve(String string, String string2) throws TransformerException {
        Source source = null;
        if (this.userResolver != null) {
            source = this.userResolver.resolve(string2, string);
        }
        return this.resolveDOM(source, string, string2);
    }

    DOMSource resolveDOM(Source source, String string, String string2) throws TransformerException {
        if (source != null && source instanceof DOMSource) {
            return (DOMSource)source;
        }
        String string3 = source == null ? null : source.getSystemId();
        long l = 0L;
        long l2 = 0L;
        try {
            Object object;
            Object object2;
            Object object3;
            Node node2 = null;
            InputStream inputStream = null;
            if (source != null && source instanceof StreamSource) {
                object3 = (StreamSource)source;
                inputStream = ((StreamSource)object3).getInputStream();
                if (inputStream == null && (object2 = ((StreamSource)object3).getReader()) != null) {
                    inputStream = new ReaderInputStream((Reader)object2);
                }
            } else if (source != null && source instanceof SAXSource && (object2 = ((SAXSource)(object3 = (SAXSource)source)).getInputSource()) != null) {
                if (string3 == null) {
                    string3 = ((InputSource)object2).getSystemId();
                }
                if ((object = ((SAXSource)object3).getXMLReader()) != null) {
                    return this.parse((InputSource)object2, (XMLReader)object);
                }
            }
            if (inputStream == null) {
                object3 = this.resolveURL(string3, string, string2);
                if (object3 != null) {
                    string3 = ((URL)object3).toString();
                    node2 = this.nodeCache.get(string3);
                    object2 = ((URL)object3).openConnection();
                    object = this.lastModifiedCache.get(string3);
                    if (object != null) {
                        l2 = (Long)object;
                        ((URLConnection)object2).setIfModifiedSince(l2);
                    }
                    ((URLConnection)object2).connect();
                    l = ((URLConnection)object2).getLastModified();
                    if (node2 != null && l > 0L && l <= l2) {
                        return new DOMSource(node2, string3);
                    }
                    inputStream = ((URLConnection)object2).getInputStream();
                    this.nodeCache.put(string3, node2);
                    this.lastModifiedCache.put(string3, new Long(l));
                } else {
                    throw new TransformerException("can't resolve URL: " + string3);
                }
            }
            object3 = new InputSource(inputStream);
            ((InputSource)object3).setSystemId(string3);
            object2 = this.getDocumentBuilder();
            node2 = ((DocumentBuilder)object2).parse((InputSource)object3);
            return new DOMSource(node2, string3);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    URL resolveURL(String string, String string2, String string3) throws IOException {
        URL uRL = null;
        try {
            if (string != null) {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) {
                if (string2 != null) {
                    URL uRL2 = new URL(string2);
                    uRL = new URL(uRL2, string3);
                } else if (string3 != null) {
                    uRL = new URL(string3);
                } else {
                    throw new MalformedURLException(string);
                }
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            File file = null;
            if (string3 == null) {
                string3 = string;
            }
            if (string2 != null) {
                int n = string2.lastIndexOf(File.separatorChar);
                if (n != -1 && n < string2.length() - 1) {
                    string2 = string2.substring(0, n);
                }
                File file2 = new File(string2);
                file = new File(file2, string3);
            } else if (string3 != null) {
                file = new File(string3);
            }
            return file == null ? null : file.toURL();
        }
    }

    DocumentBuilder getDocumentBuilder() throws TransformerException {
        try {
            if (this.builder == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setExpandEntityReferences(true);
                this.builder = documentBuilderFactory.newDocumentBuilder();
            }
            if (this.userResolver != null) {
                this.builder.setEntityResolver(new URIResolverEntityResolver(this.userResolver));
            }
            if (this.userListener != null) {
                this.builder.setErrorHandler(new ErrorListenerErrorHandler(this.userListener));
            }
            return this.builder;
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    DOMSource parse(InputSource inputSource, XMLReader xMLReader) throws SAXException, IOException {
        SAXEventSink sAXEventSink = new SAXEventSink();
        sAXEventSink.setReader(xMLReader);
        sAXEventSink.setNamespaceAware(true);
        xMLReader.setContentHandler(sAXEventSink);
        xMLReader.setDTDHandler(sAXEventSink);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXEventSink);
        xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXEventSink);
        xMLReader.parse(inputSource);
        Document document = sAXEventSink.getDocument();
        String string = inputSource.getSystemId();
        if (string != null && document instanceof DomDocument) {
            ((DomDocument)document).setDocumentURI(string);
        }
        return new DOMSource(document, string);
    }
}

