/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.SortKey;
import gnu.xml.xpath.Expr;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XSLComparator
implements Comparator<Node> {
    final List<SortKey> sortKeys;

    XSLComparator(List<SortKey> list2) {
        this.sortKeys = list2;
    }

    @Override
    public int compare(Node node2, Node node3) {
        for (SortKey sortKey : this.sortKeys) {
            String string = sortKey.key(node2);
            String string2 = sortKey.key(node3);
            if ("text".equals(sortKey.dataType)) {
                Locale locale = sortKey.lang == null ? Locale.getDefault() : new Locale(sortKey.lang);
                Collator collator = Collator.getInstance(locale);
                int n = collator.compare(string, string2);
                if (n == 0) continue;
                switch (sortKey.caseOrder) {
                    case 1: {
                        break;
                    }
                }
                if (sortKey.descending) {
                    n = -n;
                }
                return n;
            }
            if (!"number".equals(sortKey.dataType)) continue;
            double d = Expr._number(node2, string);
            double d2 = Expr._number(node3, string2);
            int n = Double.isNaN(d) || Double.isInfinite(d2) ? -1 : (Double.isNaN(d2) || Double.isInfinite(d) ? 1 : (d > d2 ? 1 : (d < d2 ? -1 : 0)));
            return sortKey.descending ? -n : n;
        }
        return 0;
    }
}

