/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.ParameterNode;
import gnu.xml.transform.Stylesheet;
import gnu.xml.xpath.DocumentOrderComparator;
import java.io.PrintStream;
import java.util.Comparator;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

abstract class TemplateNode {
    static final Comparator<Node> documentOrderComparator = new DocumentOrderComparator();
    TemplateNode children;
    TemplateNode next;

    TemplateNode() {
    }

    final void apply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        if (stylesheet.terminated) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (stylesheet.debug) {
            System.err.println("Applying " + this.toString());
            System.err.println("\twith context=" + node2 + ", pos=" + n + ", len=" + n2);
        }
        this.doApply(stylesheet, qName, node2, n, n2, node3, node4);
    }

    abstract void doApply(Stylesheet var1, QName var2, Node var3, int var4, int var5, Node var6, Node var7) throws TransformerException;

    abstract TemplateNode clone(Stylesheet var1);

    public boolean references(QName qName) {
        if (this.children != null && this.children.references(qName)) {
            return true;
        }
        return this.next != null && this.next.references(qName);
    }

    void list(int n, PrintStream printStream, boolean bl) {
        for (int i = 0; i < n; ++i) {
            printStream.print("  ");
        }
        printStream.println(this.toString());
        if (this.children != null) {
            this.children.list(n + 1, printStream, true);
        }
        if (bl && this.next != null) {
            this.next.list(n, printStream, bl);
        }
    }

    boolean hasParam(QName qName) {
        TemplateNode templateNode = this;
        while (templateNode != null) {
            if (templateNode instanceof ParameterNode) {
                ParameterNode parameterNode = (ParameterNode)templateNode;
                if (parameterNode.type == 1 && parameterNode.name.equals(qName)) {
                    return true;
                }
            }
            templateNode = templateNode.next;
        }
        return false;
    }
}

