/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StreamSerializer {
    static final int SPACE = 32;
    static final int BANG = 33;
    static final int APOS = 39;
    static final int SLASH = 47;
    static final int BRA = 60;
    static final int KET = 62;
    static final int EQ = 61;
    static final Map HTML_BOOLEAN_ATTRIBUTES = new HashMap();
    static final HashSet HTML_URIS;
    protected final String encoding;
    final Charset charset;
    final CharsetEncoder encoder;
    final int mode;
    final LinkedList namespaces;
    protected String eol;
    Collection cdataSectionElements = Collections.EMPTY_SET;
    protected boolean discardDefaultContent;
    protected boolean xmlDeclaration = true;
    private boolean htmlEncoded;

    public StreamSerializer() {
        this(0, null, null);
    }

    public StreamSerializer(String string) {
        this(0, string, null);
    }

    public StreamSerializer(int n, String string, String string2) {
        this.mode = n;
        if (string == null) {
            string = n == 1 ? "ISO-8859-1" : "UTF-8";
        }
        this.encoding = string.intern();
        this.charset = Charset.forName(this.encoding);
        this.encoder = this.charset.newEncoder();
        this.eol = string2 != null ? string2 : System.getProperty("line.separator");
        this.namespaces = new LinkedList();
    }

    void setCdataSectionElements(Collection collection) {
        this.cdataSectionElements = collection;
    }

    public void serialize(Node node2, OutputStream outputStream) throws IOException {
        this.serialize(node2, outputStream, false);
    }

    void serialize(Node node2, OutputStream outputStream, boolean bl) throws IOException {
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            this.doSerialize(node2, outputStream, bl);
            node2 = node3;
        }
    }

    private void doSerialize(Node node2, OutputStream outputStream, boolean bl) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("no output stream");
        }
        this.htmlEncoded = false;
        String string = node2.getNamespaceURI();
        int n = node2.getNodeType();
        if (bl && n == 3) {
            n = 4;
        }
        switch (n) {
            case 2: {
                String string2;
                String string3;
                String string4 = node2.getPrefix();
                if ("http://www.w3.org/2000/xmlns/".equals(string) || "xmlns".equals(string4) || string4 != null && string4.startsWith("xmlns:")) {
                    int n2;
                    string3 = node2.getNodeValue();
                    if (this.isDefined(string3, string4)) break;
                    string2 = node2.getLocalName();
                    if (string2 == null && (n2 = (string2 = node2.getNodeName()).indexOf(58)) != -1) {
                        string2 = string2.substring(n2 + 1);
                    }
                    this.define(string3, string2);
                } else if (string != null && !this.isDefined(string, string4)) {
                    string3 = (string4 = this.define(string, string4)) == null ? "xmlns" : "xmlns:" + string4;
                    outputStream.write(32);
                    outputStream.write(this.encodeText(string3));
                    outputStream.write(61);
                    string2 = "\"" + this.encode(string, true, true) + "\"";
                    outputStream.write(string2.getBytes(this.encoding));
                }
                outputStream.write(32);
                string3 = node2.getNodeName();
                outputStream.write(this.encodeText(string3));
                string2 = node2.getNodeValue();
                if (this.mode == 1 && string3.equals(string2) && this.isHTMLBoolean((Attr)node2, string3)) break;
                outputStream.write(61);
                String string5 = "\"" + this.encode(string2, true, true) + "\"";
                outputStream.write(this.encodeText(string5));
                break;
            }
            case 1: {
                Object object;
                this.pushNamespaceContext();
                String string6 = node2.getNodeName();
                outputStream.write(60);
                outputStream.write(this.encodeText(string6));
                String string7 = node2.getPrefix();
                if (string != null && !this.isDefined(string, string7)) {
                    object = (string7 = this.define(string, string7)) == null ? "xmlns" : "xmlns:" + string7;
                    outputStream.write(32);
                    outputStream.write(this.encodeText((String)object));
                    outputStream.write(61);
                    String string8 = "\"" + this.encode(string, true, true) + "\"";
                    outputStream.write(this.encodeText(string8));
                }
                if ((object = node2.getAttributes()) != null) {
                    int n3 = object.getLength();
                    for (int i = 0; i < n3; ++i) {
                        Attr attr = (Attr)object.item(i);
                        if (this.discardDefaultContent && !attr.getSpecified()) continue;
                        this.serialize(attr, outputStream, false);
                    }
                }
                bl = this.cdataSectionElements.contains(string6);
                Node node3 = node2.getFirstChild();
                if (node3 == null) {
                    outputStream.write(47);
                    outputStream.write(62);
                } else {
                    outputStream.write(62);
                    this.serialize(node3, outputStream, bl);
                    outputStream.write(60);
                    outputStream.write(47);
                    outputStream.write(this.encodeText(string6));
                    outputStream.write(62);
                }
                this.popNamespaceContext();
                break;
            }
            case 3: {
                String string9 = node2.getNodeValue();
                if (!"yes".equals(node2.getUserData("disable-output-escaping")) && this.mode != 2) {
                    string9 = this.encode(string9, false, false);
                }
                outputStream.write(this.encodeText(string9));
                break;
            }
            case 4: {
                String string10 = node2.getNodeValue();
                int n4 = string10.indexOf("]]>");
                while (n4 != -1) {
                    String string11 = string10.substring(0, n4 + 2);
                    outputStream.write(this.encodeText("<![CDATA[" + string11 + "]]>"));
                    string10 = string10.substring(n4 + 2);
                    n4 = string10.indexOf("]]>");
                }
                outputStream.write(this.encodeText("<![CDATA[" + string10 + "]]>"));
                break;
            }
            case 8: {
                String string12 = "<!--" + node2.getNodeValue() + "-->";
                outputStream.write(this.encodeText(string12));
                Node node4 = node2.getParentNode();
                if (node4 == null || node4.getNodeType() != 9) break;
                outputStream.write(this.encodeText(this.eol));
                break;
            }
            case 9: 
            case 11: {
                Node node5;
                if (this.mode == 0) {
                    if ("UTF-16".equalsIgnoreCase(this.encoding)) {
                        outputStream.write(254);
                        outputStream.write(255);
                    }
                    if (!"yes".equals(node2.getUserData("omit-xml-declaration")) && this.xmlDeclaration) {
                        String string13;
                        Document document = node2 instanceof Document ? (Document)node2 : null;
                        String string14 = string13 = document != null ? document.getXmlVersion() : null;
                        if (string13 == null) {
                            string13 = (String)node2.getUserData("version");
                        }
                        if (string13 == null) {
                            string13 = "1.0";
                        }
                        outputStream.write(60);
                        outputStream.write(63);
                        outputStream.write("xml version=\"".getBytes("US-ASCII"));
                        outputStream.write(string13.getBytes("US-ASCII"));
                        outputStream.write(34);
                        if (!"UTF-8".equalsIgnoreCase(this.encoding)) {
                            outputStream.write(" encoding=\"".getBytes("US-ASCII"));
                            outputStream.write(this.encoding.getBytes("US-ASCII"));
                            outputStream.write(34);
                        }
                        if (document != null && document.getXmlStandalone() || "yes".equals(node2.getUserData("standalone"))) {
                            outputStream.write(" standalone=\"yes\"".getBytes("US-ASCII"));
                        }
                        outputStream.write(63);
                        outputStream.write(62);
                        outputStream.write(this.encodeText(this.eol));
                    }
                } else if (this.mode == 1) {
                    Node node6;
                    String string15 = (String)node2.getUserData("media-type");
                    if (string15 == null) {
                        string15 = "text/html";
                    }
                    String string16 = string15 + "; charset=" + (this.encoding.indexOf(32) != -1 ? "\"" + this.encoding + "\"" : this.encoding);
                    Document document = node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
                    Node node7 = null;
                    for (node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                        if (node6.getNodeType() != 1 || !this.isHTMLElement(node6, "html")) continue;
                        node7 = node6;
                        break;
                    }
                    if (node7 != null) {
                        Node node8;
                        node6 = null;
                        for (node8 = node7.getFirstChild(); node8 != null; node8 = node8.getNextSibling()) {
                            if (!this.isHTMLElement(node8, "head")) continue;
                            node6 = node8;
                            break;
                        }
                        if (node6 != null) {
                            Object object;
                            Node node9;
                            node8 = null;
                            Node node10 = null;
                            for (node9 = node6.getFirstChild(); node9 != null; node9 = node9.getNextSibling()) {
                                if (!this.isHTMLElement(node9, "meta")) continue;
                                object = node9.getAttributes();
                                int n5 = object.getLength();
                                String string17 = null;
                                Node node11 = null;
                                for (int i = 0; i < n5; ++i) {
                                    Node node12 = object.item(i);
                                    String string18 = node12.getNodeName();
                                    if ("http-equiv".equalsIgnoreCase(string18)) {
                                        string17 = node12.getNodeValue();
                                        continue;
                                    }
                                    if (!"content".equalsIgnoreCase(string18)) continue;
                                    node11 = node12;
                                }
                                if (!"Content-Type".equalsIgnoreCase(string17)) continue;
                                node8 = node9;
                                node10 = node11;
                                break;
                            }
                            if (node8 == null) {
                                node8 = document.createElement("meta");
                                node9 = node6.getFirstChild();
                                if (node9 == null) {
                                    node6.appendChild(node8);
                                } else {
                                    node6.insertBefore(node8, node9);
                                }
                                object = document.createAttribute("http-equiv");
                                node8.getAttributes().setNamedItem((Node)object);
                                object.setNodeValue("Content-Type");
                            }
                            if (node10 == null) {
                                node10 = document.createAttribute("content");
                                node8.getAttributes().setNamedItem(node10);
                            }
                            node10.setNodeValue(string16);
                            this.htmlEncoded = true;
                        }
                    }
                }
                if ((node5 = node2.getFirstChild()) == null) break;
                this.serialize(node5, outputStream, bl);
                break;
            }
            case 10: {
                String string19;
                String string20;
                DocumentType documentType = (DocumentType)node2;
                outputStream.write(60);
                outputStream.write(33);
                outputStream.write(this.encodeText("DOCTYPE "));
                String string21 = documentType.getNodeName();
                outputStream.write(this.encodeText(string21));
                String string22 = documentType.getPublicId();
                if (string22 != null) {
                    outputStream.write(this.encodeText(" PUBLIC "));
                    outputStream.write(39);
                    outputStream.write(this.encodeText(string22));
                    outputStream.write(39);
                }
                if ((string20 = documentType.getSystemId()) != null) {
                    outputStream.write(this.encodeText(" SYSTEM "));
                    outputStream.write(39);
                    outputStream.write(this.encodeText(string20));
                    outputStream.write(39);
                }
                if ((string19 = documentType.getInternalSubset()) != null) {
                    outputStream.write(this.encodeText(string19));
                }
                outputStream.write(62);
                outputStream.write(this.eol.getBytes(this.encoding));
                break;
            }
            case 5: {
                String string23 = "&" + node2.getNodeValue() + ";";
                outputStream.write(this.encodeText(string23));
                break;
            }
            case 7: {
                String string24 = "<?" + node2.getNodeName() + " " + node2.getNodeValue() + "?>";
                outputStream.write(this.encodeText(string24));
                Node node13 = node2.getParentNode();
                if (node13 == null || node13.getNodeType() != 9) break;
                outputStream.write(this.encodeText(this.eol));
                break;
            }
            default: {
                System.err.println("Unhandled node type: " + n);
            }
        }
    }

    boolean isHTMLElement(Node node2, String string) {
        if (node2.getNodeType() != 1) {
            return false;
        }
        String string2 = node2.getLocalName();
        if (string2 == null) {
            string2 = node2.getNodeName();
        }
        if (!string.equalsIgnoreCase(string2)) {
            return false;
        }
        String string3 = node2.getNamespaceURI();
        return string3 == null || HTML_URIS.contains(string3);
    }

    boolean isDefined(String string, String string2) {
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml".equals(string2);
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns".equals(string2);
        }
        if (string2 == null) {
            string2 = "";
        }
        for (Map map : this.namespaces) {
            String string3 = (String)map.get(string);
            if (string3 == null || !string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    void pushNamespaceContext() {
        this.namespaces.addFirst(new HashMap());
    }

    String define(String string, String string2) {
        if (this.namespaces.isEmpty()) {
            return string2;
        }
        HashMap hashMap = (HashMap)this.namespaces.getFirst();
        while (hashMap.containsValue(string2)) {
            string2 = string2 + "_";
        }
        hashMap.put(string, string2);
        return string2;
    }

    void popNamespaceContext() {
        this.namespaces.removeFirst();
    }

    final byte[] encodeText(String string) throws IOException {
        int n;
        Object object;
        boolean bl;
        this.encoder.reset();
        boolean bl2 = bl = this.mode == 1 && !this.htmlEncoded;
        if (!this.encoder.canEncode(string) || bl) {
            object = new CPStringBuilder();
            n = string.length();
            for (int i = 0; i < n; ++i) {
                String string2;
                char c = string.charAt(i);
                if (!this.encoder.canEncode(c)) {
                    string2 = Integer.toHexString(c);
                    ((CPStringBuilder)object).append("&#x");
                    ((CPStringBuilder)object).append(string2);
                    ((CPStringBuilder)object).append(';');
                    continue;
                }
                if (bl) {
                    string2 = StreamSerializer.getHTMLCharacterEntity(c);
                    if (string2 != null) {
                        ((CPStringBuilder)object).append('&');
                        ((CPStringBuilder)object).append(string2);
                        ((CPStringBuilder)object).append(';');
                        continue;
                    }
                    ((CPStringBuilder)object).append(c);
                    continue;
                }
                ((CPStringBuilder)object).append(c);
            }
            string = ((CPStringBuilder)object).toString();
        }
        object = this.encoder.encode(CharBuffer.wrap(string));
        n = ((Buffer)object).limit() - ((Buffer)object).position();
        if (((ByteBuffer)object).hasArray()) {
            byte[] byArray = ((ByteBuffer)object).array();
            if (byArray.length > n) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                byArray = byArray2;
            }
            return byArray;
        }
        ((Buffer)object).flip();
        byte[] byArray = new byte[n];
        ((ByteBuffer)object).get(byArray, 0, n);
        return byArray;
    }

    String encode(String string, boolean bl, boolean bl2) {
        int n = string.length();
        CPStringBuilder cPStringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&gt;");
                continue;
            }
            if (c == '&') {
                if (this.mode == 1 && i + 1 < n && string.charAt(i + 1) == '{') {
                    if (cPStringBuilder == null) continue;
                    cPStringBuilder.append(c);
                    continue;
                }
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&amp;");
                continue;
            }
            if (c == '\'' && bl2) {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                if (this.mode == 1) {
                    cPStringBuilder.append("&#x27;");
                    continue;
                }
                cPStringBuilder.append("&apos;");
                continue;
            }
            if (c == '\"' && bl2) {
                if (cPStringBuilder == null) {
                    cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                }
                cPStringBuilder.append("&quot;");
                continue;
            }
            if (bl) {
                if (c < ' ') {
                    if (cPStringBuilder == null) {
                        cPStringBuilder = new CPStringBuilder(string.substring(0, i));
                    }
                    cPStringBuilder.append('&');
                    cPStringBuilder.append('#');
                    cPStringBuilder.append((int)c);
                    cPStringBuilder.append(';');
                    continue;
                }
                if (cPStringBuilder == null) continue;
                cPStringBuilder.append(c);
                continue;
            }
            if (cPStringBuilder == null) continue;
            cPStringBuilder.append(c);
        }
        return cPStringBuilder == null ? string : cPStringBuilder.toString();
    }

    String toString(Node node2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.serialize(node2, byteArrayOutputStream);
            return new String(byteArrayOutputStream.toByteArray(), this.encoding);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    boolean isHTMLBoolean(Attr attr, String string) {
        Collection collection;
        string = string.toLowerCase();
        Element element = attr.getOwnerElement();
        String string2 = element.getLocalName();
        if (string2 == null) {
            string2 = element.getNodeName();
        }
        return (collection = (Collection)HTML_BOOLEAN_ATTRIBUTES.get(string2 = string2.toLowerCase())) != null && collection.contains(string);
    }

    static String getHTMLCharacterEntity(char c) {
        switch (c) {
            case '\u00a0': {
                return "nbsp";
            }
            case '\u00a1': {
                return "iexcl";
            }
            case '\u00a2': {
                return "cent";
            }
            case '\u00a3': {
                return "pound";
            }
            case '\u00a4': {
                return "curren";
            }
            case '\u00a5': {
                return "yen";
            }
            case '\u00a6': {
                return "brvbar";
            }
            case '\u00a7': {
                return "sect";
            }
            case '\u00a8': {
                return "uml";
            }
            case '\u00a9': {
                return "copy";
            }
            case '\u00aa': {
                return "ordf";
            }
            case '\u00ab': {
                return "laquo";
            }
            case '\u00ac': {
                return "not";
            }
            case '\u00ad': {
                return "shy";
            }
            case '\u00ae': {
                return "reg";
            }
            case '\u00af': {
                return "macr";
            }
            case '\u00b0': {
                return "deg";
            }
            case '\u00b1': {
                return "plusmn";
            }
            case '\u00b2': {
                return "sup2";
            }
            case '\u00b3': {
                return "sup3";
            }
            case '\u00b4': {
                return "acute";
            }
            case '\u00b5': {
                return "micro";
            }
            case '\u00b6': {
                return "para";
            }
            case '\u00b7': {
                return "middot";
            }
            case '\u00b8': {
                return "cedil";
            }
            case '\u00b9': {
                return "sup1";
            }
            case '\u00ba': {
                return "ordm";
            }
            case '\u00bb': {
                return "raquo";
            }
            case '\u00bc': {
                return "frac14";
            }
            case '\u00bd': {
                return "frac12";
            }
            case '\u00be': {
                return "frac34";
            }
            case '\u00bf': {
                return "iquest";
            }
            case '\u00c0': {
                return "Agrave";
            }
            case '\u00c1': {
                return "Aacute";
            }
            case '\u00c2': {
                return "Acirc";
            }
            case '\u00c3': {
                return "Atilde";
            }
            case '\u00c4': {
                return "Auml";
            }
            case '\u00c5': {
                return "Aring";
            }
            case '\u00c6': {
                return "AElig";
            }
            case '\u00c7': {
                return "Ccedil";
            }
            case '\u00c8': {
                return "Egrave";
            }
            case '\u00c9': {
                return "Eacute";
            }
            case '\u00ca': {
                return "Ecirc";
            }
            case '\u00cb': {
                return "Euml";
            }
            case '\u00cc': {
                return "Igrave";
            }
            case '\u00cd': {
                return "Iacute";
            }
            case '\u00ce': {
                return "Icirc";
            }
            case '\u00cf': {
                return "Iuml";
            }
            case '\u00d0': {
                return "ETH";
            }
            case '\u00d1': {
                return "Ntilde";
            }
            case '\u00d2': {
                return "Ograve";
            }
            case '\u00d3': {
                return "Oacute";
            }
            case '\u00d4': {
                return "Ocirc";
            }
            case '\u00d5': {
                return "Otilde";
            }
            case '\u00d6': {
                return "Ouml";
            }
            case '\u00d7': {
                return "times";
            }
            case '\u00d8': {
                return "Oslash";
            }
            case '\u00d9': {
                return "Ugrave";
            }
            case '\u00da': {
                return "Uacute";
            }
            case '\u00db': {
                return "Ucirc";
            }
            case '\u00dc': {
                return "Uuml";
            }
            case '\u00dd': {
                return "Yacute";
            }
            case '\u00de': {
                return "THORN";
            }
            case '\u00df': {
                return "szlig";
            }
            case '\u00e0': {
                return "agrave";
            }
            case '\u00e1': {
                return "aacute";
            }
            case '\u00e2': {
                return "acirc";
            }
            case '\u00e3': {
                return "atilde";
            }
            case '\u00e4': {
                return "auml";
            }
            case '\u00e5': {
                return "aring";
            }
            case '\u00e6': {
                return "aelig";
            }
            case '\u00e7': {
                return "ccedil";
            }
            case '\u00e8': {
                return "egrave";
            }
            case '\u00e9': {
                return "eacute";
            }
            case '\u00ea': {
                return "ecirc";
            }
            case '\u00eb': {
                return "euml";
            }
            case '\u00ec': {
                return "igrave";
            }
            case '\u00ed': {
                return "iacute";
            }
            case '\u00ee': {
                return "icirc";
            }
            case '\u00ef': {
                return "iuml";
            }
            case '\u00f0': {
                return "eth";
            }
            case '\u00f1': {
                return "ntilde";
            }
            case '\u00f2': {
                return "ograve";
            }
            case '\u00f3': {
                return "oacute";
            }
            case '\u00f4': {
                return "ocirc";
            }
            case '\u00f5': {
                return "otilde";
            }
            case '\u00f6': {
                return "ouml";
            }
            case '\u00f7': {
                return "divide";
            }
            case '\u00f8': {
                return "oslash";
            }
            case '\u00f9': {
                return "ugrave";
            }
            case '\u00fa': {
                return "uacute";
            }
            case '\u00fb': {
                return "ucirc";
            }
            case '\u00fc': {
                return "uuml";
            }
            case '\u00fd': {
                return "yacute";
            }
            case '\u00fe': {
                return "thorn";
            }
            case '\u00ff': {
                return "yuml";
            }
        }
        return null;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("nohref");
        HTML_BOOLEAN_ATTRIBUTES.put("area", hashSet);
        hashSet = new HashSet();
        hashSet.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("img", hashSet);
        hashSet = new HashSet();
        hashSet.add("declare");
        HTML_BOOLEAN_ATTRIBUTES.put("object", hashSet);
        hashSet = new HashSet();
        hashSet.add("noshade");
        HTML_BOOLEAN_ATTRIBUTES.put("hr", hashSet);
        hashSet = new HashSet();
        hashSet.add("compact");
        HTML_BOOLEAN_ATTRIBUTES.put("dl", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("ol", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("ul", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("dir", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("menu", hashSet);
        hashSet = new HashSet();
        hashSet.add("checked");
        hashSet.add("disabled");
        hashSet.add("readonly");
        hashSet.add("ismap");
        HTML_BOOLEAN_ATTRIBUTES.put("input", hashSet);
        hashSet = new HashSet();
        hashSet.add("multiple");
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("select", hashSet);
        hashSet = new HashSet();
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("optgroup", hashSet);
        hashSet = new HashSet();
        hashSet.add("selected");
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("option", hashSet);
        hashSet = new HashSet();
        hashSet.add("disabled");
        hashSet.add("readonly");
        HTML_BOOLEAN_ATTRIBUTES.put("textarea", hashSet);
        hashSet = new HashSet();
        hashSet.add("disabled");
        HTML_BOOLEAN_ATTRIBUTES.put("button", hashSet);
        hashSet = new HashSet();
        hashSet.add("nowrap");
        HTML_BOOLEAN_ATTRIBUTES.put("th", hashSet);
        HTML_BOOLEAN_ATTRIBUTES.put("td", hashSet);
        hashSet = new HashSet();
        hashSet.add("noresize");
        HTML_BOOLEAN_ATTRIBUTES.put("frame", hashSet);
        hashSet = new HashSet();
        hashSet.add("defer");
        HTML_BOOLEAN_ATTRIBUTES.put("script", hashSet);
        HTML_URIS = new HashSet();
        HTML_URIS.add("http://www.w3.org/1999/xhtml");
    }
}

