/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.AttributeSet;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class ElementNode
extends TemplateNode {
    final TemplateNode name;
    final TemplateNode namespace;
    final String uas;
    final Node source;
    final Collection elementExcludeResultPrefixes;

    ElementNode(TemplateNode templateNode, TemplateNode templateNode2, String string, Node node2) {
        this.name = templateNode;
        this.namespace = templateNode2;
        this.uas = string;
        this.source = node2;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        Node node3 = namedNodeMap.getNamedItemNS("http://www.w3.org/1999/XSL/Transform", "exclude-result-prefixes");
        if (node3 != null) {
            this.elementExcludeResultPrefixes = new HashSet();
            StringTokenizer stringTokenizer = new StringTokenizer(node3.getNodeValue());
            while (stringTokenizer.hasMoreTokens()) {
                this.elementExcludeResultPrefixes.add(stringTokenizer.nextToken());
            }
        } else {
            this.elementExcludeResultPrefixes = Collections.EMPTY_SET;
        }
    }

    TemplateNode clone(Stylesheet stylesheet) {
        ElementNode elementNode = new ElementNode(this.name.clone(stylesheet), this.namespace == null ? null : this.namespace.clone(stylesheet), this.uas, this.source);
        if (this.children != null) {
            elementNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            elementNode.next = this.next.clone(stylesheet);
        }
        return elementNode;
    }

    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        Object object;
        Document document = node3 instanceof Document ? (Document)node3 : node3.getOwnerDocument();
        DocumentFragment documentFragment = document.createDocumentFragment();
        this.name.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
        String string = Expr.stringValue(documentFragment);
        String string2 = null;
        if (this.namespace != null) {
            documentFragment = document.createDocumentFragment();
            this.namespace.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
            string2 = Expr.stringValue(documentFragment);
            if (string2.length() == 0) {
                string2 = null;
            }
        } else {
            object = this.getPrefix(string);
            if ("xmlns".equals(object)) {
                int n3 = string.indexOf(58);
                string = string.substring(n3 + 1);
            } else {
                String string3;
                if (object == null) {
                    object = "#default";
                }
                if ((string3 = stylesheet.namespaceAliases.get(object)) != null) {
                    if ("#default".equals(string3)) {
                        string3 = null;
                    }
                    string2 = this.source.lookupNamespaceURI(string3);
                }
                if (object == "#default") {
                    object = null;
                }
                if (string2 == null) {
                    string2 = "xml".equals(object) ? "http://www.w3.org/XML/1998/namespace" : this.source.lookupNamespaceURI((String)object);
                }
            }
        }
        Object object2 = object = string2 != null ? document.createElementNS(string2, string) : document.createElement(string);
        if (node4 != null) {
            node3.insertBefore((Node)object, node4);
        } else {
            node3.appendChild((Node)object);
        }
        stylesheet.addNamespaceNodes(this.source, (Node)object, document, this.elementExcludeResultPrefixes);
        if (this.uas != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.uas, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.addAttributeSet(stylesheet, qName, node2, n, n2, (Node)object, null, stringTokenizer.nextToken());
            }
        }
        if (this.children != null) {
            this.children.apply(stylesheet, qName, node2, n, n2, (Node)object, null);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    final String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 ? null : string.substring(0, n);
    }

    void addAttributeSet(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4, String string) throws TransformerException {
        stylesheet.bindings.global = true;
        for (AttributeSet attributeSet : stylesheet.attributeSets) {
            if (!attributeSet.name.equals(string)) continue;
            if (attributeSet.uas != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(attributeSet.uas, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    this.addAttributeSet(stylesheet, qName, node2, n, n2, node3, node4, stringTokenizer.nextToken());
                }
            }
            if (attributeSet.children == null) continue;
            attributeSet.children.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
        stylesheet.bindings.global = false;
    }

    public boolean references(QName qName) {
        if (this.name != null && this.name.references(qName)) {
            return true;
        }
        if (this.namespace != null && this.namespace.references(qName)) {
            return true;
        }
        return super.references(qName);
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder("element");
        cPStringBuilder.append('[');
        cPStringBuilder.append("name=");
        if (this.namespace != null) {
            cPStringBuilder.append(",namespace=");
            cPStringBuilder.append(this.namespace);
        }
        cPStringBuilder.append(this.name);
        if (this.uas != null) {
            cPStringBuilder.append(",uas=");
            cPStringBuilder.append(this.uas);
        }
        cPStringBuilder.append(']');
        return cPStringBuilder.toString();
    }
}

