/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.javax.swing.text.html.parser.support.Parser;
import gnu.xml.dom.html2.DomHTMLDocument;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.TagElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html2.HTMLDocument;

public class DomHTMLParser
extends Parser {
    protected DomHTMLDocument document;
    protected Node cursor;

    public DomHTMLParser(DTD dTD) {
        super(dTD);
    }

    public boolean parseMarkupDeclarations(StringBuffer stringBuffer) throws IOException {
        Comment comment = this.document.createComment(stringBuffer.toString());
        this.cursor.appendChild(comment);
        return false;
    }

    public HTMLDocument parseDocument(Reader reader) throws IOException {
        try {
            this.document = new DomHTMLDocument();
            this.document.setCheckWellformedness(false);
            this.document.setCheckingCharacters(false);
            this.cursor = this.document;
            this.parse(reader);
            DomHTMLDocument domHTMLDocument = this.document;
            this.document = null;
            return domHTMLDocument;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Exception: " + exception.getMessage());
        }
    }

    protected Node createNode(String string) {
        AttributeSet attributeSet;
        Element element = this.document.createElement(string.toLowerCase());
        NamedNodeMap namedNodeMap = element.getAttributes();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        for (attributeSet = this.getAttributes(); attributeSet != null; attributeSet = attributeSet.getResolveParent()) {
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Attr attr = this.document.createAttribute(obj.toString());
                attr.setNodeValue(attributeSet.getAttribute(obj).toString());
                namedNodeMap.setNamedItem(attr);
            }
        }
        return element;
    }

    protected void handleComment(char[] cArray) {
        Comment comment = this.document.createComment(new String(cArray));
        this.cursor.appendChild(comment);
    }

    protected void handleEmptyTag(TagElement tagElement) {
        String string = tagElement.getHTMLTag().toString();
        if (string.equalsIgnoreCase("#pcdata")) {
            return;
        }
        Node node2 = this.createNode(string);
        this.cursor.appendChild(node2);
    }

    protected void handleEndTag(TagElement tagElement) {
        String string = tagElement.getHTMLTag().toString();
        String string2 = this.cursor.getNodeName();
        if (string2 != null && string2.equalsIgnoreCase(string)) {
            this.cursor = this.cursor.getParentNode();
        } else {
            Node node2;
            Node node3 = this.cursor.getParentNode();
            LinkedList<Node> linkedList = new LinkedList<Node>();
            for (node2 = this.cursor; node2 != null && !node2.getNodeName().equalsIgnoreCase(string); node2 = node2.getParentNode()) {
                if (node2 == this.document) continue;
                linkedList.addFirst(node2);
            }
            this.cursor = node2 == null ? this.document : node2.getParentNode();
            for (Node node4 : linkedList) {
                this.cursor.appendChild(node4);
                this.cursor = node4;
            }
        }
    }

    protected void handleStartTag(TagElement tagElement) {
        HTML.Tag tag = tagElement.getHTMLTag();
        Node node2 = this.createNode(tag.toString());
        this.cursor.appendChild(node2);
        this.cursor = node2;
    }

    protected void handleText(char[] cArray) {
        Text text = this.document.createTextNode(cArray, 0, cArray.length);
        this.cursor.appendChild(text);
    }
}

