/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNSResolverContext;
import gnu.xml.dom.DomXPathResult;
import gnu.xml.xpath.DocumentOrderComparator;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathNSResolver;

class DomXPathExpression
implements org.w3c.dom.xpath.XPathExpression {
    final DomDocument doc;
    final XPathExpression expression;
    final XPathNSResolver resolver;

    DomXPathExpression(DomDocument domDocument, String string, XPathNSResolver xPathNSResolver) throws XPathException {
        this.doc = domDocument;
        this.resolver = xPathNSResolver;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        if (xPathNSResolver != null) {
            xPath.setNamespaceContext(new DomNSResolverContext(xPathNSResolver));
        }
        try {
            this.expression = xPath.compile(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new XPathException(51, xPathExpressionException.getMessage());
        }
    }

    public Object evaluate(Node node2, short s, Object object) throws XPathException, DOMException {
        try {
            QName qName = null;
            switch (s) {
                case 3: {
                    qName = XPathConstants.BOOLEAN;
                    break;
                }
                case 1: {
                    qName = XPathConstants.NUMBER;
                    break;
                }
                case 2: {
                    qName = XPathConstants.STRING;
                    break;
                }
                case 8: 
                case 9: {
                    qName = XPathConstants.NODE;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    qName = XPathConstants.NODESET;
                    break;
                }
                default: {
                    throw new XPathException(52, null);
                }
            }
            ArrayList arrayList = this.expression.evaluate(node2, qName);
            switch (s) {
                case 5: 
                case 7: {
                    ArrayList arrayList2 = new ArrayList(arrayList);
                    Collections.sort(arrayList2, new DocumentOrderComparator());
                    arrayList = arrayList2;
                }
            }
            return new DomXPathResult(arrayList, s);
        }
        catch (javax.xml.xpath.XPathException xPathException) {
            throw new XPathException(52, xPathException.getMessage());
        }
    }

    public String toString() {
        return this.getClass().getName() + "[expression=" + this.expression + "]";
    }
}

