/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DTDAttributeTypeInfo;
import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomElement;
import gnu.xml.dom.DomNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DomNamedNodeMap
implements NamedNodeMap {
    final DomNode owner;
    final short type;
    DomNode first;
    int length;
    boolean readonly;

    DomNamedNodeMap(DomNode domNode, short s) {
        this.owner = domNode;
        this.type = s;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public void makeReadonly() {
        this.readonly = true;
        DomNode domNode = this.first;
        while (domNode != null) {
            domNode.makeReadonly();
            domNode = domNode.next;
        }
    }

    public Node getNamedItem(String string) {
        DomNode domNode = this.first;
        while (domNode != null) {
            if (domNode.getNodeName().equals(string)) {
                return domNode;
            }
            domNode = domNode.next;
        }
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        if ("".equals(string)) {
            string = null;
        }
        DomNode domNode = this.first;
        while (domNode != null) {
            String string3 = domNode.getLocalName();
            if (string2 == null && string3 == null || string2 != null && string2.equals(string3)) {
                String string4 = domNode.getNamespaceURI();
                if ("".equals(string4)) {
                    string4 = null;
                }
                if (string == null && string4 == null || string != null && string.equals(string4)) {
                    return domNode;
                }
            }
            domNode = domNode.next;
        }
        return null;
    }

    public Node setNamedItem(Node node2) {
        return this.setNamedItem(node2, false, false);
    }

    public Node setNamedItemNS(Node node2) {
        return this.setNamedItem(node2, true, false);
    }

    Node setNamedItem(Node node2, boolean bl, boolean bl2) {
        String string;
        Object object;
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        DomNode domNode = (DomNode)node2;
        if (!bl2 && domNode.owner != this.owner.owner) {
            throw new DomDOMException(4);
        }
        if (domNode.nodeType != this.type) {
            throw new DomDOMException(3);
        }
        if (domNode.nodeType == 2) {
            object = domNode.parent;
            if (object != null && object != this.owner) {
                throw new DomDOMException(10);
            }
            domNode.parent = this.owner;
            domNode.depth = this.owner.depth + 1;
        }
        object = domNode.getNodeName();
        String string2 = bl ? domNode.getLocalName() : null;
        String string3 = string = bl ? domNode.getNamespaceURI() : null;
        if ("".equals(string)) {
            string = null;
        }
        DomNode domNode2 = null;
        DomNode domNode3 = this.first;
        while (domNode3 != null) {
            boolean bl3 = false;
            if (bl) {
                String string4;
                String string5 = domNode3.getLocalName();
                if (string5 == null) {
                    string5 = domNode3.getNodeName();
                }
                if (string5.equals(string2) && ((string4 = domNode3.getNamespaceURI()) == null && string == null || string4 != null && string4.equals(string))) {
                    bl3 = true;
                }
            } else {
                bl3 = domNode3.getNodeName().equals(object);
            }
            if (bl3) {
                domNode.previous = domNode3.previous;
                domNode.next = domNode3.next;
                if (domNode3.previous != null) {
                    domNode3.previous.next = domNode;
                }
                if (domNode3.next != null) {
                    domNode3.next.previous = domNode;
                }
                if (this.first == domNode3) {
                    this.first = domNode;
                }
                this.reparent(domNode, (String)object, domNode3.index);
                domNode3.parent = null;
                domNode3.next = null;
                domNode3.previous = null;
                domNode3.setDepth(0);
                domNode3.index = 0;
                return domNode3;
            }
            domNode2 = domNode3;
            domNode3 = domNode3.next;
        }
        if (domNode2 != null) {
            domNode2.next = domNode;
            domNode.previous = domNode2;
        } else {
            this.first = domNode;
        }
        ++this.length;
        this.reparent(domNode, (String)object, 0);
        return null;
    }

    void reparent(DomNode domNode, String string, int n) {
        domNode.parent = this.owner;
        domNode.setDepth(this.owner.depth + 1);
        DomNode domNode2 = domNode;
        while (domNode2 != null) {
            domNode2.index = n++;
            domNode2 = domNode2.next;
        }
        boolean bl = "xml:space".equals(string);
        if (bl && this.owner instanceof DomElement) {
            ((DomElement)this.owner).xmlSpace = domNode.getNodeValue();
        }
    }

    public Node removeNamedItem(String string) {
        return this.removeNamedItem(null, string, false);
    }

    public Node removeNamedItemNS(String string, String string2) {
        return this.removeNamedItem(string, string2, true);
    }

    Node removeNamedItem(String string, String string2, boolean bl) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        DomNode domNode = this.first;
        while (domNode != null) {
            String string3;
            boolean bl2 = false;
            String string4 = domNode.getNodeName();
            if (bl) {
                String string5 = domNode.getLocalName();
                if (string2 != null && string2.equals(string5) && ((string3 = domNode.getNamespaceURI()) == null && string == null || string3 != null && string3.equals(string))) {
                    bl2 = true;
                }
            } else {
                bl2 = string4.equals(string2);
            }
            if (bl2) {
                boolean bl3 = "xml:space".equals(string4);
                if (bl3 && this.owner instanceof DomElement) {
                    ((DomElement)this.owner).xmlSpace = "";
                }
                if (domNode.nodeType == 2 && (string3 = this.getDefaultValue(domNode.getNodeName())) != null) {
                    domNode.setNodeValue(string3);
                    ((DomAttr)domNode).setSpecified(false);
                    return null;
                }
                if (domNode == this.first) {
                    this.first = domNode.next;
                }
                if (domNode.previous != null) {
                    domNode.previous.next = domNode.next;
                }
                if (domNode.next != null) {
                    domNode.next.previous = domNode.previous;
                }
                --this.length;
                domNode.previous = null;
                domNode.next = null;
                domNode.parent = null;
                domNode.setDepth(0);
                domNode.index = 0;
                return domNode;
            }
            domNode = domNode.next;
        }
        throw new DomDOMException(8);
    }

    String getDefaultValue(String string) {
        DomDoctype domDoctype = (DomDoctype)this.owner.owner.getDoctype();
        if (domDoctype == null) {
            return null;
        }
        DTDAttributeTypeInfo dTDAttributeTypeInfo = domDoctype.getAttributeTypeInfo(this.owner.getNodeName(), string);
        if (dTDAttributeTypeInfo == null) {
            return null;
        }
        return dTDAttributeTypeInfo.value;
    }

    public Node item(int n) {
        DomNode domNode = this.first;
        for (int i = 0; domNode != null && i < n; ++i) {
            domNode = domNode.next;
        }
        return domNode;
    }

    public int getLength() {
        return this.length;
    }
}

