/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.aelfred2;

import gnu.xml.aelfred2.SAXDriver;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.pipeline.ValidationConsumer;
import java.io.IOException;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public final class XmlReader
implements XMLReader {
    private SAXDriver aelfred2 = new SAXDriver();
    private EventFilter filter = new EventFilter();
    private boolean isValidating;
    private boolean active;

    public XmlReader() {
    }

    public XmlReader(boolean bl) {
        if (bl) {
            this.setErrorHandler(new FatalErrorHandler());
        }
    }

    public ContentHandler getContentHandler() {
        return this.filter.getContentHandler();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        this.filter.setContentHandler(contentHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.filter.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        this.filter.setDTDHandler(dTDHandler);
    }

    public EntityResolver getEntityResolver() {
        return this.aelfred2.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.aelfred2.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.aelfred2.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        this.aelfred2.setErrorHandler(errorHandler);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.active) {
            throw new IllegalStateException("already parsing");
        }
        if (this.getProperty(string) != object) {
            this.filter.setProperty(string, object);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string) || "http://xml.org/sax/properties/lexical-handler".equals(string)) {
            return this.filter.getProperty(string);
        }
        throw new SAXNotRecognizedException(string);
    }

    private void forceValidating() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.aelfred2.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        this.aelfred2.setFeature("http://xml.org/sax/features/external-general-entities", true);
        this.aelfred2.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean bl2 = this.getFeature(string);
        if (bl == bl2) {
            return;
        }
        if ("http://xml.org/sax/features/validation".equals(string)) {
            if (this.active) {
                throw new SAXNotSupportedException("already parsing");
            }
            if (bl) {
                this.forceValidating();
            }
            this.isValidating = bl;
        } else {
            this.aelfred2.setFeature(string, bl);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            return this.isValidating;
        }
        return this.aelfred2.getFeature(string);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.aelfred2.setLocale(locale);
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws SAXException, IOException {
        EventFilter eventFilter;
        SAXDriver sAXDriver = this.aelfred2;
        synchronized (sAXDriver) {
            if (this.active) {
                throw new IllegalStateException("already parsing");
            }
            this.active = true;
        }
        if (this.isValidating) {
            this.forceValidating();
            eventFilter = new ValidationConsumer(this.filter);
        } else {
            eventFilter = this.filter;
        }
        boolean bl = this.aelfred2.getFeature("http://xml.org/sax/features/namespace-prefixes");
        EventFilter.bind(this.aelfred2, eventFilter);
        if (!bl) {
            this.aelfred2.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        try {
            this.aelfred2.parse(inputSource);
            Object var7_6 = null;
            this.active = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.active = false;
            throw throwable;
        }
    }

    static class FatalErrorHandler
    extends DefaultHandler2 {
        FatalErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

