/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support.low;

import gnu.javax.swing.text.html.parser.support.low.Location;

public class Token {
    public Location where;
    public int category;
    public int kind;
    private String stringImage;
    private char charImage;

    public Token() {
    }

    public Token(int n, Location location) {
        this.kind = n;
        this.where = location;
    }

    public Token(int n, char c, Location location) {
        this.kind = n;
        this.charImage = c;
        this.where = location;
    }

    public Token(int n, String string, Location location) {
        this.kind = n;
        this.stringImage = string;
        this.where = location;
    }

    public Token(int n, int n2, String string, Location location) {
        this.kind = n;
        this.category = n2;
        this.stringImage = string;
        this.where = location;
    }

    public Token(Token token, Token token2) {
        this.where = new Location();
        this.where.beginLine = token.where.beginLine;
        this.where.startPosition = token.where.startPosition;
        this.where.endLine = token2.where.endLine;
        this.where.endPosition = token2.where.endPosition;
    }

    public String getImage() {
        if (this.kind == 3) {
            return "#";
        }
        if (this.stringImage == null) {
            if (this.charImage == '\u0000') {
                return null;
            }
            this.stringImage = new String(new char[]{this.charImage});
        }
        return this.stringImage;
    }

    public void appendTo(StringBuffer stringBuffer) {
        if (this.charImage == '\u0000') {
            stringBuffer.append(this.getImage());
        } else {
            stringBuffer.append(this.charImage);
        }
    }

    public String toString() {
        return this.getImage() != null ? this.kind + "'" + this.getImage() : "<line " + this.where.beginLine + ", abs pos " + this.where.startPosition + ".." + this.where.endPosition + ">";
    }
}

