/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.swing.text.html.parser.htmlAttributeSet;
import gnu.javax.swing.text.html.parser.models.node;
import gnu.javax.swing.text.html.parser.models.transformer;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.parser.AttributeList;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.TagElement;

public abstract class htmlValidator {
    protected final DTD dtd;
    protected final LinkedList stack = new LinkedList();

    public htmlValidator(DTD dTD) {
        this.dtd = dTD;
    }

    public void closeAll() {
        while (!this.stack.isEmpty()) {
            hTag hTag2 = (hTag)this.stack.getLast();
            if (!hTag2.forcibly_closed && !hTag2.element.omitEnd()) {
                this.s_error("Unclosed <" + hTag2.tag + ">, closing at the end of stream");
            }
            this.handleSupposedEndTag(hTag2.element);
            this.closeTag(hTag2.tgElement);
        }
    }

    public boolean closeTag(TagElement tagElement) {
        HTML.Tag tag = tagElement.getHTMLTag();
        if (!this.stack.isEmpty()) {
            ListIterator listIterator = this.stack.listIterator(this.stack.size());
            while (listIterator.hasPrevious()) {
                hTag hTag2 = (hTag)listIterator.previous();
                if (!tag.equals(hTag2.tag)) continue;
                if (hTag2.forcibly_closed && !hTag2.element.omitEnd()) {
                    this.s_error("The tag <" + hTag2.tag + "> has already been forcibly closed");
                }
                if (hTag2.element.content != null) {
                    hTag hTag3;
                    listIterator = this.stack.listIterator(this.stack.size());
                    while (listIterator.hasPrevious() && (hTag3 = (hTag)listIterator.previous()) != hTag2) {
                        this.handleSupposedEndTag(hTag3.element);
                        listIterator.remove();
                    }
                }
                this.stack.remove(hTag2);
                return true;
            }
        }
        this.s_error("Closing unopened <" + tag + ">");
        return false;
    }

    public void openTag(TagElement tagElement, htmlAttributeSet htmlAttributeSet2) {
        Object object;
        if (tagElement.fictional()) {
            return;
        }
        this.validateParameters(tagElement, htmlAttributeSet2);
        if (this.stack.isEmpty() && tagElement.getHTMLTag() != HTML.Tag.HTML) {
            object = this.dtd.getElement(HTML.Tag.HTML.toString());
            this.openFictionalTag((Element)object);
        }
        if ((object = this.tagIsValidForContext(tagElement)) != Boolean.TRUE) {
            if (object instanceof Element) {
                int n = 0;
                while (object instanceof Element && n++ < 100) {
                    Element element = (Element)object;
                    node node2 = this.getCurrentContentModel();
                    if (node2 != null) {
                        node2.show(element);
                    }
                    this.openFictionalTag(element);
                    Object object2 = this.tagIsValidForContext(tagElement);
                    if (object2 instanceof Element) {
                        this.openFictionalTag((Element)object2);
                        Object object3 = this.tagIsValidForContext(tagElement);
                        if (object3 instanceof Element) {
                            this.openFictionalTag((Element)object3);
                        }
                    } else if (object2 == Boolean.FALSE && element.omitEnd()) {
                        this.closeLast();
                        object2 = this.tagIsValidForContext(tagElement);
                        if (object2 instanceof Element) {
                            this.openFictionalTag((Element)object2);
                        }
                    }
                    object = this.tagIsValidForContext(tagElement);
                }
            } else if (!this.stack.isEmpty()) {
                do {
                    hTag hTag2 = (hTag)this.stack.getLast();
                    if (!hTag2.element.omitEnd()) break;
                    this.closeLast();
                    object = this.tagIsValidForContext(tagElement);
                    if (!(object instanceof Element)) continue;
                    this.openFictionalTag((Element)object);
                    break;
                } while (object == Boolean.FALSE && !this.stack.isEmpty());
            }
        }
        this.stack.add(new hTag(tagElement));
    }

    public void restart() {
        this.stack.clear();
    }

    public Object tagIsValidForContext(TagElement tagElement) {
        node node2 = this.getCurrentContentModel();
        if (node2 != null) {
            return node2.show(tagElement.getElement());
        }
        ListIterator listIterator = this.stack.listIterator(this.stack.size());
        hTag hTag2 = null;
        int n = tagElement.getElement().index;
        if (n >= 0) {
            BitSet bitSet = new BitSet();
            while (listIterator.hasPrevious()) {
                hTag2 = (hTag)listIterator.previous();
                if (hTag2.forcibly_closed) continue;
                if (hTag2.element.exclusions != null && hTag2.element.exclusions.get(n)) {
                    return Boolean.FALSE;
                }
                if (hTag2.element.inclusions == null) continue;
                bitSet.or(hTag2.element.inclusions);
            }
            if (!bitSet.get(n)) {
                Element element = this.dtd.getElement("p");
                if (bitSet.get(element.index)) {
                    return element;
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public void validateTag(TagElement tagElement, htmlAttributeSet htmlAttributeSet2) {
        this.openTag(tagElement, htmlAttributeSet2);
        this.closeTag(tagElement);
    }

    protected void checkContentModel(TagElement tagElement, boolean bl) {
        if (this.stack.isEmpty()) {
            return;
        }
        hTag hTag2 = (hTag)this.stack.getLast();
        if (hTag2.validationTrace == null) {
            return;
        }
        Object object = hTag2.validationTrace.show(tagElement.getElement());
        if (object == Boolean.FALSE) {
            this.s_error("The <" + hTag2.element + "> does not match the content model " + hTag2.validationTrace);
        } else if (object instanceof Element) {
            if (!bl) {
                this.closeTag(hTag2.tgElement);
            }
            this.handleSupposedStartTag((Element)object);
            this.openTag(new TagElement((Element)object), null);
        }
    }

    protected abstract void handleSupposedEndTag(Element var1);

    protected abstract void handleSupposedStartTag(Element var1);

    protected abstract void s_error(String var1);

    protected void validateParameters(TagElement tagElement, htmlAttributeSet htmlAttributeSet2) {
        if (htmlAttributeSet2 == null || htmlAttributeSet2 == htmlAttributeSet.EMPTY_HTML_ATTRIBUTE_SET || htmlAttributeSet2 == SimpleAttributeSet.EMPTY) {
            return;
        }
        Enumeration enumeration = htmlAttributeSet2.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.validateAttribute(tagElement, htmlAttributeSet2, enumeration);
        }
        AttributeList attributeList = tagElement.getElement().getAttributes();
        while (attributeList != null) {
            if (attributeList.getModifier() == 2 && htmlAttributeSet2.getAttribute(attributeList.getName()) == null) {
                this.s_error("Missing required attribute '" + attributeList.getName() + "' for <" + tagElement.getHTMLTag() + ">");
            }
            attributeList = attributeList.next;
        }
    }

    private node getCurrentContentModel() {
        if (!this.stack.isEmpty()) {
            hTag hTag2 = (hTag)this.stack.getLast();
            return hTag2.validationTrace;
        }
        return null;
    }

    private void closeLast() {
        this.handleSupposedEndTag(((hTag)this.stack.getLast()).element);
        this.stack.removeLast();
    }

    private void openFictionalTag(Element element) {
        this.handleSupposedStartTag(element);
        this.stack.add(new hTag(new TagElement(element, true)));
        if (!element.omitStart()) {
            this.s_error("<" + element + "> is expected (supposing it)");
        }
    }

    private void validateAttribute(TagElement tagElement, htmlAttributeSet htmlAttributeSet2, Enumeration enumeration) {
        Object e = enumeration.nextElement();
        AttributeList attributeList = tagElement.getElement().getAttribute(e.toString());
        if (attributeList == null) {
            CPStringBuilder cPStringBuilder = new CPStringBuilder("The tag <" + tagElement.getHTMLTag() + "> cannot contain the attribute '" + e + "'. The valid attributes for this tag are: ");
            AttributeList attributeList2 = tagElement.getElement().getAttributes();
            while (attributeList2 != null) {
                cPStringBuilder.append(attributeList2.name.toUpperCase());
                cPStringBuilder.append(' ');
                attributeList2 = attributeList2.next;
            }
            this.s_error(cPStringBuilder.toString());
        } else {
            String string = htmlAttributeSet2.getAttribute(e).toString();
            if (attributeList.type == 12) {
                this.validateNumberAttribute(tagElement, e, string);
            }
            if (attributeList.type == 7 || attributeList.type == 4) {
                this.validateNameOrIdAttribute(tagElement, e, string);
            }
            if (attributeList.values != null) {
                this.validateAttributeWithValueList(tagElement, e, attributeList, string);
            }
        }
    }

    private void validateAttributeWithValueList(TagElement tagElement, Object object, AttributeList attributeList, String string) {
        if (!attributeList.values.contains(string.toLowerCase()) && !attributeList.values.contains(string.toUpperCase())) {
            CPStringBuilder cPStringBuilder = attributeList.values.size() == 1 ? new CPStringBuilder("The attribute '" + object + "' of the tag <" + tagElement.getHTMLTag() + "> cannot have the value '" + string + "'. The only valid value is ") : new CPStringBuilder("The attribute '" + object + "' of the tag <" + tagElement.getHTMLTag() + "> cannot have the value '" + string + "'. The " + attributeList.values.size() + " valid values are: ");
            Enumeration<?> enumeration = attributeList.values.elements();
            while (enumeration.hasMoreElements()) {
                cPStringBuilder.append('\"');
                cPStringBuilder.append(enumeration.nextElement());
                cPStringBuilder.append("\"  ");
            }
            this.s_error(cPStringBuilder.toString());
        }
    }

    private void validateNameOrIdAttribute(TagElement tagElement, Object object, String string) {
        boolean bl = true;
        if (!Character.isLetter(string.charAt(0))) {
            bl = false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || "".indexOf(c) >= 0) continue;
            bl = false;
        }
        if (!bl) {
            this.s_error("The '" + object + "' attribute of the tag <" + tagElement.getHTMLTag() + "> must start from letter and consist of " + "letters, digits, hypens, colons, underscores and periods. " + "It cannot be '" + string + "'");
        }
    }

    private void validateNumberAttribute(TagElement tagElement, Object object, String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.s_error("The '" + object + "' attribute of the tag <" + tagElement.getHTMLTag() + "> must be a valid number and not '" + string + "'");
        }
    }

    protected class hTag {
        protected final Element element;
        protected final HTML.Tag tag;
        protected final TagElement tgElement;
        protected boolean forcibly_closed;
        protected node validationTrace;

        protected hTag(TagElement tagElement) {
            this.element = tagElement.getElement();
            this.tag = tagElement.getHTMLTag();
            this.tgElement = tagElement;
            if (this.element.content != null) {
                this.validationTrace = transformer.transform(this.element.content, htmlValidator.this.dtd);
            }
        }

        protected void forciblyCloseDueContext() {
            this.forcibly_closed = true;
        }

        protected void forciblyCloseDueEndOfStream() {
            this.forcibly_closed = true;
            htmlValidator.this.handleSupposedEndTag(this.element);
        }
    }
}

