/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

public class FontSize {
    private String value;
    private int size;
    private int sizeIndex;
    private boolean isRelative;
    public static final int DEFAULT_FONT_SIZE = 12;
    private static final double[] SCALE = new double[]{0.8, 0.9, 1.0, 1.2, 1.4, 1.6, 1.8};

    public FontSize(String string) {
        this.value = string;
        this.sizeIndex = -1;
        this.isRelative = false;
        this.size = this.mapValue();
    }

    public int getValue(int n) {
        if (this.isRelative) {
            this.mapRelative(n);
        }
        return this.size;
    }

    public int getValue() {
        assert (!this.isRelative);
        return this.size;
    }

    private int mapValue() {
        int n;
        if (this.value.contains("pt")) {
            n = this.mapPoints();
        } else if (this.value.contains("px")) {
            n = this.mapPixels();
        } else if (this.value.contains("em") || this.value.contains("%") || this.value.contains("larger") || this.value.contains("smaller")) {
            n = -1;
            this.isRelative = true;
        } else {
            n = this.mapAbsolute();
        }
        return n;
    }

    private int mapPoints() {
        int n = this.value.indexOf("pt");
        String string = this.value.substring(0, n);
        int n2 = (int)Double.parseDouble(string);
        return n2;
    }

    private int mapPixels() {
        int n = this.value.indexOf("px");
        if (n == -1) {
            n = this.value.length();
        }
        String string = this.value.substring(0, n);
        try {
            int n2 = (int)Double.parseDouble(string);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return 12;
        }
    }

    private int mapPercent(int n) {
        int n2 = this.value.indexOf("%");
        if (n2 == -1) {
            n2 = this.value.length();
        }
        String string = this.value.substring(0, n2);
        try {
            int n3 = (int)Double.parseDouble(string);
            return n3 * n / 100;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("couldn't map value: '" + this.value + "'");
            return 12;
        }
    }

    private int mapEM(int n) {
        int n2 = this.value.indexOf("em");
        if (n2 == -1) {
            n2 = this.value.length();
        }
        String string = this.value.substring(0, n2);
        try {
            float f = Float.parseFloat(string);
            return (int)(f * (float)n);
        }
        catch (NumberFormatException numberFormatException) {
            return 12;
        }
    }

    private int mapSmaller(int n) {
        return (int)((double)n * 0.9);
    }

    private int mapLarger(int n) {
        return (int)((double)n * 0.9);
    }

    private int mapAbsolute() {
        int n = this.value.equals("xx-small") || this.value.equals("x-small") ? 0 : (this.value.equals("small") ? 1 : (this.value.equals("medium") ? 2 : (this.value.equals("large") ? 3 : (this.value.equals("x-large") ? 4 : (this.value.equals("xx-large") ? 5 : 2)))));
        double d = SCALE[n];
        int n2 = (int)(d * 12.0);
        this.sizeIndex = n;
        return n2;
    }

    public String toString() {
        return this.value;
    }

    private int mapRelative(int n) {
        if (this.value.indexOf(37) != -1) {
            this.size = this.mapPercent(n);
        } else if (this.value.indexOf("em") != -1) {
            this.size = this.mapEM(n);
        } else if (this.value.indexOf("larger") != -1) {
            this.size = this.mapLarger(n);
        } else if (this.value.indexOf("smaller") != -1) {
            this.size = this.mapSmaller(n);
        }
        return this.size;
    }

    public boolean isRelative() {
        return this.isRelative;
    }
}

