/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

import gnu.javax.swing.text.html.css.CSSParserCallback;
import gnu.javax.swing.text.html.css.CSSParserException;
import gnu.javax.swing.text.html.css.CSSScanner;
import gnu.javax.swing.text.html.css.Selector;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;

public class CSSParser {
    private CSSScanner scanner;
    private CSSParserCallback callback;
    private int lookahead;
    private String error;

    public CSSParser(Reader reader, CSSParserCallback cSSParserCallback) {
        this.scanner = new CSSScanner(reader);
        this.callback = cSSParserCallback;
        this.lookahead = -1;
    }

    public void parse() throws IOException {
        boolean bl = this.parseStylesheet();
        if (!bl) {
            throw new CSSParserException(this.error);
        }
    }

    private boolean parseStylesheet() throws IOException {
        int n = this.peekToken();
        while (n != -1 && (n == 12 || n == 11 || n == 18 || this.parseStatement())) {
            if (n == 12 || n == 11 || n == 18) {
                this.readToken();
            }
            n = this.peekToken();
        }
        return n == -1;
    }

    private boolean parseStatement() throws IOException {
        return this.parseRuleset() || this.parseAtRule();
    }

    private boolean parseRuleset() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.parseSelector(stringBuilder);
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder.toString(), ",");
        Selector[] selectorArray = new Selector[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            selectorArray[n] = new Selector(string);
            ++n;
        }
        this.callback.startStatement(selectorArray);
        while ((n = this.readToken()) == 18) {
        }
        boolean bl = true;
        if (n == 14) {
            while ((n = this.readToken()) == 18) {
            }
            this.lookahead = n;
            boolean bl2 = this.parseDeclaration();
            n = this.peekToken();
            while (n == 13) {
                this.readToken();
                while ((n = this.readToken()) == 18) {
                }
                this.lookahead = n;
                this.parseDeclaration();
                n = this.peekToken();
            }
            if (n != 15) {
                this.error = "Expected right curly brace";
                bl = false;
            } else {
                this.readToken();
                while ((n = this.readToken()) == 18) {
                }
                this.lookahead = n;
                this.callback.endStatement();
            }
        } else {
            bl = false;
            this.error = "Expected left curly brace";
        }
        return bl;
    }

    private boolean parseDeclaration() throws IOException {
        int n = this.readToken();
        if (n == 23) {
            n = this.readToken();
        }
        boolean bl = true;
        String string = null;
        if (n == 1) {
            string = new String(this.scanner.parseBuffer, 0, this.scanner.tokenEnd);
            while ((n = this.readToken()) == 18) {
            }
            if (n == 23 && this.scanner.parseBuffer[0] == ':') {
                while ((n = this.readToken()) == 18) {
                }
                this.lookahead = n;
                StringBuilder stringBuilder = new StringBuilder();
                if (this.parseValue(stringBuilder)) {
                    this.callback.declaration(string, stringBuilder.toString().trim());
                } else {
                    bl = false;
                    this.error = "Error while reading the property value";
                }
            } else {
                bl = false;
                this.error = "Expected colon to separate property and value";
            }
        } else {
            this.lookahead = n;
            bl = false;
            this.error = "Expected IDENT token for property";
        }
        return bl;
    }

    private boolean parseValue(StringBuilder stringBuilder) throws IOException {
        boolean bl = this.parseAny(stringBuilder);
        while (this.parseAny(stringBuilder)) {
        }
        return bl;
    }

    private boolean parseSelector(StringBuilder stringBuilder) throws IOException {
        boolean bl = this.parseAny(stringBuilder);
        if (bl) {
            while (this.parseAny(stringBuilder)) {
            }
        }
        return bl;
    }

    private boolean parseAny(StringBuilder stringBuilder) throws IOException {
        int n = this.peekToken();
        boolean bl = false;
        if (n == 1 || n == 6 || n == 7 || n == 8 || n == 3 || n == 23 || n == 9 || n == 5 || n == 10 || n == 21 || n == 22) {
            if (stringBuilder != null) {
                stringBuilder.append(this.scanner.parseBuffer, 0, this.scanner.tokenEnd);
            }
            this.readToken();
            bl = true;
        } else if (n == 20) {
            System.err.println("Implement parseAny for FUNCTION");
        } else if (n == 16) {
            System.err.println("Implement parseAny for (");
        } else if (n == 16) {
            System.err.println("Implement parseAny for [");
        }
        n = this.peekToken();
        while (n == 18) {
            if (stringBuilder != null) {
                stringBuilder.append(this.scanner.parseBuffer, 0, this.scanner.tokenEnd);
            }
            this.readToken();
            n = this.peekToken();
        }
        return bl;
    }

    private boolean parseAtRule() throws IOException {
        return false;
    }

    private int readToken() throws IOException {
        int n;
        if (this.lookahead == -1) {
            while ((n = this.scanner.nextToken()) == 19) {
            }
        } else {
            n = this.lookahead;
            this.lookahead = -1;
        }
        return n;
    }

    private int peekToken() throws IOException {
        int n;
        if (this.lookahead == -1) {
            while ((n = this.scanner.nextToken()) == 19) {
            }
            this.lookahead = n;
        } else {
            n = this.lookahead;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            InputStream inputStream;
            Object object;
            if (stringArray.length > 0) {
                object = new File(stringArray[0]);
                inputStream = new FileInputStream((File)object);
            } else {
                object = "/javax/swing/text/html/default.css";
                inputStream = CSSScanner.class.getResourceAsStream((String)object);
            }
            object = new BufferedInputStream(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
            CSSParserCallback cSSParserCallback = new CSSParserCallback(){

                public void startStatement(Selector[] selectorArray) {
                    System.out.print("startStatement: ");
                    for (int i = 0; i < selectorArray.length; ++i) {
                        System.out.print(selectorArray[i]);
                        if (i < selectorArray.length - 1) {
                            System.out.print(',');
                            continue;
                        }
                        System.out.println();
                    }
                }

                public void endStatement() {
                    System.out.println("endStatement");
                }

                public void declaration(String string, String string2) {
                    System.out.println("declaration: " + string + ", " + string2);
                }
            };
            CSSParser cSSParser = new CSSParser(inputStreamReader, cSSParserCallback);
            cSSParser.parse();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

