/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CSSColor {
    private static final HashMap COLOR_MAP = new HashMap();
    private String value;
    private Color color;

    public CSSColor(String string) {
        this.value = string;
        this.color = CSSColor.convertValue(this.value);
    }

    public static Color convertValue(String string) {
        Color color;
        String string2 = string.toLowerCase();
        if (string2.charAt(0) != '#') {
            string2 = (String)COLOR_MAP.get(string2);
        }
        if (string2 != null) {
            String string3 = string2.substring(1).trim();
            try {
                int n = Integer.parseInt(string3, 16);
                color = new Color(n);
            }
            catch (NumberFormatException numberFormatException) {
                color = Color.BLACK;
            }
        } else {
            color = null;
        }
        return color;
    }

    public Color getValue() {
        return this.color;
    }

    public String toString() {
        return this.value;
    }

    public static boolean isValidColor(String string) {
        boolean bl = false;
        if (string.charAt(0) == '#') {
            bl = true;
        } else {
            Set set = COLOR_MAP.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && !bl) {
                String string2 = (String)iterator.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    static {
        COLOR_MAP.put("maroon", "#800000");
        COLOR_MAP.put("red", "#ff0000");
        COLOR_MAP.put("orange", "#ffa500");
        COLOR_MAP.put("yellow", "#ffff00");
        COLOR_MAP.put("olive", "#808000");
        COLOR_MAP.put("purple", "#800080");
        COLOR_MAP.put("fuchsia", "#ff00ff");
        COLOR_MAP.put("white", "#ffffff");
        COLOR_MAP.put("lime", "#00ff00");
        COLOR_MAP.put("green", "#008000");
        COLOR_MAP.put("navy", "#000080");
        COLOR_MAP.put("blue", "#0000ff");
        COLOR_MAP.put("aqua", "#00ffff");
        COLOR_MAP.put("teal", "#008080");
        COLOR_MAP.put("black", "#000000");
        COLOR_MAP.put("silver", "#c0c0c0");
        COLOR_MAP.put("gray", "#808080");
    }
}

