/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.javax.security.auth.callback.AbstractCallbackHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SwingCallbackHandler
extends AbstractCallbackHandler {
    public SwingCallbackHandler() {
        super("SWING");
    }

    protected void handleChoice(final ChoiceCallback choiceCallback) throws IOException {
        final JDialog jDialog = new JDialog();
        jDialog.setResizable(false);
        Container container = jDialog.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(choiceCallback.getPrompt(), 2);
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 5, 5));
        Object[] objectArray = choiceCallback.getChoices();
        final JList jList = new JList(objectArray);
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 30);
        final int n = choiceCallback.getDefaultChoice();
        jList.setSelectedIndex(n);
        jList.setSelectionMode(choiceCallback.allowMultipleSelections() ? 2 : 0);
        container.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        jDialog.getRootPane().setDefaultButton(jButton2);
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                choiceCallback.setSelectedIndex(n);
                jDialog.setVisible(false);
                ChoiceCallback choiceCallback2 = choiceCallback;
                synchronized (choiceCallback2) {
                    choiceCallback.notify();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (choiceCallback.allowMultipleSelections()) {
                    object = jList.getSelectedIndices();
                    if (object != null && ((int[])object).length > 0) {
                        choiceCallback.setSelectedIndexes((int[])object);
                    } else {
                        choiceCallback.setSelectedIndex(n);
                    }
                } else {
                    int n2 = jList.getSelectedIndex();
                    if (n2 != -1) {
                        choiceCallback.setSelectedIndex(n2);
                    } else {
                        choiceCallback.setSelectedIndex(n);
                    }
                }
                jDialog.setVisible(false);
                ChoiceCallback choiceCallback2 = choiceCallback;
                object = choiceCallback2;
                synchronized (choiceCallback2) {
                    choiceCallback.notify();
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    return;
                }
            }
        });
        jDialog.pack();
        jDialog.setSize(new Dimension(400, 400));
        jDialog.setVisible(true);
        this.waitForInput(jDialog, choiceCallback);
    }

    protected void handleConfirmation(final ConfirmationCallback confirmationCallback) throws IOException {
        final JDialog jDialog = new JDialog();
        switch (confirmationCallback.getMessageType()) {
            case 2: {
                jDialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 1: {
                jDialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            case 0: {
                jDialog.setTitle(this.messages.getString("callback.information"));
            }
        }
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        String string = confirmationCallback.getPrompt();
        if (string != null) {
            container.add((Component)new JLabel(string), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 25), 0, 0));
        }
        final String[] stringArray = confirmationCallback.getOptions();
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.equals(stringArray[i])) continue;
                        confirmationCallback.setSelectedIndex(i);
                        break;
                    }
                } else if (string.equals("cancel")) {
                    confirmationCallback.setSelectedIndex(2);
                } else if (string.equals("okay")) {
                    confirmationCallback.setSelectedIndex(3);
                } else if (string.equals("yes")) {
                    confirmationCallback.setSelectedIndex(0);
                } else if (string.equals("no")) {
                    confirmationCallback.setSelectedIndex(1);
                }
                jDialog.setVisible(false);
                ConfirmationCallback confirmationCallback2 = confirmationCallback;
                synchronized (confirmationCallback2) {
                    confirmationCallback.notify();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        switch (confirmationCallback.getOptionType()) {
            case 1: {
                JButton jButton = new JButton(this.messages.getString("callback.cancel"));
                jPanel.add(jButton);
                jButton.setActionCommand("cancel");
                jButton.addActionListener(actionListener);
            }
            case 0: {
                JButton jButton = new JButton(this.messages.getString("callback.yes"));
                JButton jButton2 = new JButton(this.messages.getString("callback.no"));
                jPanel.add(jButton2);
                jPanel.add(jButton);
                jButton.setActionCommand("yes");
                jButton.addActionListener(actionListener);
                jButton2.setActionCommand("no");
                jButton2.addActionListener(actionListener);
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 2: {
                JButton jButton = new JButton(this.messages.getString("callback.ok"));
                JButton jButton3 = new JButton(this.messages.getString("callback.cancel"));
                jPanel.add(jButton3);
                jPanel.add(jButton);
                jButton.setActionCommand("okay");
                jButton.addActionListener(actionListener);
                jButton3.setActionCommand("cancel");
                jButton3.addActionListener(actionListener);
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case -1: {
                for (int i = 0; i < stringArray.length; ++i) {
                    JButton jButton = new JButton(stringArray[i]);
                    jPanel.add(jButton);
                    jButton.setActionCommand(stringArray[i]);
                    jButton.addActionListener(actionListener);
                    if (i != stringArray.length - 1) continue;
                    jDialog.getRootPane().setDefaultButton(jButton);
                }
                break;
            }
        }
        container.add((Component)jPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 14, 1, new Insets(5, 5, 5, 5), 0, 0));
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setVisible(true);
        this.waitForInput(jDialog, confirmationCallback);
    }

    protected void handleLanguage(LanguageCallback languageCallback) throws IOException {
        Object object;
        Locale locale = Locale.getDefault();
        Locale[] localeArray = Locale.getAvailableLocales();
        String[] stringArray = new String[localeArray.length + 1];
        int n = 0;
        for (int i = 0; i < localeArray.length; ++i) {
            stringArray[i + 1] = localeArray[i].getDisplayLanguage(localeArray[i]);
            object = localeArray[i].getDisplayCountry(localeArray[i]);
            if (((String)object).length() > 0) {
                int n2 = i + 1;
                stringArray[n2] = stringArray[n2] + " (" + (String)object + ")";
            }
            if (!localeArray[i].equals(locale)) continue;
            n = i;
        }
        localeArray[0] = locale;
        stringArray[0] = locale.getDisplayLanguage(locale);
        String string = locale.getDisplayCountry(locale);
        if (string.length() > 0) {
            stringArray[0] = stringArray[0] + " (" + string + ")";
        }
        object = new ChoiceCallback(this.messages.getString("callback.language"), stringArray, 0, false);
        this.handleChoice((ChoiceCallback)object);
        int n3 = ((ChoiceCallback)object).getSelectedIndexes()[0];
        if (n3 > 0) {
            languageCallback.setLocale(localeArray[n3 - 1]);
        } else {
            languageCallback.setLocale(locale);
        }
    }

    protected void handleName(final NameCallback nameCallback) throws IOException {
        final JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new JLabel(nameCallback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 3, new Insets(10, 10, 15, 5), 0, 0));
        final JTextField jTextField = new JTextField();
        jTextField.setColumns(20);
        String string = nameCallback.getDefaultName();
        if (string != null) {
            jTextField.setText(string);
        }
        container.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 15, 10), 0, 0));
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("okay")) {
                    nameCallback.setName(jTextField.getText());
                }
                jDialog.setVisible(false);
                NameCallback nameCallback2 = nameCallback;
                synchronized (nameCallback2) {
                    nameCallback.notify();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton2.setActionCommand("okay");
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton2);
        this.waitForInput(jDialog, nameCallback);
    }

    protected void handlePassword(final PasswordCallback passwordCallback) throws IOException {
        final JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new JLabel(passwordCallback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 3, new Insets(10, 10, 15, 5), 0, 0));
        final JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.setColumns(20);
        jPasswordField.setEchoChar(passwordCallback.isEchoOn() ? (char)'\u0000' : '\u2022');
        container.add((Component)jPasswordField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 15, 10), 0, 0));
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("okay")) {
                    passwordCallback.setPassword(jPasswordField.getPassword());
                }
                jDialog.setVisible(false);
                PasswordCallback passwordCallback2 = passwordCallback;
                synchronized (passwordCallback2) {
                    passwordCallback.notify();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton2.setActionCommand("okay");
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton2);
        this.waitForInput(jDialog, passwordCallback);
    }

    protected void handleTextInput(final TextInputCallback textInputCallback) throws IOException {
        final JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)new JLabel(textInputCallback.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 15, 5), 0, 0));
        final JTextArea jTextArea = new JTextArea(24, 80);
        jTextArea.setEditable(true);
        String string = textInputCallback.getDefaultText();
        if (string != null) {
            jTextArea.setText(string);
        }
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        container.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("okay")) {
                    textInputCallback.setText(jTextArea.getText());
                }
                jDialog.setVisible(false);
                TextInputCallback textInputCallback2 = textInputCallback;
                synchronized (textInputCallback2) {
                    textInputCallback.notify();
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.messages.getString("callback.cancel"));
        JButton jButton2 = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        jButton2.setActionCommand("okay");
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton2);
        container.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(true);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton2);
        this.waitForInput(jDialog, textInputCallback);
    }

    protected void handleTextOutput(final TextOutputCallback textOutputCallback) throws IOException {
        final JDialog jDialog = new JDialog();
        switch (textOutputCallback.getMessageType()) {
            case 2: {
                jDialog.setTitle(this.messages.getString("callback.error"));
                break;
            }
            case 1: {
                jDialog.setTitle(this.messages.getString("callback.warning"));
                break;
            }
            case 0: {
                jDialog.setTitle(this.messages.getString("callback.information"));
            }
        }
        Container container = jDialog.getContentPane();
        container.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea(24, 80);
        jTextArea.setEditable(false);
        jTextArea.setText(textOutputCallback.getMessage());
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        container.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                TextOutputCallback textOutputCallback2 = textOutputCallback;
                synchronized (textOutputCallback2) {
                    textOutputCallback.notify();
                }
            }
        };
        JButton jButton = new JButton(this.messages.getString("callback.ok"));
        jButton.setActionCommand("okay");
        jButton.addActionListener(actionListener);
        container.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 10, 10, 10), 0, 0));
        jDialog.setResizable(true);
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.getRootPane().setDefaultButton(jButton);
        this.waitForInput(jDialog, textOutputCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInput(JDialog jDialog, Callback callback) {
        Callback callback2 = callback;
        synchronized (callback2) {
            while (jDialog.isVisible()) {
                try {
                    callback.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        jDialog.dispose();
    }
}

