/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.java.security.Engine;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public abstract class AbstractCallbackHandler
implements CallbackHandler {
    private static final String SERVICE = "CallbackHandler";
    protected final ResourceBundle messages = PropertyResourceBundle.getBundle("gnu/javax/security/auth/callback/MessagesBundle");
    private final String name;

    protected AbstractCallbackHandler(String string) {
        this.name = string;
    }

    public static CallbackHandler getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return AbstractCallbackHandler.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static CallbackHandler getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return AbstractCallbackHandler.getInstance(string, provider);
    }

    public static CallbackHandler getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        StringBuilder stringBuilder = new StringBuilder("CallbackHandler of type [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            return (CallbackHandler)Engine.getInstance(SERVICE, string, provider);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(stringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (callbackArray == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < callbackArray.length; ++i) {
            if (callbackArray[i] == null) continue;
            if (callbackArray[i] instanceof ChoiceCallback) {
                this.handleChoice((ChoiceCallback)callbackArray[i]);
                continue;
            }
            if (callbackArray[i] instanceof ConfirmationCallback) {
                this.handleConfirmation((ConfirmationCallback)callbackArray[i]);
                continue;
            }
            if (callbackArray[i] instanceof LanguageCallback) {
                this.handleLanguage((LanguageCallback)callbackArray[i]);
                continue;
            }
            if (callbackArray[i] instanceof NameCallback) {
                this.handleName((NameCallback)callbackArray[i]);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                this.handlePassword((PasswordCallback)callbackArray[i]);
                continue;
            }
            if (callbackArray[i] instanceof TextInputCallback) {
                this.handleTextInput((TextInputCallback)callbackArray[i]);
                continue;
            }
            if (callbackArray[i] instanceof TextOutputCallback) {
                this.handleTextOutput((TextOutputCallback)callbackArray[i]);
                continue;
            }
            this.handleOther(callbackArray[i]);
        }
    }

    public final String getName() {
        return this.name;
    }

    protected abstract void handleChoice(ChoiceCallback var1) throws IOException;

    protected abstract void handleConfirmation(ConfirmationCallback var1) throws IOException;

    protected abstract void handleLanguage(LanguageCallback var1) throws IOException;

    protected abstract void handleName(NameCallback var1) throws IOException;

    protected abstract void handlePassword(PasswordCallback var1) throws IOException;

    protected abstract void handleTextInput(TextInputCallback var1) throws IOException;

    protected abstract void handleTextOutput(TextOutputCallback var1) throws IOException;

    protected void handleOther(Callback callback) throws IOException, UnsupportedCallbackException {
        throw new UnsupportedCallbackException(callback);
    }
}

