/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.ipp.IppDelimiterTag;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppUtilities;
import gnu.javax.print.ipp.attribute.UnknownAttribute;
import gnu.javax.print.ipp.attribute.defaults.DocumentFormatDefault;
import gnu.javax.print.ipp.attribute.defaults.JobHoldUntilDefault;
import gnu.javax.print.ipp.attribute.defaults.JobSheetsDefault;
import gnu.javax.print.ipp.attribute.defaults.MediaDefault;
import gnu.javax.print.ipp.attribute.defaults.PrinterResolutionDefault;
import gnu.javax.print.ipp.attribute.job.AttributesCharset;
import gnu.javax.print.ipp.attribute.job.AttributesNaturalLanguage;
import gnu.javax.print.ipp.attribute.job.JobMoreInfo;
import gnu.javax.print.ipp.attribute.job.JobPrinterUri;
import gnu.javax.print.ipp.attribute.job.JobUri;
import gnu.javax.print.ipp.attribute.printer.CharsetConfigured;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import gnu.javax.print.ipp.attribute.printer.NaturalLanguageConfigured;
import gnu.javax.print.ipp.attribute.printer.PrinterCurrentTime;
import gnu.javax.print.ipp.attribute.printer.PrinterDriverInstaller;
import gnu.javax.print.ipp.attribute.supported.CharsetSupported;
import gnu.javax.print.ipp.attribute.supported.DocumentFormatSupported;
import gnu.javax.print.ipp.attribute.supported.GeneratedNaturalLanguageSupported;
import gnu.javax.print.ipp.attribute.supported.JobHoldUntilSupported;
import gnu.javax.print.ipp.attribute.supported.JobSheetsSupported;
import gnu.javax.print.ipp.attribute.supported.MediaSupported;
import gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported;
import gnu.javax.print.ipp.attribute.supported.PrinterUriSupported;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.DateTimeAtCompleted;
import javax.print.attribute.standard.DateTimeAtCreation;
import javax.print.attribute.standard.DateTimeAtProcessing;
import javax.print.attribute.standard.JobImpressionsSupported;
import javax.print.attribute.standard.JobKOctetsSupported;
import javax.print.attribute.standard.JobMediaSheetsSupported;
import javax.print.attribute.standard.JobStateReason;
import javax.print.attribute.standard.JobStateReasons;
import javax.print.attribute.standard.NumberUpSupported;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IppResponse {
    static final Logger logger = SystemLogger.SYSTEM;
    URI uri;
    short operation_id;
    short status_code;
    int request_id;
    List<Map<Class<? extends Attribute>, Set<Attribute>>> operationAttributes;
    List<Map<Class<? extends Attribute>, Set<Attribute>>> printerAttributes;
    List<Map<Class<? extends Attribute>, Set<Attribute>>> jobAttributes;
    List<Map<Class<? extends Attribute>, Set<Attribute>>> unsupportedAttributes;
    byte[] data;

    public IppResponse(URI uRI, short s) {
        this.uri = uRI;
        this.operation_id = s;
        this.operationAttributes = new ArrayList<Map<Class<? extends Attribute>, Set<Attribute>>>();
        this.jobAttributes = new ArrayList<Map<Class<? extends Attribute>, Set<Attribute>>>();
        this.printerAttributes = new ArrayList<Map<Class<? extends Attribute>, Set<Attribute>>>();
        this.unsupportedAttributes = new ArrayList<Map<Class<? extends Attribute>, Set<Attribute>>>();
    }

    protected void setResponseData(InputStream inputStream) throws IppException {
        ResponseReader responseReader = new ResponseReader();
        try {
            responseReader.parseResponse(inputStream);
        }
        catch (IOException iOException) {
            throw new IppException("Exception during response parsing caused by IOException", iOException);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public int getOperationID() {
        return this.operation_id;
    }

    public List<Map<Class<? extends Attribute>, Set<Attribute>>> getJobAttributes() {
        return this.jobAttributes;
    }

    public List<Map<Class<? extends Attribute>, Set<Attribute>>> getOperationAttributes() {
        return this.operationAttributes;
    }

    public List<Map<Class<? extends Attribute>, Set<Attribute>>> getPrinterAttributes() {
        return this.printerAttributes;
    }

    public int getRequestID() {
        return this.request_id;
    }

    public short getStatusCode() {
        return this.status_code;
    }

    public List<Map<Class<? extends Attribute>, Set<Attribute>>> getUnsupportedAttributes() {
        return this.unsupportedAttributes;
    }

    public byte[] getData() {
        return this.data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResponseReader {
        private static final short VERSION = 257;

        ResponseReader() {
        }

        public void parseResponse(InputStream inputStream) throws IppException, IOException {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            short s = dataInputStream.readShort();
            IppResponse.this.status_code = dataInputStream.readShort();
            IppResponse.this.request_id = dataInputStream.readInt();
            if (257 != s) {
                throw new IppException("Version mismatch - implementation does not support other versions than IPP 1.1");
            }
            logger.log(Component.IPP, "Statuscode: " + Integer.toHexString(IppResponse.this.status_code) + " Request-ID: " + IppResponse.this.request_id);
            byte by = 0;
            boolean bl = true;
            block7: while (bl) {
                if (by == 0) {
                    by = dataInputStream.readByte();
                }
                logger.log(Component.IPP, "DelimiterTag: " + Integer.toHexString(by));
                switch (by) {
                    case 3: {
                        bl = false;
                        continue block7;
                    }
                    case 1: {
                        HashMap<Class<? extends Attribute>, Set<Attribute>> hashMap = new HashMap<Class<? extends Attribute>, Set<Attribute>>();
                        by = this.parseAttributes(hashMap, dataInputStream);
                        IppResponse.this.operationAttributes.add(hashMap);
                        continue block7;
                    }
                    case 2: {
                        HashMap<Class<? extends Attribute>, Set<Attribute>> hashMap = new HashMap();
                        by = this.parseAttributes(hashMap, dataInputStream);
                        IppResponse.this.jobAttributes.add(hashMap);
                        continue block7;
                    }
                    case 4: {
                        HashMap<Class<? extends Attribute>, Set<Attribute>> hashMap = new HashMap();
                        by = this.parseAttributes(hashMap, dataInputStream);
                        IppResponse.this.printerAttributes.add(hashMap);
                        continue block7;
                    }
                    case 5: {
                        System.out.println("Called");
                        HashMap<Class<? extends Attribute>, Set<Attribute>> hashMap = new HashMap();
                        by = this.parseAttributes(hashMap, dataInputStream);
                        IppResponse.this.unsupportedAttributes.add(hashMap);
                        continue block7;
                    }
                }
                throw new IppException("Unknown tag with value " + Integer.toHexString(by) + " occured.");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = dataInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            IppResponse.this.data = byteArrayOutputStream.toByteArray();
        }

        private byte parseAttributes(Map<Class<? extends Attribute>, Set<Attribute>> map, DataInputStream dataInputStream) throws IppException, IOException {
            Attribute attribute = null;
            Attribute attribute2 = null;
            byte by;
            while (!IppDelimiterTag.isDelimiterTag(by = dataInputStream.readByte())) {
                String string;
                short s = dataInputStream.readShort();
                if (s == 0) {
                    string = attribute.getName();
                } else {
                    byte[] byArray = new byte[s];
                    dataInputStream.read(byArray);
                    string = new String(byArray);
                }
                short s2 = dataInputStream.readShort();
                byte[] byArray = new byte[s2];
                dataInputStream.read(byArray);
                switch (by) {
                    case 16: 
                    case 18: {
                        throw new IppException("Unexpected name value for out-of-band value tag " + by);
                    }
                    case 19: {
                        attribute2 = null;
                        break;
                    }
                    case 33: {
                        int n = IppUtilities.convertToInt(byArray);
                        attribute2 = IppUtilities.getIntegerAttribute(string, n);
                        break;
                    }
                    case 34: {
                        attribute2 = IppUtilities.getEnumAttribute(string, new Integer(byArray[0]));
                        break;
                    }
                    case 35: {
                        int n = IppUtilities.convertToInt(byArray);
                        attribute2 = IppUtilities.getEnumAttribute(string, new Integer(n));
                        break;
                    }
                    case 48: {
                        throw new IppException("Unspecified octet string occured.");
                    }
                    case 49: {
                        Date date = this.parseDate(byArray);
                        if (string.equals("printer-current-time")) {
                            attribute2 = new PrinterCurrentTime(date);
                            break;
                        }
                        if (string.equals("date-time-at-creation")) {
                            attribute2 = new DateTimeAtCreation(date);
                            break;
                        }
                        if (string.equals("date-time-at-processing")) {
                            attribute2 = new DateTimeAtProcessing(date);
                            break;
                        }
                        if (!string.equals("date-time-at-completed")) break;
                        attribute2 = new DateTimeAtCompleted(date);
                        break;
                    }
                    case 50: {
                        int n = IppUtilities.convertToInt(byArray[0], byArray[1], byArray[2], byArray[3]);
                        int n2 = IppUtilities.convertToInt(byArray[4], byArray[5], byArray[6], byArray[7]);
                        byte by2 = byArray[8];
                        if (string.equals("printer-resolution-default")) {
                            attribute2 = new PrinterResolutionDefault(n, n2, by2);
                            break;
                        }
                        if (!string.equals("printer-resolution-supported")) break;
                        attribute2 = new PrinterResolutionSupported(n, n2, by2);
                        break;
                    }
                    case 51: {
                        int n = IppUtilities.convertToInt(byArray[0], byArray[1], byArray[2], byArray[3]);
                        int n3 = IppUtilities.convertToInt(byArray[4], byArray[5], byArray[6], byArray[7]);
                        if (string.equals("copies-supported")) {
                            attribute2 = new CopiesSupported(n, n3);
                            break;
                        }
                        if (string.equals("number-up-supported")) {
                            attribute2 = new NumberUpSupported(n, n3);
                            break;
                        }
                        if (string.equals("job-k-octets-supported")) {
                            attribute2 = new JobKOctetsSupported(n, n3);
                            break;
                        }
                        if (string.equals("job-impressions-supported")) {
                            attribute2 = new JobImpressionsSupported(n, n3);
                            break;
                        }
                        if (!string.equals("job-media-sheets-supported")) break;
                        attribute2 = new JobMediaSheetsSupported(n, n3);
                        break;
                    }
                    case 53: 
                    case 54: 
                    case 65: 
                    case 66: {
                        attribute2 = IppUtilities.getTextAttribute(string, by, byArray);
                        break;
                    }
                    case 68: {
                        String string2 = new String(byArray);
                        if (string.equals("job-hold-until-supported")) {
                            attribute2 = new JobHoldUntilSupported(string2, null);
                            break;
                        }
                        if (string.equals("job-hold-until-default")) {
                            attribute2 = new JobHoldUntilDefault(string2, null);
                            break;
                        }
                        if (string.equals("media-supported")) {
                            attribute2 = new MediaSupported(string2, null);
                            break;
                        }
                        if (string.equals("media-default")) {
                            attribute2 = new MediaDefault(string2, null);
                            break;
                        }
                        if (string.equals("job-sheets-default")) {
                            attribute2 = new JobSheetsDefault(string2, null);
                            break;
                        }
                        if (string.equals("job-sheets-supported")) {
                            attribute2 = new JobSheetsSupported(string2, null);
                            break;
                        }
                        if (string.equals("job-state-reasons")) {
                            attribute2 = this.parseJobStateReasons(byArray, attribute);
                            break;
                        }
                        if (string.equals("printer-state-reasons")) {
                            attribute2 = this.parsePrinterStateReasons(byArray, attribute);
                            break;
                        }
                        attribute2 = IppUtilities.getEnumAttribute(string, string2);
                        break;
                    }
                    case 69: {
                        URI uRI;
                        try {
                            uRI = new URI(new String(byArray));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new IppException("Wrong URI syntax encountered.", uRISyntaxException);
                        }
                        if (string.equals("job-uri")) {
                            attribute2 = new JobUri(uRI);
                            break;
                        }
                        if (string.equals("job-printer-uri")) {
                            attribute2 = new JobPrinterUri(uRI);
                            break;
                        }
                        if (string.equals("job-more-info")) {
                            attribute2 = new JobMoreInfo(uRI);
                            break;
                        }
                        if (string.equals("printer-uri-supported")) {
                            attribute2 = new PrinterUriSupported(uRI);
                            break;
                        }
                        if (string.equals("printer-more-info")) {
                            attribute2 = new PrinterMoreInfo(uRI);
                            break;
                        }
                        if (string.equals("printer-driver-installer")) {
                            attribute2 = new PrinterDriverInstaller(uRI);
                            break;
                        }
                        if (!string.equals("printer-more-info-manufacturer")) break;
                        attribute2 = new PrinterMoreInfoManufacturer(uRI);
                        break;
                    }
                    case 70: {
                        if (!string.equals("reference-uri-schemes-supported")) break;
                        attribute2 = IppUtilities.getEnumAttribute(string, new String(byArray));
                        break;
                    }
                    case 71: {
                        String string2 = new String(byArray);
                        if (string.equals("attributes-charset")) {
                            attribute2 = new AttributesCharset(string2);
                            break;
                        }
                        if (string.equals("charset-configured")) {
                            attribute2 = new CharsetConfigured(string2);
                            break;
                        }
                        if (!string.equals("charset-supported")) break;
                        attribute2 = new CharsetSupported(string2);
                        break;
                    }
                    case 72: {
                        String string2 = new String(byArray);
                        if (string.equals("attributes-natural-language")) {
                            attribute2 = new AttributesNaturalLanguage(string2);
                            break;
                        }
                        if (string.equals("natural-language-configured")) {
                            attribute2 = new NaturalLanguageConfigured(string2);
                            break;
                        }
                        if (!string.equals("generated-natural-language-supported")) break;
                        attribute2 = new GeneratedNaturalLanguageSupported(string2);
                        break;
                    }
                    case 73: {
                        String string2 = new String(byArray);
                        if (string.equals("document-format-default")) {
                            attribute2 = new DocumentFormatDefault(string2, null);
                            break;
                        }
                        if (string.equals("document-format-supported")) {
                            attribute2 = new DocumentFormatSupported(string2, null);
                            break;
                        }
                        if (!string.equals("document-format")) break;
                        attribute2 = new DocumentFormat(string2, null);
                        break;
                    }
                    default: {
                        throw new IppException("Unknown tag with value " + Integer.toHexString(by) + " found.");
                    }
                }
                if (attribute2 == null) {
                    attribute2 = new UnknownAttribute(by, string, byArray);
                }
                this.addAttribute(map, attribute2);
                attribute = attribute2;
                logger.log(Component.IPP, "Attribute: " + string + " Value: " + attribute2.toString());
            }
            return by;
        }

        private void addAttribute(Map<Class<? extends Attribute>, Set<Attribute>> map, Attribute attribute) {
            Class<? extends Attribute> clazz = attribute.getCategory();
            Set<Attribute> set = map.get(clazz);
            if (set == null) {
                set = new HashSet<Attribute>();
                map.put(clazz, set);
            }
            set.add(attribute);
        }

        private PrinterStateReasons parsePrinterStateReasons(byte[] byArray, Attribute attribute) {
            String string = new String(byArray);
            PrinterStateReasons printerStateReasons = attribute instanceof PrinterStateReasons ? (PrinterStateReasons)attribute : new PrinterStateReasons();
            if (string.equals("none")) {
                return printerStateReasons;
            }
            Severity severity = null;
            PrinterStateReason printerStateReason = null;
            if (string.endsWith(Severity.WARNING.toString())) {
                severity = Severity.WARNING;
            } else if (string.endsWith(Severity.REPORT.toString())) {
                severity = Severity.REPORT;
            } else if (string.endsWith(Severity.ERROR.toString())) {
                severity = Severity.ERROR;
            }
            if (severity != null) {
                string = string.substring(0, string.lastIndexOf(45));
            } else {
                severity = Severity.REPORT;
            }
            printerStateReason = (PrinterStateReason)IppUtilities.getEnumAttribute("printer-state-reason", string);
            printerStateReasons.put(printerStateReason, severity);
            return printerStateReasons;
        }

        private JobStateReasons parseJobStateReasons(byte[] byArray, Attribute attribute) {
            String string = new String(byArray);
            JobStateReasons jobStateReasons = attribute instanceof JobStateReasons ? (JobStateReasons)attribute : new JobStateReasons();
            if (string.equals("none")) {
                return jobStateReasons;
            }
            JobStateReason jobStateReason = (JobStateReason)IppUtilities.getEnumAttribute("job-state-reason", string);
            jobStateReasons.add(jobStateReason);
            return jobStateReasons;
        }

        private Date parseDate(byte[] byArray) {
            short s = IppUtilities.convertToShort(byArray[0], byArray[1]);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, s);
            calendar.set(2, byArray[2]);
            calendar.set(5, byArray[3]);
            calendar.set(11, byArray[4]);
            calendar.set(12, byArray[5]);
            calendar.set(13, byArray[6]);
            calendar.set(14, byArray[7] * 100);
            int n = byArray[9] * 3600000;
            n += byArray[10] * 60000;
            if ((char)byArray[8] == '-') {
                n *= -1;
            }
            calendar.set(15, n);
            return calendar.getTime();
        }
    }
}

